/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingQueueValue;
import com.sun.grid.reporting.dbwriter.ReportingValueManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.sql.Connection;

public class ReportingQueueValueManager
extends ReportingValueManager {
    public ReportingQueueValueManager(Database p_database) throws ReportingException {
        super(p_database, "sge_queue_values", "qv_", true, new ReportingQueueValue(null));
    }

    public void handleNewSubObject(DatabaseObject parent, ReportingEventObject e, Connection connection) throws ReportingException {
        block7: {
            block6: {
                if (e.reportingSource != ReportingSource.STATISTICS) break block6;
                DatabaseField timeField = (DatabaseField)e.data.get("s_time");
                DatabaseField stateField = (DatabaseField)e.data.get("s_qstate");
                this.storeNewValue(parent, timeField, "state", stateField.getValueString(false), null, connection);
                DatabaseField consumableField = (DatabaseField)e.data.get("s_queue_consumable");
                String consumableLine = consumableField.getValueString(false).trim();
                if (consumableLine.length() <= 0) break block7;
                String[] consumableString = consumableLine.split(",", -100);
                for (int i = 0; i < consumableString.length; ++i) {
                    if (consumableString[i].length() <= 0) continue;
                    String[] consumable = consumableString[i].split("=", -100);
                    this.storeNewValue(parent, timeField, consumable[0], consumable[1], consumable[2], connection);
                }
                break block7;
            }
            if (e.reportingSource == ReportingSource.REP_QUEUE) {
                DatabaseField timeField = (DatabaseField)e.data.get("q_time");
                DatabaseField stateField = (DatabaseField)e.data.get("q_state");
                this.storeNewValue(parent, timeField, "state", stateField.getValueString(false), null, connection);
            } else if (e.reportingSource == ReportingSource.REP_QUEUE_CONSUMABLE) {
                DatabaseField timeField = (DatabaseField)e.data.get("qc_time");
                DatabaseField stateField = (DatabaseField)e.data.get("qc_state");
                this.storeNewValue(parent, timeField, "state", stateField.getValueString(false), null, connection);
                DatabaseField consumableField = (DatabaseField)e.data.get("qc_consumables");
                String consumableLine = consumableField.getValueString(false).trim();
                if (consumableLine.length() > 0) {
                    String[] consumableString = consumableLine.split(",", -100);
                    for (int i = 0; i < consumableString.length; ++i) {
                        if (consumableString[i].length() <= 0) continue;
                        String[] consumable = consumableString[i].split("=", -100);
                        this.storeNewValue(parent, timeField, consumable[0], consumable[1], consumable[2], connection);
                    }
                }
            }
        }
    }

    public void storeNewValue(DatabaseObject parent, DatabaseField time, String variable, String value, String config, Connection connection) throws ReportingException {
        try {
            DatabaseObject obj = this.databaseObjectManager.newObject();
            obj.setParent(parent.getId());
            obj.getField("qv_time_start").setValue(time);
            obj.getField("qv_time_end").setValue(time);
            obj.getField("qv_variable").setValue(variable);
            obj.getField("qv_svalue").setValue(value);
            try {
                obj.getField("qv_dvalue").setValue(value);
                if (config != null) {
                    obj.getField("qv_dconfig").setValue(config);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            obj.store(connection);
        }
        catch (ReportingException re) {
            throw re;
        }
        catch (Exception exception) {
            ReportingException re = new ReportingException("ReportingQueueValueManager.createDBObjectError", exception.getMessage());
            re.initCause(exception);
            throw re;
        }
    }

    public void initObjectFromEvent(DatabaseObject obj, ReportingEventObject e) {
    }
}

