/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingQueue;
import com.sun.grid.reporting.dbwriter.ReportingStoredObjectManager;
import com.sun.grid.reporting.dbwriter.ReportingValueManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public class ReportingQueueManager
extends ReportingStoredObjectManager {
    static String[] primaryKeyFields = new String[]{"q_qname", "q_hostname"};
    protected Map accountingMap = new HashMap();
    protected Map statisticsMap;
    protected Map repQueueMap;
    protected Map repQueueConsumableMap;

    public ReportingQueueManager(Database p_database, ReportingValueManager p_valueManager) throws ReportingException {
        super(p_database, "sge_queue", "q_", false, primaryKeyFields, new ReportingQueue(null), null);
        this.accountingMap.put("q_qname", "a_qname");
        this.accountingMap.put("q_hostname", "a_hostname");
        this.statisticsMap = new HashMap();
        this.statisticsMap.put("q_qname", "s_qname");
        this.statisticsMap.put("q_hostname", "s_hostname");
        this.repQueueMap = new HashMap();
        this.repQueueMap.put("q_qname", "q_qname");
        this.repQueueMap.put("q_hostname", "q_qhostname");
        this.repQueueConsumableMap = new HashMap();
        this.repQueueConsumableMap.put("q_qname", "qc_qname");
        this.repQueueConsumableMap.put("q_hostname", "qc_qhostname");
        this.valueManager = p_valueManager;
    }

    public void initObjectFromEvent(DatabaseObject queue, ReportingEventObject e) {
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            this.initObjectFromEventData(queue, e.data, this.accountingMap);
        } else if (e.reportingSource == ReportingSource.STATISTICS) {
            this.initObjectFromEventData(queue, e.data, this.statisticsMap);
        } else if (e.reportingSource == ReportingSource.REP_QUEUE) {
            this.initObjectFromEventData(queue, e.data, this.repQueueMap);
        } else if (e.reportingSource == ReportingSource.REP_QUEUE_CONSUMABLE) {
            this.initObjectFromEventData(queue, e.data, this.repQueueConsumableMap);
        }
    }

    public void initSubObjectsFromEvent(DatabaseObject obj, ReportingEventObject e, Connection connection) throws ReportingException {
        if (e.reportingSource == ReportingSource.STATISTICS || e.reportingSource == ReportingSource.REP_QUEUE || e.reportingSource == ReportingSource.REP_QUEUE_CONSUMABLE) {
            this.valueManager.handleNewSubObject(obj, e, connection);
        }
    }

    public DatabaseObject findObject(ReportingEventObject e, Connection connection) throws ReportingException {
        DatabaseObject obj = null;
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            obj = this.findObjectFromEventData(e.data, this.accountingMap, connection);
        } else if (e.reportingSource == ReportingSource.STATISTICS) {
            obj = this.findObjectFromEventData(e.data, this.statisticsMap, connection);
        } else if (e.reportingSource == ReportingSource.REP_QUEUE) {
            obj = this.findObjectFromEventData(e.data, this.repQueueMap, connection);
        } else if (e.reportingSource == ReportingSource.REP_QUEUE_CONSUMABLE) {
            obj = this.findObjectFromEventData(e.data, this.repQueueConsumableMap, connection);
        }
        return obj;
    }
}

