/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.db.DatabaseObjectManager;
import com.sun.grid.reporting.dbwriter.file.NewObjectListener;
import com.sun.grid.reporting.dbwriter.model.DeletionRuleType;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ReportingObjectManager
implements NewObjectListener {
    protected DatabaseObjectManager databaseObjectManager;
    private ReportingObjectManager parentManager;

    public ReportingObjectManager(DatabaseObjectManager databaseObjectManager) {
        this.databaseObjectManager = databaseObjectManager;
    }

    public ReportingObjectManager(Database database, String table, String prefix, boolean hasParent, DatabaseObject template) throws ReportingException {
        this.databaseObjectManager = new DatabaseObjectManager(database, table, prefix, hasParent, template);
    }

    public void setParentManager(ReportingObjectManager parentManager) {
        this.parentManager = parentManager;
    }

    public ReportingObjectManager getParentManager() {
        return this.parentManager;
    }

    public DatabaseObjectManager getDatabaseObjectManager() {
        return this.databaseObjectManager;
    }

    public void handleNewObject(ReportingEventObject event, Connection connection) throws ReportingException {
        try {
            DatabaseObject obj = this.databaseObjectManager.newObject();
            this.initObjectFromEvent(obj, event);
            obj.store(connection);
            this.initSubObjectsFromEvent(obj, event, connection);
        }
        catch (Exception exception) {
            ReportingException re = new ReportingException("ReportingObjectManager.handleNewObjectFailed", exception.getMessage());
            re.initCause(exception);
            throw re;
        }
    }

    public void handleNewSubObject(DatabaseObject parent, ReportingEventObject e, Connection connection) throws ReportingException {
        try {
            DatabaseObject obj = this.databaseObjectManager.newObject();
            obj.setParent(parent.getId());
            this.initObjectFromEvent(obj, e);
            obj.store(connection);
        }
        catch (Exception exception) {
            ReportingException re = new ReportingException("ReportingObjectManager.handleNewSubObjectFailed", exception.getMessage());
            re.initCause(exception);
            throw re;
        }
    }

    public void initObjectFromEventData(DatabaseObject obj, Map data, Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String objKey = (String)iter.next();
            String dataKey = (String)map.get(objKey);
            DatabaseField objField = obj.getField(objKey);
            DatabaseField dataField = (DatabaseField)data.get(dataKey);
            objField.setValue(dataField);
        }
    }

    public void executeDeleteRule(DeletionRuleType rule, Connection connection) throws ReportingException {
        this.executeDeleteRule(rule.getScope(), rule.getTimeRange(), rule.getTimeAmount(), rule.getSubScope(), connection);
    }

    public void executeDeleteRule(String rule, String time_range, int time_amount, List variables, Connection connection) throws ReportingException {
        SGELog.config("ReportingObjectManager.executeDeleteRule", (Object)time_range, (Object)new Integer(time_amount));
        String[] sql = this.getDeleteRuleSQL(time_range, time_amount, variables);
        if (sql == null) {
            SGELog.warning("ReportingObjectManager.unknownRule", (Object)rule);
        } else {
            for (int i = 0; i < sql.length; ++i) {
                this.databaseObjectManager.execute(sql[i], connection);
            }
        }
    }

    public final String[] getDeleteRuleSQL(String time_range, int time_amount, String values) {
        throw new IllegalStateException("getDeleteRuleSQL should never be invoked");
    }

    public String[] getDeleteRuleSQL(String time_range, int time_amount, List values) {
        return null;
    }

    public void initSubObjectsFromEvent(DatabaseObject obj, ReportingEventObject e, Connection connection) throws ReportingException {
    }

    public abstract void initObjectFromEvent(DatabaseObject var1, ReportingEventObject var2) throws ReportingException;

    public static Timestamp getDeleteTimeEnd(String timeRange, int timeAmount) {
        Calendar now = Calendar.getInstance();
        if (timeRange.compareTo("hour") == 0) {
            now.add(11, -timeAmount);
        } else if (timeRange.compareTo("day") == 0) {
            now.add(5, -timeAmount);
        } else if (timeRange.compareTo("month") == 0) {
            now.add(2, -timeAmount);
        } else if (timeRange.compareTo("year") == 0) {
            now.add(1, -timeAmount);
        } else {
            SGELog.warning("ReportingObjectManager.unkownTimeRange", (Object)timeRange);
        }
        return new Timestamp(now.getTimeInMillis());
    }

    public static Timestamp getDerivedTimeEnd(String timeRange) {
        Calendar now = Calendar.getInstance();
        int delay = 10;
        if (timeRange.compareTo("hour") == 0) {
            if (now.get(12) < delay) {
                now.add(11, -1);
            }
        } else if (timeRange.compareTo("day") == 0) {
            if (now.get(11) == 0 && now.get(12) < delay) {
                now.add(5, -1);
            }
            now.set(11, 0);
        } else if (timeRange.compareTo("month") == 0) {
            if (now.get(5) == 1 && now.get(11) == 0 && now.get(12) < delay) {
                now.add(2, -1);
            }
            now.set(5, 1);
            now.set(11, 0);
        } else if (timeRange.compareTo("year") == 0) {
            if (now.get(6) == 1 && now.get(11) == 0 && now.get(12) < delay) {
                now.add(1, -1);
            }
            now.set(6, 1);
            now.set(11, 0);
        } else {
            SGELog.warning("ReportingObjectManager.unkownTimeRange", (Object)timeRange);
        }
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        return new Timestamp(now.getTimeInMillis());
    }
}

