/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingJobRequest;
import com.sun.grid.reporting.dbwriter.ReportingObjectManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.sql.Connection;

public class ReportingJobRequestManager
extends ReportingObjectManager {
    public ReportingJobRequestManager(Database p_database) throws ReportingException {
        super(p_database, "sge_job_request", "jr_", true, new ReportingJobRequest(null));
    }

    public void handleNewSubObject(DatabaseObject parent, ReportingEventObject e, Connection connection) throws ReportingException {
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            DatabaseField categoryField = (DatabaseField)e.data.get("a_category");
            String category = categoryField.getValueString(false);
            String[] splitCategory = category.split(" +", -100);
            for (int i = 0; i < splitCategory.length; ++i) {
                if (splitCategory[i].compareTo("-q") == 0) {
                    this.storeNewRequest(parent, "queue", splitCategory[i + 1], connection);
                    continue;
                }
                if (splitCategory[i].compareTo("-l") != 0) continue;
                String[] request = splitCategory[i + 1].split(",", -100);
                for (int j = 0; j < request.length; ++j) {
                    String[] contents = request[j].split("=", -100);
                    if (contents.length != 2) {
                        SGELog.warning("ReportingJobRequestManager.splitError", (Object)request[i]);
                        continue;
                    }
                    this.storeNewRequest(parent, contents[0], contents[1], connection);
                }
            }
        }
    }

    public void storeNewRequest(DatabaseObject parent, String variable, String value, Connection connection) throws ReportingException {
        try {
            DatabaseObject obj = this.databaseObjectManager.newObject();
            obj.setParent(parent.getId());
            obj.getField("jr_variable").setValue(variable);
            obj.getField("jr_value").setValue(value);
            obj.store(connection);
        }
        catch (Exception exception) {
            ReportingException ex = new ReportingException("ReportingJobRequestManager.createDBObjectError", exception.getMessage());
            ex.initCause(exception);
            throw ex;
        }
    }

    public void initObjectFromEvent(DatabaseObject obj, ReportingEventObject e) {
    }
}

