/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingJob;
import com.sun.grid.reporting.dbwriter.ReportingJobLogManager;
import com.sun.grid.reporting.dbwriter.ReportingJobRequestManager;
import com.sun.grid.reporting.dbwriter.ReportingJobUsageManager;
import com.sun.grid.reporting.dbwriter.ReportingObjectManager;
import com.sun.grid.reporting.dbwriter.ReportingStoredObjectManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportingJobManager
extends ReportingStoredObjectManager {
    static String[] primaryKeyFields = new String[]{"j_job_number", "j_task_number", "j_pe_taskid"};
    protected Map accountingMap = new HashMap();
    protected Map new_jobMap;
    protected Map job_logMap;
    protected Map job_doneMap;
    protected ReportingJobUsageManager usageManager;
    protected ReportingJobRequestManager requestManager;
    protected ReportingJobLogManager joblogManager;

    public ReportingJobManager(Database p_database, ReportingObjectManager p_jobLogManager) throws ReportingException {
        super(p_database, "sge_job", "j_", false, primaryKeyFields, new ReportingJob(null), "j_open = 1");
        this.accountingMap.put("j_job_number", "a_job_number");
        this.accountingMap.put("j_task_number", "a_task_number");
        this.accountingMap.put("j_pe_taskid", "a_pe_taskid");
        this.accountingMap.put("j_job_name", "a_job_name");
        this.accountingMap.put("j_group", "a_group");
        this.accountingMap.put("j_owner", "a_owner");
        this.accountingMap.put("j_account", "a_account");
        this.accountingMap.put("j_priority", "a_priority");
        this.accountingMap.put("j_submission_time", "a_submission_time");
        this.accountingMap.put("j_project", "a_project");
        this.accountingMap.put("j_department", "a_department");
        this.new_jobMap = new HashMap();
        this.new_jobMap.put("j_job_number", "nj_job_number");
        this.new_jobMap.put("j_task_number", "nj_task_number");
        this.new_jobMap.put("j_pe_taskid", "nj_pe_taskid");
        this.new_jobMap.put("j_job_name", "nj_job_name");
        this.new_jobMap.put("j_owner", "nj_owner");
        this.new_jobMap.put("j_group", "nj_group");
        this.new_jobMap.put("j_project", "nj_project");
        this.new_jobMap.put("j_department", "nj_department");
        this.new_jobMap.put("j_account", "nj_account");
        this.new_jobMap.put("j_priority", "nj_priority");
        this.new_jobMap.put("j_submission_time", "nj_submission_time");
        this.job_doneMap = new HashMap();
        this.job_doneMap.put("j_job_number", "jd_job_number");
        this.job_doneMap.put("j_task_number", "jd_task_number");
        this.job_doneMap.put("j_pe_taskid", "jd_pe_taskid");
        this.job_logMap = new HashMap();
        this.job_logMap.put("j_job_number", "jl_job_number");
        this.job_logMap.put("j_task_number", "jl_task_number");
        this.job_logMap.put("j_pe_taskid", "jl_pe_taskid");
        this.job_logMap.put("j_job_name", "jl_job_name");
        this.job_logMap.put("j_owner", "jl_owner");
        this.job_logMap.put("j_group", "jl_group");
        this.job_logMap.put("j_project", "jl_project");
        this.job_logMap.put("j_department", "jl_department");
        this.job_logMap.put("j_account", "jl_account");
        this.job_logMap.put("j_priority", "jl_priority");
        this.job_logMap.put("j_submission_time", "jl_submission_time");
        this.usageManager = new ReportingJobUsageManager(p_database);
        this.requestManager = new ReportingJobRequestManager(p_database);
        this.joblogManager = (ReportingJobLogManager)p_jobLogManager;
    }

    public void handleNewObject(ReportingEventObject e, Connection connection) throws ReportingException {
        ReportingJob job;
        super.handleNewObject(e, connection);
        if (e.reportingSource == ReportingSource.JOBDONE && (job = (ReportingJob)this.findObject(e, connection)) != null) {
            job.setOpen(0);
            job.store(connection);
        }
    }

    public void initObjectFromEvent(DatabaseObject job, ReportingEventObject e) {
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            this.initObjectFromEventData(job, e.data, this.accountingMap);
        } else if (e.reportingSource == ReportingSource.NEWJOB) {
            this.initObjectFromEventData(job, e.data, this.new_jobMap);
        } else if (e.reportingSource == ReportingSource.JOBLOG) {
            this.initObjectFromEventData(job, e.data, this.job_logMap);
        } else if (e.reportingSource == ReportingSource.JOBDONE) {
            this.initObjectFromEventData(job, e.data, this.job_doneMap);
        }
    }

    public DatabaseObject findObject(ReportingEventObject e, Connection connection) throws ReportingException {
        DatabaseObject obj = null;
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            obj = this.findObjectFromEventData(e.data, this.accountingMap, connection);
        } else if (e.reportingSource == ReportingSource.NEWJOB) {
            obj = this.findObjectFromEventData(e.data, this.new_jobMap, connection);
        } else if (e.reportingSource == ReportingSource.JOBLOG) {
            obj = this.findObjectFromEventData(e.data, this.job_logMap, connection);
        } else if (e.reportingSource == ReportingSource.JOBDONE) {
            obj = this.findObjectFromEventData(e.data, this.job_doneMap, connection);
        }
        return obj;
    }

    public void initSubObjectsFromEvent(DatabaseObject obj, ReportingEventObject e, Connection connection) throws ReportingException {
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            this.requestManager.handleNewSubObject(obj, e, connection);
            this.usageManager.handleNewSubObject(obj, e, connection);
        } else if (e.reportingSource == ReportingSource.JOBLOG) {
            this.joblogManager.handleNewSubObject(obj, e, connection);
        }
    }

    public String[] getDeleteRuleSQL(String time_range, int time_amount, List values) {
        String[] result = new String[4];
        Timestamp time = ReportingJobManager.getDeleteTimeEnd(time_range, time_amount);
        StringBuffer subSelect = new StringBuffer("FROM sge_job WHERE j_submission_time < '");
        subSelect.append(time.toString());
        subSelect.append("'");
        StringBuffer sql = new StringBuffer("DELETE FROM sge_job_request WHERE jr_parent IN (SELECT j_id ");
        sql.append(subSelect.toString());
        sql.append(")");
        result[0] = sql.toString();
        sql = new StringBuffer("DELETE FROM sge_job_usage WHERE ju_parent IN (SELECT j_id ");
        sql.append(subSelect.toString());
        sql.append(")");
        result[1] = sql.toString();
        sql = new StringBuffer("DELETE FROM sge_job_log WHERE jl_parent IN (SELECT j_id ");
        sql.append(subSelect.toString());
        sql.append(")");
        result[2] = sql.toString();
        sql = new StringBuffer("DELETE ");
        sql.append(subSelect.toString());
        result[3] = sql.toString();
        return result;
    }
}

