/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingHostValue;
import com.sun.grid.reporting.dbwriter.ReportingValueManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.sql.Connection;

public class ReportingHostValueManager
extends ReportingValueManager {
    public ReportingHostValueManager(Database p_database) throws ReportingException {
        super(p_database, "sge_host_values", "hv_", true, new ReportingHostValue(null));
    }

    public void handleNewSubObject(DatabaseObject parent, ReportingEventObject e, Connection connection) throws ReportingException {
        block6: {
            block7: {
                block5: {
                    if (e.reportingSource != ReportingSource.STATISTICS) break block5;
                    DatabaseField timeField = (DatabaseField)e.data.get("s_time");
                    DatabaseField loadField = (DatabaseField)e.data.get("s_load");
                    this.storeNewValue(parent, timeField, "load", loadField.getValueString(false), null, connection);
                    DatabaseField vmemField = (DatabaseField)e.data.get("s_vmem");
                    this.storeNewValue(parent, timeField, "vmem", vmemField.getValueString(false), null, connection);
                    DatabaseField consumableField = (DatabaseField)e.data.get("s_host_consumable");
                    String consumableLine = consumableField.getValueString(false).trim();
                    if (consumableLine.length() <= 0) break block6;
                    String[] consumableString = consumableLine.split(",", -100);
                    for (int i = 0; i < consumableString.length; ++i) {
                        if (consumableString[i].length() <= 0) continue;
                        String[] consumable = consumableString[i].split("=", -100);
                        this.storeNewValue(parent, timeField, consumable[0], consumable[1], consumable[2], connection);
                    }
                    break block6;
                }
                if (e.reportingSource != ReportingSource.REP_HOST) break block7;
                DatabaseField timeField = (DatabaseField)e.data.get("h_time");
                DatabaseField loadField = (DatabaseField)e.data.get("h_load");
                String loadLine = loadField.getValueString(false).trim();
                if (loadLine.length() <= 0) break block6;
                String[] loadString = loadLine.split(",", -100);
                for (int i = 0; i < loadString.length; ++i) {
                    if (loadString[i].length() <= 0) continue;
                    String[] load = loadString[i].split("=", -100);
                    this.storeNewValue(parent, timeField, load[0], load[1], null, connection);
                }
                break block6;
            }
            if (e.reportingSource == ReportingSource.REP_HOST_CONSUMABLE) {
                DatabaseField timeField = (DatabaseField)e.data.get("hc_time");
                DatabaseField consumableField = (DatabaseField)e.data.get("hc_consumables");
                String consumableLine = consumableField.getValueString(false).trim();
                if (consumableLine.length() > 0) {
                    String[] consumableString = consumableLine.split(",", -100);
                    for (int i = 0; i < consumableString.length; ++i) {
                        if (consumableString[i].length() <= 0) continue;
                        String[] consumable = consumableString[i].split("=", -100);
                        this.storeNewValue(parent, timeField, consumable[0], consumable[1], consumable[2], connection);
                    }
                }
            }
        }
    }

    public void storeNewValue(DatabaseObject parent, DatabaseField time, String variable, String value, String config, Connection connection) throws ReportingException {
        try {
            DatabaseObject obj = this.databaseObjectManager.newObject();
            obj.setParent(parent.getId());
            obj.getField("hv_time_start").setValue(time);
            obj.getField("hv_time_end").setValue(time);
            obj.getField("hv_variable").setValue(variable);
            obj.getField("hv_svalue").setValue(value);
            try {
                obj.getField("hv_dvalue").setValue(value);
                if (config != null) {
                    obj.getField("hv_dconfig").setValue(config);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            obj.store(connection);
        }
        catch (ReportingException re) {
            throw re;
        }
        catch (Exception exception) {
            ReportingException re = new ReportingException("ReportingHostValueManager.createDBObjectError", exception.getMessage());
            re.initCause(exception);
            throw re;
        }
    }

    public void initObjectFromEvent(DatabaseObject obj, ReportingEventObject e) {
    }
}

