/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingHost;
import com.sun.grid.reporting.dbwriter.ReportingStoredObjectManager;
import com.sun.grid.reporting.dbwriter.ReportingValueManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public class ReportingHostManager
extends ReportingStoredObjectManager {
    static String[] primaryKeyFields = new String[]{"h_hostname"};
    protected Map accountingMap = new HashMap();
    protected Map statisticsMap;
    protected Map repHostMap;
    protected Map repHostConsumableMap;

    public ReportingHostManager(Database p_database, ReportingValueManager p_valueManager) throws ReportingException {
        super(p_database, "sge_host", "h_", false, primaryKeyFields, new ReportingHost(null), null);
        this.accountingMap.put("h_hostname", "a_hostname");
        this.statisticsMap = new HashMap();
        this.statisticsMap.put("h_hostname", "s_hostname");
        this.repHostMap = new HashMap();
        this.repHostMap.put("h_hostname", "h_name");
        this.repHostConsumableMap = new HashMap();
        this.repHostConsumableMap.put("h_hostname", "hc_name");
        this.valueManager = p_valueManager;
    }

    public void initObjectFromEvent(DatabaseObject host, ReportingEventObject e) {
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            this.initObjectFromEventData(host, e.data, this.accountingMap);
        } else if (e.reportingSource == ReportingSource.STATISTICS) {
            this.initObjectFromEventData(host, e.data, this.statisticsMap);
        } else if (e.reportingSource == ReportingSource.REP_HOST) {
            this.initObjectFromEventData(host, e.data, this.repHostMap);
        } else if (e.reportingSource == ReportingSource.REP_HOST_CONSUMABLE) {
            this.initObjectFromEventData(host, e.data, this.repHostConsumableMap);
        }
    }

    public void initSubObjectsFromEvent(DatabaseObject obj, ReportingEventObject e, Connection connection) throws ReportingException {
        if (e.reportingSource == ReportingSource.STATISTICS || e.reportingSource == ReportingSource.REP_HOST || e.reportingSource == ReportingSource.REP_HOST_CONSUMABLE) {
            this.valueManager.handleNewSubObject(obj, e, connection);
        }
    }

    public DatabaseObject findObject(ReportingEventObject e, Connection connection) throws ReportingException {
        DatabaseObject obj = null;
        if (e.reportingSource == ReportingSource.ACCOUNTING) {
            obj = this.findObjectFromEventData(e.data, this.accountingMap, connection);
        } else if (e.reportingSource == ReportingSource.STATISTICS) {
            obj = this.findObjectFromEventData(e.data, this.statisticsMap, connection);
        } else if (e.reportingSource == ReportingSource.REP_HOST) {
            obj = this.findObjectFromEventData(e.data, this.repHostMap, connection);
        } else if (e.reportingSource == ReportingSource.REP_HOST_CONSUMABLE) {
            obj = this.findObjectFromEventData(e.data, this.repHostConsumableMap, connection);
        }
        return obj;
    }
}

