/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.logging.SGEFormatter;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingDepartmentManager;
import com.sun.grid.reporting.dbwriter.ReportingDepartmentValueManager;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingGeneralManager;
import com.sun.grid.reporting.dbwriter.ReportingGroupManager;
import com.sun.grid.reporting.dbwriter.ReportingGroupValueManager;
import com.sun.grid.reporting.dbwriter.ReportingHostManager;
import com.sun.grid.reporting.dbwriter.ReportingHostValueManager;
import com.sun.grid.reporting.dbwriter.ReportingJobLogManager;
import com.sun.grid.reporting.dbwriter.ReportingJobManager;
import com.sun.grid.reporting.dbwriter.ReportingObjectManager;
import com.sun.grid.reporting.dbwriter.ReportingProjectManager;
import com.sun.grid.reporting.dbwriter.ReportingProjectValueManager;
import com.sun.grid.reporting.dbwriter.ReportingQueueManager;
import com.sun.grid.reporting.dbwriter.ReportingQueueValueManager;
import com.sun.grid.reporting.dbwriter.ReportingShareLogManager;
import com.sun.grid.reporting.dbwriter.ReportingStoredObjectManager;
import com.sun.grid.reporting.dbwriter.ReportingUserManager;
import com.sun.grid.reporting.dbwriter.ReportingUserValueManager;
import com.sun.grid.reporting.dbwriter.ReportingValueManager;
import com.sun.grid.reporting.dbwriter.ShutdownHandler;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.file.AccountingFileReader;
import com.sun.grid.reporting.dbwriter.file.ReportFileReader;
import com.sun.grid.reporting.dbwriter.file.ReportingFileReader;
import com.sun.grid.reporting.dbwriter.file.ShareLogFileReader;
import com.sun.grid.reporting.dbwriter.file.StatisticsFileReader;
import com.sun.grid.reporting.dbwriter.model.DbWriterConfig;
import com.sun.grid.reporting.dbwriter.model.DeletionRuleType;
import com.sun.grid.reporting.dbwriter.model.DeriveRuleType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ReportingDBWriter
extends Thread {
    public static final String ENV_PRE = "DBWRITER_";
    public static final String ENV_USER = "DBWRITER_USER";
    public static final String ENV_USER_PW = "DBWRITER_USER_PW";
    public static final String ENV_URL = "DBWRITER_URL";
    public static final String ENV_DRIVER = "DBWRITER_DRIVER";
    public static final String ENV_ACCOUNTING_FILE = "DBWRITER_ACCOUNTING_FILE";
    public static final String ENV_CALC_FILE = "DBWRITER_CALCULATION_FILE";
    public static final String ENV_DELETION_FILE = "DBWRITER_DELETION_FILE";
    public static final String ENV_REPORTING_FILE = "DBWRITER_REPORTING_FILE";
    public static final String ENV_SHARE_LOG_FILE = "DBWRITER_SHARE_LOG_FILE";
    public static final String ENV_STATISTIC_FILE = "DBWRITER_STATISTIC_FILE";
    public static final String ENV_INTERVAL = "DBWRITER_INTERVAL";
    public static final String ENV_CONTINOUS = "DBWRITER_CONTINOUS";
    public static final String ENV_DEBUG = "DBWRITER_DEBUG";
    private static Properties props;
    private String driver = null;
    private String url = null;
    private String logFile = null;
    private String debugLevel = null;
    private String accountingFile = null;
    private String statisticsFile = null;
    private String sharelogFile = null;
    private String reportingFile = null;
    private String calculationFile = null;
    private String deletionFile = null;
    private String userName = System.getProperty("user.name");
    private String userPW = "";
    private boolean continous = false;
    private int interval = 60;
    private Database database;
    private ReportFileReader[] readers;
    private ReportingStoredObjectManager jobManager = null;
    private ReportingObjectManager jobLogManager = null;
    private ReportingStoredObjectManager queueManager = null;
    private ReportingStoredObjectManager hostManager = null;
    private ReportingStoredObjectManager departmentManager = null;
    private ReportingStoredObjectManager projectManager = null;
    private ReportingStoredObjectManager userManager = null;
    private ReportingStoredObjectManager groupManager = null;
    private ReportingObjectManager sharelogManager = null;
    private ReportingGeneralManager generalManager = null;
    private ReportingValueManager queueValueManager = null;
    private ReportingValueManager hostValueManager = null;
    private ReportingValueManager departmentValueManager = null;
    private ReportingValueManager projectValueManager = null;
    private ReportingValueManager userValueManager = null;
    private ReportingValueManager groupValueManager = null;
    private Logger logger;
    private Handler handler;
    private DerivedValueThread derivedValueThread = new DerivedValueThread();
    DbWriterConfig config = null;
    private ReportFileReader currentReader;
    private boolean processingStopped = false;

    public ReportingDBWriter() {
        super("reporting");
    }

    private void setDebugLevel(String level) {
        Level theLevel = null;
        if (level.compareToIgnoreCase("WARNING") == 0) {
            theLevel = Level.WARNING;
        } else if (level.compareToIgnoreCase("INFO") == 0) {
            theLevel = Level.INFO;
        } else if (level.compareToIgnoreCase("CONFIG") == 0) {
            theLevel = Level.CONFIG;
        } else if (level.compareToIgnoreCase("FINE") == 0) {
            theLevel = Level.FINE;
        } else if (level.compareToIgnoreCase("FINER") == 0) {
            theLevel = Level.FINER;
        } else if (level.compareToIgnoreCase("FINEST") == 0) {
            theLevel = Level.FINEST;
        } else if (level.compareToIgnoreCase("ALL") == 0) {
            theLevel = Level.ALL;
        }
        if (theLevel != null) {
            this.logger.setLevel(theLevel);
        } else {
            SGELog.warning("ReportingDBWriter.invalidDebugLevel", (Object)level);
        }
    }

    private void parseCommandLine(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            try {
                if (argv[i].equals("-logfile")) {
                    this.logFile = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-accounting") == 0) {
                    this.accountingFile = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-calculation") == 0) {
                    this.calculationFile = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-continous") == 0) {
                    this.continous = true;
                    continue;
                }
                if (argv[i].compareTo("-deletion") == 0) {
                    this.deletionFile = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-debug") == 0) {
                    this.debugLevel = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-driver") == 0) {
                    this.driver = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-interval") == 0) {
                    this.interval = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].compareTo("-user") == 0) {
                    this.userName = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-reporting") == 0) {
                    this.reportingFile = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-sharelog") == 0) {
                    this.sharelogFile = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-statistics") == 0) {
                    this.statisticsFile = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-url") == 0) {
                    this.url = argv[++i];
                    continue;
                }
                if (argv[i].compareTo("-help") == 0) {
                    ReportingDBWriter.usage(null, true);
                    continue;
                }
                if (argv[i].compareTo("-props") == 0) {
                    ++i;
                    continue;
                }
                ReportingDBWriter.usage("unknown option " + argv[i], true);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ReportingDBWriter.usage("option " + argv[i - 1] + " requires an argument", true);
            }
        }
        if (this.driver == null) {
            ReportingDBWriter.usage("option -driver has to be specified", true);
        }
        if (this.url == null) {
            ReportingDBWriter.usage("option -url has to be specified", true);
        }
    }

    private void checkParams() {
        if (this.accountingFile == null && this.statisticsFile == null && this.sharelogFile == null && this.reportingFile == null) {
            ReportingDBWriter.usage("any input file has to be specified", true);
        }
        if (this.reportingFile != null && (this.accountingFile != null || this.statisticsFile != null)) {
            ReportingDBWriter.usage("don't specify both 6.0 and 5.3 files", true);
        }
        if (this.userName == null) {
            ReportingDBWriter.usage("no db user specified", true);
        }
        if (this.userPW == null) {
            ReportingDBWriter.usage("no password for the db user specified", true);
        }
        if (this.driver == null) {
            ReportingDBWriter.usage("no db driver specified", true);
        }
        if (this.url == null) {
            ReportingDBWriter.usage("no db url specified", true);
        }
    }

    private void initLogging() {
        this.logger = Logger.getLogger("global", "com.sun.grid.reporting.dbwriter.Resources");
        this.logger.setUseParentHandlers(false);
        if (this.logFile == null) {
            this.handler = new ConsoleHandler();
        } else {
            try {
                this.handler = new FileHandler(this.logFile, true);
            }
            catch (IOException ioe) {
                System.err.println("Can't create log file " + this.logFile);
                System.err.println(ioe.getMessage());
                System.exit(1);
            }
        }
        this.handler.setFormatter(new SGEFormatter("dbwriter", true));
        this.logger.addHandler(this.handler);
        LogManager.getLogManager().addLogger(this.logger);
        if (this.debugLevel != null) {
            this.setDebugLevel(this.debugLevel);
        } else {
            this.logger.setLevel(Level.INFO);
        }
        SGELog.init(this.logger);
        SGELog.info("ReportingDBWriter.start");
    }

    public void closeLogging() {
        if (this.handler instanceof FileHandler) {
            try {
                ((FileHandler)this.handler).flush();
                ((FileHandler)this.handler).close();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public void initialize(String[] argv) throws ReportingException {
        this.getOptionFromStdin();
        this.parseCommandLine(argv);
        this.checkParams();
        this.initLogging();
        this.database = new Database(this.driver, this.url, this.userName, this.userPW);
        this.jobLogManager = new ReportingJobLogManager(this.database);
        this.jobManager = new ReportingJobManager(this.database, this.jobLogManager);
        this.queueValueManager = new ReportingQueueValueManager(this.database);
        this.hostValueManager = new ReportingHostValueManager(this.database);
        this.departmentValueManager = new ReportingDepartmentValueManager(this.database);
        this.projectValueManager = new ReportingProjectValueManager(this.database);
        this.userValueManager = new ReportingUserValueManager(this.database);
        this.groupValueManager = new ReportingGroupValueManager(this.database);
        this.queueManager = new ReportingQueueManager(this.database, this.queueValueManager);
        this.hostManager = new ReportingHostManager(this.database, this.hostValueManager);
        this.departmentManager = new ReportingDepartmentManager(this.database, this.departmentValueManager);
        this.projectManager = new ReportingProjectManager(this.database, this.projectValueManager);
        this.userManager = new ReportingUserManager(this.database, this.userValueManager);
        this.groupManager = new ReportingGroupManager(this.database, this.groupValueManager);
        this.queueValueManager.setParentManager(this.queueManager);
        this.hostValueManager.setParentManager(this.hostManager);
        this.departmentValueManager.setParentManager(this.departmentManager);
        this.projectValueManager.setParentManager(this.projectManager);
        this.userValueManager.setParentManager(this.userManager);
        this.groupValueManager.setParentManager(this.groupManager);
        this.sharelogManager = new ReportingShareLogManager(this.database);
        this.readers = new ReportFileReader[4];
        if (this.accountingFile != null) {
            AccountingFileReader accountingFileReader = new AccountingFileReader(this.accountingFile, ":");
            accountingFileReader.addNewObjectListener(this.jobManager);
            accountingFileReader.addNewObjectListener(this.queueManager);
            accountingFileReader.addNewObjectListener(this.hostManager);
            accountingFileReader.addNewObjectListener(this.projectManager);
            accountingFileReader.addNewObjectListener(this.userManager);
            accountingFileReader.addNewObjectListener(this.departmentManager);
            accountingFileReader.addNewObjectListener(this.groupManager);
            this.readers[0] = accountingFileReader;
        }
        if (this.statisticsFile != null) {
            StatisticsFileReader statisticsFileReader = new StatisticsFileReader(this.statisticsFile, ":");
            statisticsFileReader.addNewObjectListener(this.queueManager);
            statisticsFileReader.addNewObjectListener(this.hostManager);
            this.readers[1] = statisticsFileReader;
        }
        if (this.sharelogFile != null) {
            ShareLogFileReader sharelogFileReader = new ShareLogFileReader(this.sharelogFile, ":");
            sharelogFileReader.addNewObjectListener(this.projectManager);
            sharelogFileReader.addNewObjectListener(this.userManager);
            sharelogFileReader.addNewObjectListener(this.sharelogManager);
            this.readers[2] = sharelogFileReader;
        }
        if (this.reportingFile != null) {
            ReportingGeneralManager generalManager = new ReportingGeneralManager(this.database);
            generalManager.addNewObjectListener(this.jobManager, "acct");
            generalManager.addNewObjectListener(this.queueManager, "acct");
            generalManager.addNewObjectListener(this.hostManager, "acct");
            generalManager.addNewObjectListener(this.projectManager, "acct");
            generalManager.addNewObjectListener(this.departmentManager, "acct");
            generalManager.addNewObjectListener(this.userManager, "acct");
            generalManager.addNewObjectListener(this.groupManager, "acct");
            generalManager.addNewObjectListener(this.hostManager, "host");
            generalManager.addNewObjectListener(this.hostManager, "host_consumable");
            generalManager.addNewObjectListener(this.queueManager, "queue");
            generalManager.addNewObjectListener(this.queueManager, "queue_consumable");
            generalManager.addNewObjectListener(this.jobManager, "new_job");
            generalManager.addNewObjectListener(this.jobManager, "job_log");
            generalManager.addNewObjectListener(this.jobManager, "job_done");
            generalManager.addNewObjectListener(this.projectManager, "sharelog");
            generalManager.addNewObjectListener(this.userManager, "sharelog");
            generalManager.addNewObjectListener(this.sharelogManager, "sharelog");
            ReportingFileReader reportingFileReader = new ReportingFileReader(this.reportingFile, ":");
            reportingFileReader.addNewObjectListener(generalManager);
            this.readers[3] = reportingFileReader;
        }
    }

    private static void usage(String message, boolean exit) {
        if (message != null) {
            System.err.println(message);
            System.err.println();
        }
        System.err.println("usage: ReportingDBWriter options");
        System.err.println("options:");
        System.err.println("-logfile <filename>      filename for logging (default SGE_ROOT/SGE_CELL/spool/<hostname>/dbwriter.log");
        System.err.println("-accounting <filename>   filename of accounting file (SGE 5.3)");
        System.err.println("-calculation <filename>  file containing calculation rules");
        System.err.println("-continuous              continous running mode");
        System.err.println("-driver <driver>         JDBC driver name");
        System.err.println("-interval <int>          interval in s for continous");
        System.err.println("-reporting <filename>    filename of reporting file (SGE 6.x)");
        System.err.println("-user <name>             name of reporting db owner");
        System.err.println("-sharelog <filename>     filename of sharelog file (SGE 5.3)");
        System.err.println("-statistics <filename>   filename of statistics file (SGE 5.3)");
        System.err.println("-url <url>               JDBC URL to database");
        if (exit) {
            System.exit(1);
        }
    }

    public ReportingStoredObjectManager getDerivedValueManager(String name) {
        ReportingStoredObjectManager manager = null;
        if (name.compareTo("host") == 0) {
            manager = this.hostManager;
        } else if (name.compareTo("queue") == 0) {
            manager = this.queueManager;
        } else if (name.compareTo("project") == 0) {
            manager = this.projectManager;
        } else if (name.compareTo("department") == 0) {
            manager = this.departmentManager;
        } else if (name.compareTo("user") == 0) {
            manager = this.userManager;
        } else if (name.compareTo("group") == 0) {
            manager = this.groupManager;
        } else {
            SGELog.warning("ReportingDBWriter.invalidObjectClass", (Object)name);
        }
        return manager;
    }

    public ReportingObjectManager getDeleteManager(String name) {
        ReportingObjectManager manager = null;
        if (name.compareTo("host_values") == 0) {
            manager = this.hostValueManager;
        } else if (name.compareTo("queue_values") == 0) {
            manager = this.queueValueManager;
        } else if (name.compareTo("project_values") == 0) {
            manager = this.projectValueManager;
        } else if (name.compareTo("department_values") == 0) {
            manager = this.departmentValueManager;
        } else if (name.compareTo("user_values") == 0) {
            manager = this.userValueManager;
        } else if (name.compareTo("group_values") == 0) {
            manager = this.groupValueManager;
        } else if (name.compareTo("job") == 0) {
            manager = this.jobManager;
        } else if (name.compareTo("job_log") == 0) {
            manager = this.jobLogManager;
        } else if (name.compareTo("share_log") == 0) {
            manager = this.sharelogManager;
        } else {
            SGELog.warning("ReportingDBWriter.invalidObjectClass", (Object)name);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbWriterConfig getDbWriterConfig() throws ReportingException {
        if (this.config == null) {
            ReportingDBWriter reportingDBWriter = this;
            synchronized (reportingDBWriter) {
                if (this.config == null) {
                    try {
                        File calcFile = new File(this.calculationFile);
                        JAXBContext ctx = JAXBContext.newInstance((String)"com.sun.grid.reporting.dbwriter.model");
                        Unmarshaller u = ctx.createUnmarshaller();
                        this.config = (DbWriterConfig)u.unmarshal(calcFile);
                    }
                    catch (JAXBException je) {
                        je.printStackTrace();
                        ReportingException re = new ReportingException("jaxb error");
                        re.initCause(je);
                        throw re;
                    }
                }
            }
        }
        return this.config;
    }

    public void calculateDerivedValues(Connection connection) throws ReportingException {
        DbWriterConfig conf = this.getDbWriterConfig();
        DeriveRuleType rule = null;
        Iterator iter = conf.getDerive().iterator();
        ReportingStoredObjectManager manager = null;
        while (iter.hasNext() && !this.isProcessingStopped()) {
            rule = (DeriveRuleType)iter.next();
            manager = this.getDerivedValueManager(rule.getObject());
            if (manager != null) {
                manager.calculateDerivedValues(rule, connection);
                continue;
            }
            SGELog.warning("No derived value rule for object {0} found", (Object)rule.getObject());
        }
    }

    public void deleteData(Connection connection) throws ReportingException {
        DbWriterConfig conf = this.getDbWriterConfig();
        DeletionRuleType rule = null;
        ReportingObjectManager manager = null;
        Iterator iter = conf.getDelete().iterator();
        while (iter.hasNext() && !this.isProcessingStopped()) {
            try {
                rule = (DeletionRuleType)iter.next();
                manager = this.getDeleteManager(rule.getScope());
                manager.executeDeleteRule(rule.getScope(), rule.getTimeRange(), rule.getTimeAmount(), rule.getSubScope(), connection);
                this.database.commit(connection);
            }
            catch (ReportingException re) {
                this.database.rollback(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(ReportFileReader reader, Database database) throws ReportingException {
        this.currentReader = reader;
        try {
            this.currentReader.processFile(database);
        }
        finally {
            this.currentReader = null;
        }
    }

    public void mainLoop() throws ReportingException {
        boolean done = false;
        Date nextCalculationTime = new Date();
        long currentTime = 0L;
        long nextMillis = 0L;
        do {
            currentTime = System.currentTimeMillis();
            nextMillis = System.currentTimeMillis() + (long)(this.interval * 1000);
            if (this.isProcessingStopped()) break;
            if (!this.database.test() && this.continous) {
                try {
                    ReportingDBWriter.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ire) {
                    break;
                }
            }
            for (int i = 0; i < this.readers.length && !this.isProcessingStopped(); ++i) {
                if (this.readers[i] == null) continue;
                this.processFile(this.readers[i], this.database);
            }
            if (this.isProcessingStopped()) break;
            if (this.continous) {
                block9: {
                    long currentMillis = System.currentTimeMillis();
                    if (nextMillis > currentMillis) {
                        long sleepMillis = nextMillis - currentMillis;
                        SGELog.config("ReportingDBWriter.sleep", new Long(sleepMillis));
                        try {
                            ReportingDBWriter.sleep(sleepMillis);
                            break block9;
                        }
                        catch (InterruptedException ire) {
                            break;
                        }
                    }
                    SGELog.warning("ReportingDBWriter.intervalExpired");
                }
                if (!this.isProcessingStopped()) continue;
                break;
            }
            done = true;
        } while (!done);
    }

    public void run() {
        try {
            this.mainLoop();
        }
        catch (ReportingException re) {
            re.log();
        }
        catch (Exception ex) {
            System.err.println("Uncaught exception " + ex.getMessage());
            ex.printStackTrace();
        }
        System.err.println("ReportingDBWriter.run: finished");
    }

    public void stopProcessing() {
        this.processingStopped = true;
        super.interrupt();
        this.derivedValueThread.interrupt();
        this.database.closeAll();
        for (int i = 0; i < this.readers.length; ++i) {
            if (this.readers[i] == null) continue;
            this.readers[i].stop();
        }
        try {
            while (super.isAlive()) {
                super.join(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isProcessingStopped() {
        return this.processingStopped;
    }

    public void start() {
        super.start();
        this.derivedValueThread.start();
    }

    public static void main(String[] args) {
        ReportingDBWriter writer = new ReportingDBWriter();
        try {
            writer.initialize(args);
            Runtime.getRuntime().addShutdownHook(new ShutdownHandler(writer));
            writer.start();
        }
        catch (ReportingException re) {
            re.log();
        }
    }

    private void getOptionFromStdin() {
        String name = null;
        String value = null;
        HashMap<String, String> options = new HashMap<String, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String line = null;
            int index = 0;
            while ((line = in.readLine()) != null) {
                index = line.indexOf(61);
                if (index <= 0) continue;
                name = line.substring(0, index).trim();
                value = line.substring(index + 1, line.length()).trim();
                if (value.length() <= 0) continue;
                options.put(name, value);
            }
        }
        catch (IOException ioe) {
            SGELog.warning((Throwable)ioe, "ReportingDBWriter.stdinIOError", (Object)ioe.getMessage());
        }
        value = (String)options.remove(ENV_DEBUG);
        if (value != null) {
            this.debugLevel = value;
        }
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            value = (String)options.get(name);
            if (ENV_ACCOUNTING_FILE.equals(name)) {
                this.accountingFile = value;
                continue;
            }
            if (ENV_CALC_FILE.equals(name)) {
                this.calculationFile = value;
                continue;
            }
            if (ENV_CONTINOUS.equals(name)) {
                this.continous = Boolean.valueOf(value);
                continue;
            }
            if (ENV_DELETION_FILE.equals(name)) {
                this.deletionFile = value;
                continue;
            }
            if (ENV_DRIVER.equals(name)) {
                this.driver = value;
                continue;
            }
            if (ENV_INTERVAL.equals(name)) {
                try {
                    this.interval = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    SGELog.warning("ReportingDBWriter.numericalOptionExpected", (Object)ENV_INTERVAL, (Object)value);
                }
                continue;
            }
            if (ENV_USER.equals(name)) {
                this.userName = value;
                continue;
            }
            if (ENV_USER_PW.equals(name)) {
                this.userPW = value;
                continue;
            }
            if (ENV_REPORTING_FILE.equals(name)) {
                this.reportingFile = value;
                continue;
            }
            if (ENV_SHARE_LOG_FILE.equals(name)) {
                this.sharelogFile = value;
                continue;
            }
            if (ENV_STATISTIC_FILE.equals(name)) {
                this.statisticsFile = value;
                continue;
            }
            if (ENV_URL.equals(name)) {
                this.url = value;
                continue;
            }
            SGELog.warning("ReportDBWriter.unknownOption", (Object)name);
        }
    }

    class DerivedValueThread
    extends Thread {
        public DerivedValueThread() {
            super("derive");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Connection connection = null;
            try {
                while (!ReportingDBWriter.this.isProcessingStopped()) {
                    try {
                        connection = ReportingDBWriter.this.database.getConnection();
                        try {
                            if (ReportingDBWriter.this.calculationFile != null) {
                                try {
                                    ReportingDBWriter.this.calculateDerivedValues(connection);
                                }
                                catch (ReportingException re) {
                                    re.log();
                                }
                            }
                            if (ReportingDBWriter.this.deletionFile != null) {
                                try {
                                    ReportingDBWriter.this.deleteData(connection);
                                }
                                catch (ReportingException re) {
                                    re.log();
                                }
                            }
                            if (ReportingDBWriter.this.database.getType() == 1) {
                                try {
                                    ReportingDBWriter.this.database.execute("VACUUM ANALYZE", connection);
                                    ReportingDBWriter.this.database.commit(connection);
                                }
                                catch (ReportingException re) {
                                    re.log();
                                    ReportingDBWriter.this.database.rollback(connection);
                                }
                            }
                        }
                        finally {
                            ReportingDBWriter.this.database.release(connection);
                        }
                    }
                    catch (ReportingException re) {
                        re.log();
                    }
                    Timestamp nextTimestamp = ReportingStoredObjectManager.getDerivedTimeEnd("hour");
                    Date nextCalculationTime = new Date(nextTimestamp.getTime() + 4260000L);
                    SGELog.info("ReportingDBWriter.nextTask", nextCalculationTime);
                    DerivedValueThread.sleep(nextCalculationTime.getTime() - System.currentTimeMillis());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

