/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SGELogRecord
extends LogRecord {
    private boolean needToInferCaller = true;
    public static final String LOG_CLASSNAME = "com.sun.grid.logging.SGELog";

    public SGELogRecord(Level level, String msg) {
        super(level, msg);
    }

    public final String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return super.getSourceClassName();
    }

    public final void setSourceClassName(String sourceClassName) {
        super.setSourceClassName(sourceClassName);
        this.needToInferCaller = false;
    }

    public final String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return super.getSourceMethodName();
    }

    public final void setSourceMethodName(String sourceMethodName) {
        super.setSourceMethodName(sourceMethodName);
        this.needToInferCaller = false;
    }

    private void inferCaller() {
        String cname;
        StackTraceElement frame;
        int ix;
        this.needToInferCaller = false;
        Throwable t = new Throwable();
        StackTraceElement[] stack = t.getStackTrace();
        for (ix = 0; ix < stack.length; ++ix) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(LOG_CLASSNAME)) continue;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(LOG_CLASSNAME)) {
                this.setSourceClassName(cname);
                this.setSourceMethodName(frame.getMethodName());
                return;
            }
            ++ix;
        }
    }
}

