/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class CreateLog {
    private static final String INDENT = "   ";
    private static final ParamType[] PARAM_TYPES = new ParamType[]{new ParamType("Object", null), new ParamType("int", "Integer")};
    private static final int MAX_PARAM_COUNT = 10;
    private static PrintStream ps;
    private static StringBuffer indent;
    private static boolean addIndent;
    private static final String[] PREFIX;
    private static final String[] SUFFIX;
    private static final String[] METHODS;
    private static final String[] LEVELS;
    static /* synthetic */ Class class$com$sun$grid$logging$CreateLog;

    private CreateLog() {
    }

    private static void indent() {
        indent.append(INDENT);
    }

    private static void deindent() {
        indent.setLength(indent.length() - INDENT.length());
    }

    private static void print(String str) {
        if (addIndent) {
            ps.print(indent);
            addIndent = false;
        }
        ps.print(str);
    }

    private static void print(int i) {
        if (addIndent) {
            ps.print(indent);
            addIndent = false;
        }
        ps.print(i);
    }

    private static void println(String str) {
        CreateLog.print(str);
        ps.println();
        addIndent = true;
    }

    private static void println(int i) {
        CreateLog.print(i);
        ps.println();
        addIndent = true;
    }

    private static void genMethods(String method, String level) {
        CreateLog.print("/* write a log message in level ");
        CreateLog.print(level);
        CreateLog.println(".");
        CreateLog.println("* @param msg the log message");
        CreateLog.println("*/");
        CreateLog.print("public static void ");
        CreateLog.print(method);
        CreateLog.println("(String msg) {");
        CreateLog.indent();
        CreateLog.print("  getLogger().log(createRecord(");
        CreateLog.print(level);
        CreateLog.println(", msg));");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.print("/* write a log message in level ");
        CreateLog.print(level);
        CreateLog.println(".");
        CreateLog.println("* @param t   the throwable which should be included");
        CreateLog.println("* @param msg the log message");
        CreateLog.println("*/");
        CreateLog.print("public static void ");
        CreateLog.print(method);
        CreateLog.println("(Throwable t, String msg) {");
        CreateLog.indent();
        CreateLog.print("LogRecord lr = createRecord(");
        CreateLog.print(level);
        CreateLog.print(", msg); ");
        CreateLog.println("lr.setThrown(t);");
        CreateLog.println("getLogger().log(lr); ");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.print("/* write a log message in level ");
        CreateLog.print(level);
        CreateLog.println(".");
        CreateLog.println("* @param t   the throwable which should be included");
        CreateLog.println("* @param msg the log message");
        CreateLog.println("* @param params array of parameter for the message");
        CreateLog.println("*/");
        CreateLog.print("public static void ");
        CreateLog.print(method);
        CreateLog.print("_p");
        CreateLog.println("(Throwable t, String msg, Object[] params) {");
        CreateLog.indent();
        CreateLog.print("if (getLogger().isLoggable(");
        CreateLog.print(level);
        CreateLog.println(")) { ");
        CreateLog.indent();
        CreateLog.print("LogRecord lr = createRecord(");
        CreateLog.print(level);
        CreateLog.println(", msg);");
        CreateLog.println("lr.setThrown(t);");
        CreateLog.println("lr.setParameters(new Object [] { params });");
        CreateLog.println("getLogger().log(lr);");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.deindent();
        CreateLog.println("}");
        for (int i = 1; i <= 10; ++i) {
            for (int ii = 0; ii < PARAM_TYPES.length; ++ii) {
                CreateLog.genParamMethods(method, level, PARAM_TYPES[ii], i, false);
                CreateLog.genParamMethods(method, level, PARAM_TYPES[ii], i, true);
            }
        }
    }

    private static void genEnteringMethods() {
        CreateLog.genEnteringMethod(PARAM_TYPES[0], 0);
        for (int i = 1; i <= 10; ++i) {
            for (int ii = 0; ii < PARAM_TYPES.length; ++ii) {
                CreateLog.genEnteringMethod(PARAM_TYPES[ii], i);
            }
        }
    }

    private static String getProducer() {
        Exception e = new Exception();
        StackTraceElement elm = e.getStackTrace()[1];
        return elm.getClassName() + "." + elm.getMethodName() + ":" + elm.getLineNumber();
    }

    private static void genEnteringMethod(ParamType paramType, int paramCount) {
        int i;
        CreateLog.println("/* Log the entry of a method.");
        CreateLog.println(" * @param theClass the class of the method");
        CreateLog.println(" * @param sourceMethod name of the method");
        for (i = 0; i < paramCount; ++i) {
            CreateLog.print(" * @param param");
            CreateLog.print(i);
            CreateLog.println(" parameter for the message");
        }
        CreateLog.println(" * producer is " + CreateLog.getProducer());
        CreateLog.println(" */");
        CreateLog.print("public static void entering(Class theClass, String sourceMethod");
        if (paramCount > 0) {
            CreateLog.print(",");
            for (i = 0; i < paramCount; ++i) {
                if (i > 0) {
                    CreateLog.print(",");
                }
                CreateLog.print(paramType.type);
                CreateLog.print(" param");
                CreateLog.print(i);
            }
        }
        CreateLog.println(") {");
        CreateLog.indent();
        CreateLog.println("if (getLogger().isLoggable(Level.FINER)) {");
        CreateLog.indent();
        CreateLog.print("entering(theClass.getName(), sourceMethod");
        for (i = 0; i < paramCount; ++i) {
            CreateLog.print(", param" + i);
        }
        CreateLog.println(");");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.println("/* Log the entry of a method.");
        CreateLog.println(" * @param sourceClass name of the class of the method");
        CreateLog.println(" * @param sourceMethod name of the method");
        for (i = 0; i < paramCount; ++i) {
            CreateLog.print(" * @param param");
            CreateLog.print(i);
            CreateLog.println(" parameter for the message");
        }
        CreateLog.println(" * producer is " + CreateLog.getProducer());
        CreateLog.println(" */");
        CreateLog.print("public static void entering(String sourceClass,");
        CreateLog.print(" String sourceMethod");
        if (paramCount > 0) {
            CreateLog.print(",");
            for (i = 0; i < paramCount; ++i) {
                if (i > 0) {
                    CreateLog.print(",");
                }
                CreateLog.print(paramType.type);
                CreateLog.print(" param" + i);
            }
        }
        CreateLog.println(") {");
        CreateLog.indent();
        CreateLog.println("if (getLogger().isLoggable(Level.FINER)) {");
        CreateLog.indent();
        CreateLog.print("getLogger().entering(sourceClass, sourceMethod ");
        switch (paramCount) {
            case 0: {
                break;
            }
            case 1: {
                CreateLog.print(", " + paramType.getWrapper("param0"));
                break;
            }
            default: {
                CreateLog.print(", new Object [] { ");
                for (i = 0; i < paramCount; ++i) {
                    if (i > 0) {
                        CreateLog.print(", ");
                    }
                    CreateLog.print(paramType.getWrapper("param" + i));
                }
                CreateLog.print("} ");
            }
        }
        CreateLog.println(");");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.deindent();
        CreateLog.println("}");
    }

    private static void genExitingMethods() {
        CreateLog.println("/* Log the exit of a method.");
        CreateLog.println(" * @param sourceClass name of the class of the method");
        CreateLog.println(" * @param sourceMethod name of the method");
        CreateLog.println(" * producer is " + CreateLog.getProducer());
        CreateLog.println(" */");
        CreateLog.println("public static void exiting(String sourceClass,");
        CreateLog.println("                           String sourceMethod) {");
        CreateLog.indent();
        CreateLog.println("if (getLogger().isLoggable(Level.FINER)) {");
        CreateLog.indent();
        CreateLog.println("getLogger().exiting(sourceClass, sourceMethod);");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.println("/* Log the exit of a method.");
        CreateLog.println(" * @param sourceClass the class of the method");
        CreateLog.println(" * @param sourceMethod name of the method");
        CreateLog.println(" * producer is " + CreateLog.getProducer());
        CreateLog.println(" */");
        CreateLog.println("public static void exiting(Class sourceClass,");
        CreateLog.println("                           String sourceMethod) {");
        CreateLog.indent();
        CreateLog.println("if (getLogger().isLoggable(Level.FINER)) {");
        CreateLog.indent();
        CreateLog.println("getLogger().exiting(sourceClass.getName(), sourceMethod);");
        CreateLog.deindent();
        CreateLog.println("}");
        CreateLog.deindent();
        CreateLog.println("}");
        for (int i = 0; i < PARAM_TYPES.length; ++i) {
            CreateLog.println("/* Log the exit of a method.");
            CreateLog.println(" * @param sourceClass name of the class of the method");
            CreateLog.println(" * @param sourceMethod name of the method");
            CreateLog.println(" * @param returnCode   the return code of the method");
            CreateLog.println(" * producer is " + CreateLog.getProducer());
            CreateLog.println(" */");
            CreateLog.println("public static void exiting(String sourceClass,");
            CreateLog.print("                           String sourceMethod,");
            CreateLog.print(PARAM_TYPES[i].type);
            CreateLog.println(" returnCode) {");
            CreateLog.indent();
            CreateLog.println("if (getLogger().isLoggable(Level.FINER)) {");
            CreateLog.indent();
            CreateLog.print("getLogger().exiting(sourceClass, sourceMethod, ");
            CreateLog.print(PARAM_TYPES[i].getWrapper("returnCode"));
            CreateLog.println(");");
            CreateLog.deindent();
            CreateLog.println("}");
            CreateLog.deindent();
            CreateLog.println("}");
            CreateLog.println("/* Log the exit of a method.");
            CreateLog.println(" * @param sourceClass the class of the method");
            CreateLog.println(" * @param sourceMethod name of the method");
            CreateLog.println(" * @param returnCode   the return code of the method");
            CreateLog.println(" * producer is " + CreateLog.getProducer());
            CreateLog.println(" */");
            CreateLog.println("public static void exiting(Class sourceClass,");
            CreateLog.print("                            String sourceMethod, ");
            CreateLog.print(PARAM_TYPES[i].type);
            CreateLog.println(" returnCode) {");
            CreateLog.indent();
            CreateLog.println("if (getLogger().isLoggable(Level.FINER)) {");
            CreateLog.indent();
            CreateLog.println("exiting(sourceClass.getName(), sourceMethod, returnCode);");
            CreateLog.deindent();
            CreateLog.println("}");
            CreateLog.deindent();
            CreateLog.println("}");
        }
    }

    private static void genParamMethods(String method, String level, ParamType paramType, int paramCount, boolean withException) {
        int i;
        CreateLog.print("/* Write a log message in level ");
        CreateLog.println(level);
        if (withException) {
            CreateLog.println(" * @param t  include this throwable");
        }
        CreateLog.println(" * @param msg  the log message");
        for (i = 0; i < paramCount; ++i) {
            CreateLog.print(" * @param param");
            CreateLog.print(i);
            CreateLog.println(" parameter for the message");
        }
        CreateLog.println(" * producer is " + CreateLog.getProducer());
        CreateLog.println(" */");
        CreateLog.print("public static void ");
        CreateLog.print(method);
        CreateLog.print("(");
        if (withException) {
            CreateLog.print("Throwable t, ");
        }
        CreateLog.print("String msg, ");
        for (i = 0; i < paramCount; ++i) {
            if (i > 0) {
                CreateLog.print(", ");
            }
            CreateLog.print(paramType.type);
            CreateLog.print(" param");
            CreateLog.print(i);
        }
        CreateLog.println(") {");
        CreateLog.indent();
        CreateLog.print("if (getLogger().isLoggable(");
        CreateLog.print(level);
        CreateLog.println(")) {");
        CreateLog.indent();
        CreateLog.print("LogRecord lr = createRecord(");
        CreateLog.print(level);
        CreateLog.println(", msg);");
        if (withException) {
            CreateLog.println("lr.setThrown(t);");
        }
        CreateLog.print("lr.setParameters(new Object [] { ");
        for (i = 0; i < paramCount; ++i) {
            if (i > 0) {
                CreateLog.print(", ");
            }
            CreateLog.print(paramType.getWrapper("param" + i));
        }
        CreateLog.println(" });");
        CreateLog.println("getLogger().log(lr);");
        CreateLog.deindent();
        CreateLog.println("} ");
        CreateLog.deindent();
        CreateLog.println("}");
    }

    public static void main(String[] args) {
        int i;
        if (args.length == 0) {
            ps = System.out;
        } else if (args.length == 1) {
            try {
                File f = new File(args[0]);
                FileOutputStream fout = new FileOutputStream(f);
                ps = new PrintStream(fout);
                System.err.println("print output into file " + args[0]);
            }
            catch (IOException ioe) {
                System.err.println("Can't open output file " + args[0]);
                CreateLog.usage();
                System.exit(1);
            }
        } else {
            System.err.println("Illegal number of arguments");
            CreateLog.usage();
            System.exit(1);
        }
        CreateLog.println("// This class was generated by " + (class$com$sun$grid$logging$CreateLog == null ? (class$com$sun$grid$logging$CreateLog = CreateLog.class$("com.sun.grid.logging.CreateLog")) : class$com$sun$grid$logging$CreateLog).getName());
        CreateLog.println("// DO NOT EDIT THIS FILE");
        for (i = 0; i < PREFIX.length; ++i) {
            CreateLog.println(PREFIX[i]);
        }
        CreateLog.indent();
        for (i = 0; i < METHODS.length; ++i) {
            CreateLog.genMethods(METHODS[i], LEVELS[i]);
        }
        CreateLog.genEnteringMethods();
        CreateLog.genExitingMethods();
        CreateLog.deindent();
        for (i = 0; i < SUFFIX.length; ++i) {
            CreateLog.println(SUFFIX[i]);
        }
    }

    private static void usage() {
        PrintStream out = System.err;
        out.println("CreateLog [fileName]");
        out.println("   fileName  in this filename the source code for");
        out.println("             the class SGELog will be written.");
        out.println("             If no filename is given, the source code");
        out.println("             will be written to stdout");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        indent = new StringBuffer();
        addIndent = false;
        PREFIX = new String[]{"package com.sun.grid.logging;", "import java.util.logging.Logger;", "import java.util.logging.Level;", "import java.util.logging.LogRecord;", "", "/*  Utilitiy class for logging ", " *", " * @see BaseSGELog", " */", "public class SGELog extends BaseSGELog {"};
        SUFFIX = new String[]{"}"};
        METHODS = new String[]{"severe", "warning", "config", "info", "fine", "finer", "finest"};
        LEVELS = new String[]{"Level.SEVERE", "Level.WARNING", "Level.CONFIG", "Level.INFO", "Level.FINE", "Level.FINER", "Level.FINEST"};
    }

    static class ParamType {
        private String type;
        private String wrapper;

        public ParamType(String aType, String aWrapper) {
            this.type = aType;
            this.wrapper = aWrapper;
        }

        public final String getWrapper(String paramName) {
            if (this.wrapper != null) {
                return "new " + this.wrapper + "(" + paramName + ")";
            }
            return paramName;
        }
    }
}

