/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.util.sqlutil;

import com.sun.grid.logging.SGELog;
import com.sun.grid.util.SQLUtil;
import com.sun.grid.util.dbmodel.DBModel;
import com.sun.grid.util.dbmodel.ObjectFactory;
import com.sun.grid.util.dbmodel.SQLItem;
import com.sun.grid.util.dbmodel.Version;
import com.sun.grid.util.sqlutil.Command;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class UpdateDbModelCommand
extends Command {
    public static final String DBMODEL_PACKAGE = "com.sun.grid.util.dbmodel";
    public static final String SQL_VERSION_STMT = "select max(v_id) as v_id, v_version, v_time from sge_version group by v_version, v_time";
    public static final String SQL_TEST_VERSION_STMT = "select count(*) from sge_version";
    private JAXBContext jc;
    private ObjectFactory objFactory;
    public static final int NAME_COLUMN = 3;

    public UpdateDbModelCommand(SQLUtil aSqlUtil, String name) {
        super(aSqlUtil, name);
        try {
            this.jc = JAXBContext.newInstance((String)DBMODEL_PACKAGE);
            this.objFactory = new ObjectFactory();
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("Can't create JAXBContext");
            ilse.initCause(jaxbe);
            throw ilse;
        }
    }

    private DBModel readModel(File file) throws IOException, JAXBException {
        Unmarshaller un = this.jc.createUnmarshaller();
        DBModel ret = (DBModel)un.unmarshal(file);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVersionTableAvailable() throws SQLException {
        SGELog.entering(this.getClass(), "isVersionTableAvailable");
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        try {
            SGELog.fine("excute {0}", (Object)SQL_TEST_VERSION_STMT);
            ResultSet rs = stmt.executeQuery(SQL_TEST_VERSION_STMT);
            rs.close();
            SGELog.exiting(this.getClass(), "isVersionTableAvailable", (Object)Boolean.TRUE);
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            SGELog.exiting(this.getClass(), "isVersionTableAvailable", (Object)Boolean.FALSE);
            boolean bl = false;
            return bl;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSGETables(String schema) throws SQLException {
        SGELog.entering(this.getClass(), "getSGETables");
        Connection conn = this.getConnection();
        DatabaseMetaData dbMeta = conn.getMetaData();
        String[] tablesTypes = new String[]{"TABLE"};
        SGELog.fine("Searching sge tables in schema {0}", (Object)schema);
        ResultSet rs = dbMeta.getTables(null, schema, null, tablesTypes);
        try {
            ArrayList<String> ret = new ArrayList<String>();
            String str = null;
            while (rs.next()) {
                str = rs.getString(3);
                if (!str.toLowerCase().startsWith("sge_")) continue;
                SGELog.fine("found table {0}", (Object)str);
                ret.add(str);
            }
            SGELog.exiting(this.getClass(), "getSGETables", ret);
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        finally {
            rs.close();
        }
    }

    /*
     * Loose catch block
     */
    private Version getDatabaseVersion() throws SQLException {
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(SQL_VERSION_STMT);
            try {
                Version ret = this.objFactory.createVersion();
                if (rs.next()) {
                    ret.setId(rs.getInt("v_id"));
                    ret.setName(rs.getString("v_version"));
                } else {
                    ret.setId(0);
                    ret.setName("unknown");
                }
                Version version = ret;
                return version;
            }
            catch (JAXBException jaxbe) {
                throw new IllegalStateException("Can not create instance of version");
            }
            finally {
                rs.close();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    private Version getExistingVersion(String schema) throws SQLException {
        Version ret = null;
        if (this.isVersionTableAvailable()) {
            ret = this.getDatabaseVersion();
        } else {
            List tables = this.getSGETables(schema);
            if (SGELog.isLoggable(Level.FINE)) {
                Iterator iter = tables.iterator();
                while (iter.hasNext()) {
                    SGELog.fine("Found table {0}", iter.next());
                }
            }
            try {
                if (tables.isEmpty()) {
                    SGELog.fine("Found no sge tables version id is -1");
                    ret = this.objFactory.createVersion();
                    ret.setId(-1);
                    ret.setName("No version installed");
                } else {
                    SGELog.fine("Found the sge tables, version id is 0");
                    ret = this.objFactory.createVersion();
                    ret.setId(0);
                    ret.setName("Initial version");
                }
            }
            catch (JAXBException jaxbe) {
                throw new IllegalStateException("Can not create instanceof version");
            }
        }
        return ret;
    }

    public final int run(String args) {
        if (args == null) {
            SGELog.severe("no arguments found");
            return 1;
        }
        if (this.getConnection() == null) {
            SGELog.severe("Can not execute this command, not connected");
            return 1;
        }
        StringTokenizer st = new StringTokenizer(args, " ");
        String[] argv = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            argv[i++] = st.nextToken();
        }
        if (argv[0].equals("print_db_version")) {
            String schema = null;
            boolean onlyId = false;
            switch (argv.length) {
                case 2: {
                    schema = argv[1];
                    break;
                }
                case 3: {
                    if (!argv[1].equals("-only-id")) {
                        SGELog.severe("Unknown option {0}", (Object)argv[1]);
                        return 1;
                    }
                    onlyId = true;
                    schema = argv[2];
                    break;
                }
                default: {
                    SGELog.severe("Invalid argument count");
                    SGELog.info(this.usage());
                    return 1;
                }
            }
            try {
                Version dbVersion = this.getExistingVersion(schema);
                if (onlyId) {
                    SGELog.info(Integer.toString(dbVersion.getId()));
                } else {
                    SGELog.info("version {0} (id={1})", (Object)dbVersion.getName(), (Object)new Integer(dbVersion.getId()));
                }
                return 0;
            }
            catch (SQLException sqle) {
                SGELog.severe((Throwable)sqle, "sql error: {0}", (Object)sqle.getMessage());
                return 1;
            }
        }
        return this.install(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int install(String[] argv) {
        int n;
        block32: {
            if (argv.length != 3) {
                SGELog.severe("Invalid number of arguments");
                SGELog.info(this.usage());
                return 1;
            }
            Integer versionId = null;
            try {
                versionId = new Integer(argv[0]);
            }
            catch (NumberFormatException nfe) {
                SGELog.severe("version must be an integer (''{0}'')", (Object)argv[0]);
                SGELog.info(this.usage());
                return 1;
            }
            File file = new File(argv[1]);
            if (!file.exists()) {
                SGELog.severe("database model file {0} not found", file);
                SGELog.info(this.usage());
                return 1;
            }
            SGELog.fine("file is {0}", file);
            String schema = argv[2];
            try {
                try {
                    DBModel model = this.readModel(file);
                    Version dbVersion = this.getExistingVersion(schema);
                    if (dbVersion.getId() >= versionId) {
                        SGELog.info("version with id {0} is already installed", versionId);
                        n = 0;
                        Object var18_18 = null;
                        break block32;
                    }
                    try {
                        SGELog.finest("switch off auto commit mode");
                        this.getConnection().setAutoCommit(false);
                    }
                    catch (SQLException sqle) {
                        SGELog.severe(sqle, "Can not switch off the auto commit mode");
                        int n2 = 1;
                        Object var18_19 = null;
                        try {
                            SGELog.finest("switch on auto commit mode");
                            this.getConnection().setAutoCommit(true);
                            return n2;
                        }
                        catch (SQLException sqle2) {
                            SGELog.severe(sqle2, "Can not switch on the auto commit mode");
                            return 1;
                        }
                    }
                    List versionList = model.getVersion();
                    Version tmpVersion = null;
                    Version instVersion = null;
                    Iterator iter = null;
                    Connection conn = this.getConnection();
                    Statement stmt = conn.createStatement();
                    SQLItem item = null;
                    try {
                        for (int i = dbVersion.getId() + 1; i <= versionId; ++i) {
                            iter = versionList.iterator();
                            instVersion = null;
                            while (iter.hasNext()) {
                                tmpVersion = (Version)iter.next();
                                if (tmpVersion.getId() != i) continue;
                                instVersion = tmpVersion;
                                break;
                            }
                            if (instVersion == null) {
                                SGELog.severe("Version with id {0} is not defined in {1}", new Integer(i), (Object)file);
                                int n3 = 1;
                                return n3;
                            }
                            SGELog.info("Install version {0} (id={1}) -------", (Object)instVersion.getName(), (Object)new Integer(instVersion.getId()));
                            iter = instVersion.getItem().iterator();
                            String str = null;
                            while (iter.hasNext()) {
                                item = (SQLItem)iter.next();
                                str = this.getSQLUtil().replaceVariables(item.getDescription());
                                SGELog.info(str);
                                str = this.getSQLUtil().replaceVariables(item.getSql());
                                SGELog.fine("execute {0}", (Object)str);
                                stmt.execute(str);
                            }
                            SGELog.info("commiting changes");
                            this.getConnection().commit();
                            SGELog.info("version {0} (id={1}) successfully installed", (Object)instVersion.getName(), (Object)new Integer(instVersion.getId()));
                        }
                        int n4 = 0;
                        return n4;
                    }
                    finally {
                        stmt.close();
                    }
                }
                catch (IOException ioe) {
                    SGELog.severe((Throwable)ioe, "I/O Error while reading file {0}: {1}", (Object)file, (Object)ioe.getMessage());
                    int dbVersion = 1;
                    Object var18_22 = null;
                    try {}
                    catch (SQLException sqle2) {
                        SGELog.severe(sqle2, "Can not switch on the auto commit mode");
                        return 1;
                    }
                    SGELog.finest("switch on auto commit mode");
                    this.getConnection().setAutoCommit(true);
                    return dbVersion;
                }
                catch (JAXBException jaxbe) {
                    SGELog.severe((Throwable)jaxbe, "Can not unmarshal file {0}: {1}", (Object)file, (Object)jaxbe.toString());
                    int dbVersion = 1;
                    Object var18_23 = null;
                    try {}
                    catch (SQLException sqle2) {
                        SGELog.severe(sqle2, "Can not switch on the auto commit mode");
                        return 1;
                    }
                    SGELog.finest("switch on auto commit mode");
                    this.getConnection().setAutoCommit(true);
                    return dbVersion;
                }
                catch (SQLException sqle) {
                    SGELog.severe((Throwable)sqle, "SQL error: {0}", (Object)sqle.getMessage());
                    try {
                        this.getConnection().rollback();
                    }
                    catch (SQLException sqle1) {
                        SGELog.severe((Throwable)sqle1, "Can not rollback: {0}", (Object)sqle1.getMessage());
                    }
                    int n5 = 1;
                    Object var18_24 = null;
                    try {}
                    catch (SQLException sqle2) {
                        SGELog.severe(sqle2, "Can not switch on the auto commit mode");
                        return 1;
                    }
                    SGELog.finest("switch on auto commit mode");
                    this.getConnection().setAutoCommit(true);
                    return n5;
                }
            }
            catch (Throwable throwable) {
                Object var18_25 = null;
                try {}
                catch (SQLException sqle2) {
                    SGELog.severe(sqle2, "Can not switch on the auto commit mode");
                    return 1;
                }
                SGELog.finest("switch on auto commit mode");
                this.getConnection().setAutoCommit(true);
                throw throwable;
            }
        }
        try {}
        catch (SQLException sqle2) {
            SGELog.severe(sqle2, "Can not switch on the auto commit mode");
            return 1;
        }
        SGELog.finest("switch on auto commit mode");
        this.getConnection().setAutoCommit(true);
        return n;
    }

    public final String usage() {
        return this.getName() + "(print_db_version -only-id |" + "<version> <dbmodel file>) <schema>";
    }
}

