/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.xml;

import com.sun.grid.reporting.model.DBTableViewConfiguration;
import com.sun.grid.reporting.model.GraphicalViewConfiguration;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.model.ViewConfigurationManager;
import com.sun.grid.reporting.viewconfiguration.ChartTypes;
import com.sun.grid.reporting.xml.AbstractXMLParser;
import com.sun.grid.reporting.xml.XMLTag;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ParseViewconfigurationXML
extends AbstractXMLParser {
    private ViewConfigurationManager viewConfigurationManager;

    public ParseViewconfigurationXML(String path) {
        super(path);
    }

    public ViewConfigurationManager getViewConfigurationManager() {
        return this.viewConfigurationManager;
    }

    protected void visitDocument() {
        Element element = this.document.getDocumentElement();
        if (element != null && element.getTagName().equals(XMLTag.VC_ROOT.getElement())) {
            this.visitElement_viewconfiguration(element);
        }
    }

    private void visitElement_viewconfiguration(Element element) {
        this.viewConfigurationManager = new ViewConfigurationManager();
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_COMMON.getElement())) {
                        this.visitElement_common(nodeElement);
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_GRAPHIC.getElement())) {
                        this.viewConfigurationManager.setViewConfiguration(this.visitElement_graphic(nodeElement), 3);
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_PIVOT.getElement())) {
                        this.viewConfigurationManager.setViewConfiguration(this.visitElement_pivot(nodeElement), 2);
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_TABLE.getElement())) continue block4;
                    this.viewConfigurationManager.setViewConfiguration(this.visitElement_table(nodeElement), 1);
                    continue block4;
                }
            }
        }
    }

    private void visitElement_common(Element element) {
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_DESCRIPTION.getElement())) {
                        this.visitElement_Description(nodeElement);
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_PARAMETER.getElement())) {
                        this.visitElement_Parameter(nodeElement);
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_SQL.getElement())) continue block3;
                    this.visitElement_Sql(nodeElement);
                }
            }
        }
    }

    private void visitElement_Description(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeCount = attributeMap.getLength();
        for (int counter = 0; counter < attributeCount; ++counter) {
            Attr attribute = (Attr)attributeMap.item(counter);
            String name = attribute.getName();
            if (!name.equals("visible")) continue;
            this.viewConfigurationManager.setHideDescription(Boolean.valueOf(attribute.getValue().toLowerCase()) == false);
            System.out.println("DEBUG:\tParseViewconfigurationXMLt.visitElement_Description(Element)\n\tThe value of HideSQLStatement is: " + this.viewConfigurationManager.isHideDescription());
        }
    }

    private void visitElement_Parameter(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeCount = attributeMap.getLength();
        for (int counter = 0; counter < attributeCount; ++counter) {
            Attr attribute = (Attr)attributeMap.item(counter);
            String name = attribute.getName();
            if (!name.equals("visible")) continue;
            this.viewConfigurationManager.setHideParameter(Boolean.valueOf(attribute.getValue().toLowerCase()) == false);
            System.out.println("DEBUG:\tParseViewconfigurationXMLt.visitElement_Parameter(Element)\n\tThe value of HideSQLStatement is: " + this.viewConfigurationManager.isHideParameter());
        }
    }

    private void visitElement_Sql(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeCount = attributeMap.getLength();
        for (int counter = 0; counter < attributeCount; ++counter) {
            Attr attribute = (Attr)attributeMap.item(counter);
            String name = attribute.getName();
            if (!name.equals("visible")) continue;
            this.viewConfigurationManager.setHideSQLStatement(Boolean.valueOf(attribute.getValue().toLowerCase()) == false);
            System.out.println("DEBUG:\tParseViewconfigurationXMLt.visitElement_Sql(Element)\n\tThe value of HideSQLStatement is: " + this.viewConfigurationManager.isHideSQLStatement());
        }
    }

    private GraphicalViewConfiguration visitElement_graphic(Element element) {
        GraphicalViewConfiguration gvc = new GraphicalViewConfiguration();
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeCount = attributeMap.getLength();
        int order = -1;
        boolean visible = false;
        boolean legend = true;
        for (int counter = 0; counter < attributeCount; ++counter) {
            String value;
            Attr attribute = (Attr)attributeMap.item(counter);
            String name = attribute.getName();
            if (name.equals("visible")) {
                visible = Boolean.valueOf(attribute.getValue().toLowerCase());
            }
            if (name.equals("order")) {
                try {
                    order = Integer.parseInt(attribute.getValue());
                }
                catch (NumberFormatException nfEx) {
                    order = -1;
                }
            }
            if (!name.equals("legend") || !(value = attribute.getValue()).equalsIgnoreCase("hide")) continue;
            legend = true;
        }
        if (!visible && order != -1) {
            System.out.println("WARNING:The visibility (" + visible + ") and order value (" + order + ") does not match. The visibility of the graphical configuration will be ignored.");
        } else if (visible) {
            if (order >= 1 && order <= 3) {
                if (this.viewConfigurationManager.getViewConfigurationAt(order - 1) == null) {
                    System.out.println("DEBUG:\tParseViewconfigurationXML.visitElement_graphic(Element)\n\tsetVisibleViewConfiguration(3, " + (order - 1) + ")");
                    this.viewConfigurationManager.setVisibleViewconfiguration(3, order - 1);
                } else {
                    System.out.println("WARNING:The index " + order + " of visible ViewConfigurations has already been set. The visibility of the graphical configuration will be ignored.");
                }
            } else {
                System.out.println("WARNING:The index " + order + " is out of range. The visibility of the graphical configuration will be ignored.");
            }
        } else {
            System.out.println("INFO:\tThe graphical configuration is not visible.");
        }
        NodeList nodes = element.getChildNodes();
        block7: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block7;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_BAR.getElement())) {
                        gvc.setCharType(ChartTypes.BAR_CHART);
                        this.visitElement_bar(nodeElement, gvc);
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_LINE.getElement())) {
                        gvc.setCharType(ChartTypes.LINE_CHART);
                        this.visitElement_line(nodeElement, gvc);
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_PIE.getElement())) {
                        gvc.setCharType(ChartTypes.PIE_CHART);
                        this.visitElement_pie(nodeElement, gvc);
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_STACKEDLINE.getElement())) continue block7;
                    gvc.setCharType(ChartTypes.STACKED_LINE_CHART);
                    this.visitElement_stackedline(nodeElement, gvc);
                    continue block7;
                }
            }
        }
        if (gvc.isHideLegendAllowed()) {
            gvc.setHideLegend(legend);
        }
        return gvc;
    }

    private void visitElement_bar(Element element, GraphicalViewConfiguration gvc) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_XAXIS.getElement())) {
                        gvc.addXValue(this.visitElement_xaxis(nodeElement));
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_YAXIS.getElement())) continue block4;
                    gvc.setYValue(this.visitElement_yaxis(nodeElement));
                    continue block4;
                }
            }
        }
    }

    private String visitElement_xaxis(Element element) {
        String retVal = null;
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VC_FIELD.getElement())) continue block4;
                    retVal = this.visitElement_field(nodeElement);
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private String visitElement_field(Element element) {
        String retVal = null;
        NamedNodeMap attrs = element.getAttributes();
        NodeList nodes = element.getChildNodes();
        block6: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block6;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block6;
                }
                case 7: {
                    continue block6;
                }
                case 3: {
                    retVal = ((Text)node).getData().trim();
                }
            }
        }
        return retVal;
    }

    private String visitElement_yaxis(Element element) {
        String retVal = null;
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VC_FIELD.getElement())) continue block4;
                    retVal = this.visitElement_field(nodeElement);
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private void visitElement_line(Element element, GraphicalViewConfiguration gvc) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_XAXIS.getElement())) {
                        gvc.addXValue(this.visitElement_xaxis(nodeElement));
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_YAXIS.getElement())) {
                        gvc.setYValue(this.visitElement_yaxis(nodeElement));
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_TYPE.getElement())) continue block4;
                    gvc.setType(this.visitElement_type(nodeElement));
                    continue block4;
                }
            }
        }
    }

    private String visitElement_type(Element element) {
        String retVal = null;
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VC_FIELD.getElement())) continue block4;
                    retVal = this.visitElement_field(nodeElement);
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private void visitElement_pie(Element element, GraphicalViewConfiguration gvc) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_XAXIS.getElement())) {
                        gvc.addXValue(this.visitElement_xaxis(nodeElement));
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_YAXIS.getElement())) continue block4;
                    gvc.setYValue(this.visitElement_yaxis(nodeElement));
                    continue block4;
                }
            }
        }
    }

    private void visitElement_stackedline(Element element, GraphicalViewConfiguration gvc) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_XAXIS.getElement())) {
                        gvc.addXValue(this.visitElement_xaxis(nodeElement));
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_YAXIS.getElement())) {
                        gvc.setYValue(this.visitElement_yaxis(nodeElement));
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_TYPE.getElement())) continue block4;
                    gvc.setType(this.visitElement_type(nodeElement));
                    continue block4;
                }
            }
        }
    }

    private PivotViewConfiguration visitElement_pivot(Element element) {
        PivotViewConfiguration pvc = new PivotViewConfiguration();
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeCount = attributeMap.getLength();
        int order = -1;
        boolean visible = false;
        for (int counter = 0; counter < attributeCount; ++counter) {
            Attr attribute = (Attr)attributeMap.item(counter);
            String name = attribute.getName();
            if (name.equals("visible")) {
                visible = Boolean.valueOf(attribute.getValue().toLowerCase());
            }
            if (!name.equals("order")) continue;
            try {
                order = Integer.parseInt(attribute.getValue());
                continue;
            }
            catch (NumberFormatException nfEx) {
                order = -1;
            }
        }
        if (!visible && order != -1) {
            System.out.println("WARNING:The visibility (" + visible + ") and order value (" + order + ") does not match. The visibility of the pivot configuration will be ignored.");
        } else if (visible) {
            if (order >= 1 && order <= 3) {
                if (this.viewConfigurationManager.getViewConfigurationAt(order - 1) == null) {
                    System.out.println("DEBUG:\tParseViewconfigurationXML.visitElement_pivot(Element)\n\tsetVisibleViewConfiguration(2, " + (order - 1) + ")");
                    this.viewConfigurationManager.setVisibleViewconfiguration(2, order - 1);
                    System.out.println("INFO:\tThe pivot configuration is visible at position " + (order - 1) + ".");
                } else {
                    System.out.println("WARNING:The index " + order + " of visible ViewConfigurations has already been set. The visibility of the pivot configuration will be ignored.");
                }
            } else {
                System.out.println("WARNING:The index " + order + " is out of range. The visibility of the pivot configuration will be ignored.");
            }
        } else {
            System.out.println("INFO:\tThe pivot configuration is not visible.");
        }
        NodeList nodes = element.getChildNodes();
        block7: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block7;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.VC_ROW.getElement())) {
                        pvc.addRowAttribute(this.visitElement_row(nodeElement));
                    }
                    if (nodeElement.getTagName().equals(XMLTag.VC_COLUMN.getElement())) {
                        pvc.addColumnAttribute(this.visitElement_column(nodeElement));
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.VC_DATA.getElement())) continue block7;
                    pvc.addDataAttribute(this.visitElement_data(nodeElement));
                    continue block7;
                }
            }
        }
        return pvc;
    }

    private String visitElement_row(Element element) {
        String retVal = null;
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VC_FIELD.getElement())) continue block4;
                    retVal = this.visitElement_field(nodeElement);
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private String visitElement_column(Element element) {
        String retVal = null;
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VC_FIELD.getElement())) continue block4;
                    retVal = this.visitElement_field(nodeElement);
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private String visitElement_data(Element element) {
        String retVal = null;
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VC_FIELD.getElement())) continue block4;
                    retVal = this.visitElement_field(nodeElement);
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private DBTableViewConfiguration visitElement_table(Element element) {
        DBTableViewConfiguration dbtvc = new DBTableViewConfiguration();
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeCount = attributeMap.getLength();
        int order = -1;
        boolean visible = false;
        for (int counter = 0; counter < attributeCount; ++counter) {
            Attr attribute = (Attr)attributeMap.item(counter);
            String name = attribute.getName();
            if (name.equals("visible")) {
                visible = Boolean.valueOf(attribute.getValue().toLowerCase());
            }
            if (!name.equals("order")) continue;
            try {
                order = Integer.parseInt(attribute.getValue());
                continue;
            }
            catch (NumberFormatException nfEx) {
                order = -1;
            }
        }
        if (!visible && order != -1) {
            System.out.println("WARNING:The visibility (" + visible + ") and order value (" + order + ") does not match. The visibility of the db-Table configuration will be ignored.");
        } else if (visible) {
            if (order >= 1 && order <= 3) {
                if (this.viewConfigurationManager.getViewConfigurationAt(order - 1) == null) {
                    System.out.println("DEBUG:\tParseViewconfigurationXML.visitElement_table(Element)\n\tsetVisibleViewConfiguration(1, " + (order - 1) + ")");
                    this.viewConfigurationManager.setVisibleViewconfiguration(1, order - 1);
                } else {
                    System.out.println("WARNING:The index " + order + " of visible ViewConfigurations has already been set. The visibility of the db-Table configuration will be ignored.");
                }
            } else {
                System.out.println("WARNING:The index " + order + " is out of range. The visibility of the db-Table configuration will be ignored.");
            }
        } else {
            System.out.println("INFO:\tThe db-Table configuration is not visible.");
        }
        NodeList nodes = element.getChildNodes();
        block7: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block7;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VC_COLUMN.getElement())) continue block7;
                    dbtvc.addColumn(this.visitElement_column(nodeElement));
                    continue block7;
                }
            }
        }
        return dbtvc;
    }
}

