/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.xml;

import com.sun.grid.reporting.model.DBTableViewConfiguration;
import com.sun.grid.reporting.model.GraphicalViewConfiguration;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.model.ViewConfiguration;
import com.sun.grid.reporting.model.ViewConfigurationManager;
import com.sun.grid.reporting.viewconfiguration.ChartTypes;
import com.sun.grid.reporting.xml.XMLTag;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GenerateViewconfigurationXML {
    private Document document;
    private ViewConfigurationManager viewConfigurationManager;

    public GenerateViewconfigurationXML(ViewConfigurationManager vcm) {
        this.viewConfigurationManager = vcm;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType(XMLTag.VC_ROOT.getElement(), "", this.systemURL());
            this.document = domImpl.createDocument("", XMLTag.VC_ROOT.getElement(), docType);
        }
        catch (ParserConfigurationException pconfEx) {
            pconfEx.printStackTrace();
        }
    }

    private String systemURL() {
        URL url = this.getClass().getResource("viewconfiguration.dtd");
        return url.toString();
    }

    public Document getXMLDocument() {
        return this.document;
    }

    public void generate() {
        try {
            this.generateRoot();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void generateRoot() {
        Element e = this.document.getDocumentElement();
        Element commonChild = this.generateCommon();
        if (commonChild != null) {
            e.appendChild(commonChild);
        }
        ViewConfiguration vc = this.viewConfigurationManager.getViewConfiguration(3);
        int visibleOrder = this.viewConfigurationManager.indexOf(3);
        if (vc != null) {
            e.appendChild(this.generateGraphic(vc, visibleOrder));
        }
        vc = this.viewConfigurationManager.getViewConfiguration(2);
        visibleOrder = this.viewConfigurationManager.indexOf(2);
        if (vc != null) {
            e.appendChild(this.generatePivot(vc, visibleOrder));
        }
        vc = this.viewConfigurationManager.getViewConfiguration(1);
        visibleOrder = this.viewConfigurationManager.indexOf(1);
        if (vc != null) {
            e.appendChild(this.generateTable(vc, visibleOrder));
        }
    }

    private Element generateCommon() {
        boolean oneValueSet = false;
        Element e = this.document.createElement(XMLTag.VC_COMMON.getElement());
        if (this.viewConfigurationManager.isHideDescription()) {
            e.appendChild(this.generateDescription());
            oneValueSet = true;
        }
        if (this.viewConfigurationManager.isHideParameter()) {
            e.appendChild(this.generateParameter());
            oneValueSet = true;
        }
        if (this.viewConfigurationManager.isHideSQLStatement()) {
            e.appendChild(this.generateSQL());
            oneValueSet = true;
        }
        if (!oneValueSet) {
            return null;
        }
        return e;
    }

    private Element generateGraphic(ViewConfiguration vc, int visibleIndex) {
        Iterator addIt;
        GraphicalViewConfiguration gvc;
        Element e = this.document.createElement(XMLTag.VC_GRAPHIC.getElement());
        if (visibleIndex != -1) {
            e.setAttributeNode(this.generateOrderAttribute(visibleIndex));
            e.setAttributeNode(this.generateVisibleAttribte(true));
        }
        if ((gvc = (GraphicalViewConfiguration)vc).isHideLegend()) {
            e.setAttributeNode(this.generateLegendAttribte());
        }
        Node chartType = null;
        if (gvc.getChartType() == ChartTypes.BAR_CHART) {
            chartType = this.document.createElement(XMLTag.VC_BAR.getElement());
            addIt = gvc.getXValues().iterator();
            while (addIt.hasNext()) {
                chartType.appendChild(this.generateXAxis(addIt.next().toString()));
            }
            chartType.appendChild(this.generateYAxis(gvc.getYValue()));
        }
        if (gvc.getChartType() == ChartTypes.PIE_CHART) {
            chartType = this.document.createElement(XMLTag.VC_PIE.getElement());
            addIt = gvc.getXValues().iterator();
            while (addIt.hasNext()) {
                chartType.appendChild(this.generateXAxis(addIt.next().toString()));
            }
            chartType.appendChild(this.generateYAxis(gvc.getYValue()));
        }
        if (gvc.getChartType() == ChartTypes.LINE_CHART) {
            chartType = this.document.createElement(XMLTag.VC_LINE.getElement());
            addIt = gvc.getXValues().iterator();
            while (addIt.hasNext()) {
                chartType.appendChild(this.generateXAxis(addIt.next().toString()));
            }
            chartType.appendChild(this.generateYAxis(gvc.getYValue()));
            chartType.appendChild(this.generateType(gvc.getType()));
        }
        if (gvc.getChartType() == ChartTypes.STACKED_LINE_CHART) {
            chartType = this.document.createElement(XMLTag.VC_STACKEDLINE.getElement());
            addIt = gvc.getXValues().iterator();
            while (addIt.hasNext()) {
                chartType.appendChild(this.generateXAxis(addIt.next().toString()));
            }
            chartType.appendChild(this.generateYAxis(gvc.getYValue()));
            chartType.appendChild(this.generateType(gvc.getType()));
        }
        if (chartType == null) {
            chartType = this.document.createComment("The ChartType has an illegal state");
        }
        e.appendChild(chartType);
        return e;
    }

    private Element generateXAxis(String value) {
        Element e = this.document.createElement(XMLTag.VC_XAXIS.getElement());
        e.appendChild(this.generateField(value));
        return e;
    }

    private Element generateYAxis(String value) {
        Element e = this.document.createElement(XMLTag.VC_YAXIS.getElement());
        e.appendChild(this.generateField(value));
        return e;
    }

    private Element generateType(String value) {
        Element e = this.document.createElement(XMLTag.VC_TYPE.getElement());
        e.appendChild(this.generateField(value));
        return e;
    }

    private Element generatePivot(ViewConfiguration vc, int visibleIndex) {
        Element e = this.document.createElement(XMLTag.VC_PIVOT.getElement());
        if (visibleIndex != -1) {
            e.setAttributeNode(this.generateOrderAttribute(visibleIndex));
            e.setAttributeNode(this.generateVisibleAttribte(true));
        }
        PivotViewConfiguration pvc = (PivotViewConfiguration)vc;
        Iterator addIt = pvc.rowAttributes();
        while (addIt.hasNext()) {
            e.appendChild(this.generateRow(addIt.next().toString()));
        }
        addIt = pvc.columnAttributes();
        while (addIt.hasNext()) {
            e.appendChild(this.generateColumn(addIt.next().toString()));
        }
        addIt = pvc.dataAttributes();
        while (addIt.hasNext()) {
            e.appendChild(this.generateData(addIt.next().toString()));
        }
        return e;
    }

    private Element generateTable(ViewConfiguration vc, int visibleIndex) {
        Element e = this.document.createElement(XMLTag.VC_TABLE.getElement());
        if (visibleIndex != -1) {
            e.setAttributeNode(this.generateOrderAttribute(visibleIndex));
            e.setAttributeNode(this.generateVisibleAttribte(true));
        }
        DBTableViewConfiguration dbtvc = (DBTableViewConfiguration)vc;
        Iterator addIt = dbtvc.getColumns().iterator();
        while (addIt.hasNext()) {
            e.appendChild(this.generateColumn(addIt.next().toString()));
        }
        return e;
    }

    private Element generateRow(String value) {
        Element e = this.document.createElement(XMLTag.VC_ROW.getElement());
        e.appendChild(this.generateField(value));
        return e;
    }

    private Element generateColumn(String value) {
        Element e = this.document.createElement(XMLTag.VC_COLUMN.getElement());
        e.appendChild(this.generateField(value));
        return e;
    }

    private Element generateData(String value) {
        Element e = this.document.createElement(XMLTag.VC_DATA.getElement());
        e.appendChild(this.generateField(value));
        return e;
    }

    private Element generateField(String value) {
        Element e = this.document.createElement(XMLTag.VC_FIELD.getElement());
        Text data = this.document.createTextNode(value);
        e.appendChild(data);
        return e;
    }

    private Element generateDescription() {
        Element e = this.document.createElement(XMLTag.VC_DESCRIPTION.getElement());
        e.setAttributeNode(this.generateVisibleAttribte(false));
        return e;
    }

    private Element generateParameter() {
        Element e = this.document.createElement(XMLTag.VC_PARAMETER.getElement());
        e.setAttributeNode(this.generateVisibleAttribte(false));
        return e;
    }

    private Element generateSQL() {
        Element e = this.document.createElement(XMLTag.VC_SQL.getElement());
        e.setAttributeNode(this.generateVisibleAttribte(false));
        return e;
    }

    private Attr generateOrderAttribute(int value) {
        Attr attribute = this.document.createAttribute("order");
        attribute.setValue(Integer.toString(value + 1));
        return attribute;
    }

    private Attr generateVisibleAttribte(boolean value) {
        Attr attribute = this.document.createAttribute("visible");
        attribute.setValue(Boolean.toString(value));
        return attribute;
    }

    private Attr generateLegendAttribte() {
        Attr attribute = this.document.createAttribute("legend");
        attribute.setValue("hide");
        return attribute;
    }
}

