/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.xml;

import com.sun.grid.reporting.model.Result;
import com.sun.grid.reporting.xml.XMLTag;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GenerateResultXML {
    private Result result;
    private Document doc;
    private boolean headerMode;

    public GenerateResultXML(Result result) {
        this.result = result;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType(XMLTag.ROOT_OF_RESULT.getElement(), "", this.systemURL());
            this.doc = domImpl.createDocument("", XMLTag.ROOT.getElement(), docType);
        }
        catch (ParserConfigurationException pconfEx) {
            pconfEx.printStackTrace();
        }
    }

    private String systemURL() {
        URL url = this.getClass().getResource("result.dtd");
        return url.toString();
    }

    public void generate() {
        System.out.println("INFO:\tGenerateResultXML.generate()\n\tgenerate Resultdocument to be saved.");
        this.generateRoot();
        System.out.println("INFO:\tGenerateResultXML.generate()\n\tgenerate Resultdocument finished.");
    }

    public Document getXMLDocument() {
        return this.doc;
    }

    private void generateRoot() {
        Element e = this.doc.getDocumentElement();
        e.appendChild(this.generateDescription());
        e.appendChild(this.generateResult());
    }

    private Element generateResult() {
        Element e = this.doc.createElement(XMLTag.RESULT.getElement());
        e.appendChild(this.generateHeader());
        e.appendChild(this.generateData());
        return e;
    }

    private Element generateDescription() {
        Element e = this.doc.createElement(XMLTag.RESULT_DESCRIPTION.getElement());
        Element child = this.generateFilterList();
        if (child != null) {
            e.appendChild(child);
        }
        e.appendChild(this.generateSQL());
        return e;
    }

    private Element generateFilterList() {
        Element e = this.doc.createElement(XMLTag.RESULT_FILTERLIST.getElement());
        if (this.result.getParameterList() == null) {
            return null;
        }
        Iterator listIt = this.result.getParameterList().iterator();
        while (listIt.hasNext()) {
            String value = listIt.next().toString();
            e.appendChild(this.generateFilter(value));
        }
        return e;
    }

    private Element generateFilter(String value) {
        Element e = this.doc.createElement(XMLTag.RESULT_FILTER.getElement());
        value = value.replaceAll("<", " &lt; ");
        value = value.replaceAll(">", " &gt; ");
        e.appendChild(this.doc.createTextNode(value));
        return e;
    }

    private Element generateSQL() {
        Element e = this.doc.createElement(XMLTag.SQL.getElement());
        String value = this.result.getSQLStatement();
        if (value != null) {
            value = value.replaceAll("<", " &lt; ");
            value = value.replaceAll(">", " &gt; ");
        } else {
            value = "";
        }
        e.appendChild(this.doc.createTextNode(value));
        return e;
    }

    private Element generateHeader() {
        Element e = this.doc.createElement(XMLTag.HEADER.getElement());
        int colCount = this.result.getValue().getColumnCount();
        this.headerMode = true;
        for (int col = 0; col < colCount; ++col) {
            String colName = this.result.getValue().getColumnName(col);
            String objectType = this.result.getValue().getColumnClass(col).getName();
            e.appendChild(this.generateColumn(colName, objectType));
        }
        this.headerMode = false;
        return e;
    }

    private Element generateData() {
        Element e = this.doc.createElement(XMLTag.DATA.getElement());
        int rowCount = this.result.getValue().getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            e.appendChild(this.generateRow(row));
        }
        return e;
    }

    private Element generateRow(int row) {
        Element e = this.doc.createElement(XMLTag.ROW.getElement());
        int colCount = this.result.getValue().getColumnCount();
        for (int col = 0; col < colCount; ++col) {
            Object val = this.result.getValue().getValueAt(row, col);
            e.appendChild(this.generateColumn(val, null));
        }
        return e;
    }

    private Element generateColumn(Object val, String objectType) {
        Element e = this.doc.createElement(XMLTag.COLUMN.getElement());
        if (this.headerMode) {
            e.setAttribute("type", objectType);
        }
        e.appendChild(this.generateValue(val));
        return e;
    }

    private Element generateValue(Object val) {
        Element e = this.doc.createElement(XMLTag.VALUE.getElement());
        Text data = this.doc.createTextNode(val.toString());
        e.appendChild(data);
        return e;
    }
}

