/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.viewconfiguration;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.sql.SQLTableModel;
import com.sun.grid.reporting.viewconfiguration.ChartException;
import com.sun.grid.reporting.viewconfiguration.ChartTypes;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.jfree.data.CategoryDataset;
import org.jfree.data.CategoryTableXYDataset;
import org.jfree.data.CategoryToPieDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.TableXYDataset;

class DatasetBuilder {
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;

    public PieDataset buildPieChartDataset(SQLTableModel data, String ydata, String type) {
        CategoryDataset d = this.buildBarChartDataset(data, ydata, type);
        CategoryToPieDataset p = new CategoryToPieDataset(d, 1, 0);
        return p;
    }

    public CategoryDataset buildBarChartDataset(SQLTableModel data, String ydata, String type) {
        ArrayList list = new ArrayList(data.getRowCount());
        this.updateList(data, ydata, type, list);
        DefaultCategoryDataset set = this.createDataset(list);
        return set;
    }

    public CategoryDataset buildBarChartDataset(SQLTableModel data, String xdata, String ydata, String type) {
        SGELog.fine("entry xdata = {0}, ydata = {1}, type = {2}", (Object)xdata, (Object)ydata, (Object)type);
        ArrayList list = new ArrayList(data.getRowCount());
        this.updateList(data, xdata, ydata, type, list);
        DefaultCategoryDataset set = this.createDataset(list);
        SGELog.fine("exit");
        return set;
    }

    public CategoryDataset buildLineChartDataset(SQLTableModel data, String xdata, String ydata, String type) {
        SGELog.fine("entry xdata = {0}, ydata = {1}, type = {2}", (Object)xdata, (Object)ydata, (Object)type);
        CategoryDataset ret = this.buildBarChartDataset(data, xdata, ydata, type);
        SGELog.fine("exit");
        return ret;
    }

    public TableXYDataset buildXYChartDataset(SQLTableModel data, String xdata, String ydata, String series) {
        CategoryTableXYDataset ret = new CategoryTableXYDataset();
        int xIndex = data.getColumnIndexByName(xdata);
        int yIndex = data.getColumnIndexByName(ydata);
        int seriesIndex = data.getColumnIndexByName(series);
        Number xValue = null;
        Number yValue = null;
        Comparable seriesObj = null;
        for (int i = 0; i < data.getRowCount(); ++i) {
            xValue = this.getValueForType(data.getValueAt(i, xIndex));
            yValue = this.getValueForType(data.getValueAt(i, yIndex));
            seriesObj = (Comparable)data.getValueAt(i, seriesIndex);
            ret.add(xValue, yValue, seriesObj.toString(), false);
        }
        return ret;
    }

    public CategoryDataset buildBarChartDataset(SQLTableModel data, String[] xdata, String ydata) {
        ArrayList list = new ArrayList(data.getRowCount() * xdata.length);
        this.updateList(data, xdata, ydata, list);
        DefaultCategoryDataset set = this.createDataset(list);
        return set;
    }

    private void updateList(SQLTableModel data, String ydata, String type, List list) {
        int r;
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry rowCount={0},ydata = {1}", new Integer(data.getRowCount()), (Object)ydata);
        }
        int tc = data.findColumn(type);
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("column index for type {0} = {1}", (Object)type, (Object)new Integer(tc));
        }
        int yc = data.findColumn(ydata);
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("column index for ydata {0} = {1}", (Object)ydata, (Object)new Integer(yc));
        }
        Class datatype = data.getColumnClass(yc);
        SGELog.fine("datatype for ydata {0} is {1}", (Object)ydata, (Object)datatype);
        try {
            for (r = 0; r < data.getRowCount(); ++r) {
                Object o = data.getValueAt(r, yc);
                Number n = this.getValueForType(o);
                if (n == null) {
                    throw new ChartException("Wrong data type. Expected: Number or Date. Found: " + datatype.getName() + "\nRow=" + r + " ydata=" + ydata + "\ntype=" + type);
                }
                Comparable series = (Comparable)data.getValueAt(r, tc);
                list.add(new DataObject(n, null, series));
            }
        }
        catch (Exception ex3) {
            String message = "DatasetBuilder:Failed creating chart dataset.\nRow=" + r + " xdata=" + type + " ydata=" + ydata;
            throw new ChartException(message, ex3);
        }
        SGELog.fine("exit");
    }

    private void updateList(SQLTableModel data, String[] xdata, String ydata, List list) {
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry rowCount={0},ydata = {1}", new Integer(data.getRowCount()), (Object)ydata);
        }
        int[] cc = new int[xdata.length];
        Number[] values = new Number[data.getRowCount()];
        for (int i = 0; i < cc.length; ++i) {
            cc[i] = data.findColumn(xdata[i]);
            if (!SGELog.isLoggable(Level.FINE)) continue;
            SGELog.fine("column index for xdata {0} = {1}", (Object)xdata[i], (Object)new Integer(cc[i]));
        }
        int yc = data.findColumn(ydata);
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("column index for ydata {0} = {1}", (Object)ydata, (Object)new Integer(yc));
        }
        Class dataType = data.getColumnClass(yc);
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("datatype for ydata {0} is {1}", (Object)ydata, (Object)dataType.getName());
        }
        int rr = 0;
        int ii = 0;
        String sc = "";
        try {
            for (int i = 0; i < cc.length; ++i) {
                ii = i;
                for (int r = 0; r < data.getRowCount(); ++r) {
                    rr = r;
                    if (values[r] == null) {
                        Object o = data.getValueAt(r, yc);
                        Number n = this.getValueForType(o);
                        if (n == null) {
                            throw new ChartException("Wrong data type. Expected: Number or Date. Found: " + dataType.getName() + "\nRow=" + r + " xdata=" + xdata[ii] + " ydata=" + ydata);
                        }
                        values[r] = n;
                    }
                    Comparable series = (Comparable)data.getValueAt(r, cc[i]);
                    sc = xdata[i];
                    list.add(new DataObject(values[r], (Comparable)((Object)""), series));
                }
            }
        }
        catch (Exception ex3) {
            String message = "Failed creating chart dataset.\nRow=" + rr + "\nColumn=" + ii + "\nxdata=" + sc + "\nydata=" + ydata;
            throw new ChartException(message, ex3);
        }
        SGELog.fine("exit");
    }

    private Number getValueForType(Object o) {
        Number n = null;
        if ((class$java$lang$Number == null ? (class$java$lang$Number = DatasetBuilder.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(o.getClass())) {
            n = (Number)o;
        } else if ((class$java$util$Date == null ? (class$java$util$Date = DatasetBuilder.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(o.getClass())) {
            Date d = (Date)o;
            n = new Long(d.getTime());
        }
        return n;
    }

    private void updateList(SQLTableModel data, String xdata, String ydata, String type, List list) {
        int r;
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry rowCount={0}, xdata = {1}, ydata = {2}", new Integer(data.getRowCount()), (Object)xdata, (Object)ydata);
        }
        int cc = data.findColumn(xdata);
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("category column index for xdata {0} is {1}", (Object)xdata, (Object)new Integer(cc));
        }
        int tc = data.findColumn(type);
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("type column index for type {0} is {1}", (Object)type, (Object)new Integer(tc));
        }
        int vc = data.findColumn(ydata);
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("value column index for ydata {0} is {1}", (Object)ydata, (Object)new Integer(vc));
        }
        Class dataType = data.getColumnClass(vc);
        SGELog.fine("datatype is {0}", (Object)dataType.getName());
        try {
            for (r = 0; r < data.getRowCount(); ++r) {
                Object o;
                Number n;
                if (r % 1000 == 0 && SGELog.isLoggable(Level.FINE)) {
                    SGELog.fine("process row " + r);
                }
                if ((n = this.getValueForType(o = data.getValueAt(r, vc))) == null) {
                    throw new ChartException("Wrong data type. Expected: Number or Date. Found: " + dataType.getName() + "\nRow=" + r + " xdata=" + xdata + " ydata=" + ydata + "\ntype=" + type);
                }
                Comparable category = cc < 0 ? null : (Comparable)data.getValueAt(r, cc);
                Comparable series = (Comparable)data.getValueAt(r, tc);
                list.add(new DataObject(n, category, series));
            }
            SGELog.fine("exit");
        }
        catch (Exception ex3) {
            String message = "Failed creating chart dataset.\nRow=\nRow=" + r + " cc=" + cc + " tc=" + tc + " vc=" + vc;
            throw new ChartException(message, ex3);
        }
    }

    private DefaultCategoryDataset createDataset(List list) {
        SGELog.fine("entry");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int r = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (r % 1000 == 0) {
                SGELog.fine("process row " + r);
            }
            DataObject d = (DataObject)it.next();
            dataset.addValue(d.value, d.series, (Comparable)(d.category == null ? "" : d.category));
            ++r;
        }
        SGELog.fine("exit");
        return dataset;
    }

    public CategoryDataset buildStackedLineChart(SQLTableModel data, String xdata, String ydata, String type) {
        ArrayList list = new ArrayList(data.getRowCount());
        this.updateList(data, xdata, ydata, type, list);
        DefaultCategoryDataset set = this.createDataset(list);
        int cols = set.getColumnCount();
        int rows = set.getRowCount();
        for (int c = 0; c < cols; ++c) {
            Comparable colKey = set.getColumnKey(c);
            for (int r = 1; r < rows; ++r) {
                Number o = set.getValue(r, c);
                if (o == null) continue;
                double n1 = o.doubleValue();
                o = set.getValue(r - 1, c);
                if (o == null) continue;
                double n0 = o.doubleValue();
                Comparable rowKey = set.getRowKey(r);
                set.setValue(n1 += n0, rowKey, colKey);
            }
        }
        return set;
    }

    public static boolean isInvert(ChartTypes type) {
        return type == ChartTypes.STACKED_LINE_CHART;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DataObject {
        Number value;
        Comparable category;
        Comparable series;

        DataObject(Number value, Comparable category, Comparable series) {
            this.value = value;
            this.category = category;
            this.series = series;
        }
    }
}

