/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.viewconfiguration;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.sql.SQLTableModel;
import com.sun.grid.reporting.viewconfiguration.ChartTypes;
import com.sun.grid.reporting.viewconfiguration.DatasetBuilder;
import com.sun.grid.reporting.viewconfiguration.XDateAxis;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;

public class ChartManager {
    private static ChartManager s_manager;
    private DatasetBuilder m_builder = new DatasetBuilder();
    private int m_minWidth;
    private int m_minHeight;
    private int m_maxWidth;
    private int m_maxHeight;
    static /* synthetic */ Class class$com$sun$grid$reporting$viewconfiguration$ChartManager;
    static /* synthetic */ Class class$java$util$Date;

    private ChartManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChartManager getManager() {
        if (s_manager == null) {
            Class clazz = class$com$sun$grid$reporting$viewconfiguration$ChartManager == null ? (class$com$sun$grid$reporting$viewconfiguration$ChartManager = ChartManager.class$("com.sun.grid.reporting.viewconfiguration.ChartManager")) : class$com$sun$grid$reporting$viewconfiguration$ChartManager;
            synchronized (clazz) {
                if (s_manager == null) {
                    s_manager = new ChartManager();
                }
            }
        }
        return s_manager;
    }

    public List getDescription(JFreeChart chart, ChartTypes chartType) {
        if (chart == null) {
            throw new IllegalArgumentException("chart must not be null");
        }
        ArrayList<String> list = null;
        Plot plot = chart.getPlot();
        LegendItemCollection lc = plot.getLegendItems();
        list = new ArrayList<String>(2 * lc.getItemCount());
        LegendItem item = null;
        String desc = null;
        Paint paint = null;
        Color color = Color.WHITE;
        Iterator it = lc.iterator();
        while (it.hasNext()) {
            item = (LegendItem)it.next();
            desc = item.getLabel();
            list.add(desc);
            paint = item.getPaint();
            color = (Color)paint;
            list.add(this.getColorString(color));
        }
        if (DatasetBuilder.isInvert(chartType)) {
            int max = list.size();
            int max2 = max / 2;
            for (int i = 0; i < max2; ++i) {
                Object tmp = list.get(i);
                int maxx = max - i - 2;
                list.set(i, (String)list.get(maxx));
                list.set(maxx, (String)tmp);
                tmp = list.get(++i);
                maxx = max - i;
                list.set(i, (String)list.get(maxx));
                list.set(maxx, (String)tmp);
            }
        }
        return list;
    }

    private String getColorString(Color c) {
        StringBuffer b = new StringBuffer();
        this.appendHex(b, c.getRed());
        this.appendHex(b, c.getGreen());
        this.appendHex(b, c.getBlue());
        return b.toString();
    }

    private void appendHex(StringBuffer b, int i) {
        if (i < 16) {
            b.append(0);
        }
        b.append(Integer.toHexString(i));
    }

    public BufferedImage createImage(JFreeChart c, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g = image.createGraphics();
        c.draw(g, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h));
        g.dispose();
        return image;
    }

    private void checkParameters(SQLTableModel data, ChartTypes chartType, String[] inputVariables, String outputValues) {
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (chartType == null) {
            throw new NullPointerException("chart type must not be null");
        }
        if (inputVariables == null) {
            throw new IllegalArgumentException("x data must not be null");
        }
        if (outputValues == null) {
            throw new NullPointerException("y data must not be null");
        }
    }

    private void checkParameters(SQLTableModel data, ChartTypes chartType, String inputVariables, String outputValues) {
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (chartType == null) {
            throw new NullPointerException("chart type must not be null");
        }
        if (outputValues == null) {
            throw new IllegalArgumentException("outputValues must not be null");
        }
        if (inputVariables == null) {
            throw new NullPointerException("inputVariables must not be null");
        }
    }

    private void checkParameters(SQLTableModel data, ChartTypes chartType, String inputVariables, String outputValues, String type) {
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (chartType == null) {
            throw new NullPointerException("chart type must not be null");
        }
        if (inputVariables == null) {
            throw new NullPointerException("inputVariables type must not be null");
        }
        if (outputValues == null) {
            throw new IllegalArgumentException("outputValues must not be null");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
    }

    public JFreeChart createChart(SQLTableModel data, ChartTypes chartType, String[] inputVariables, String outputValues, Color bg, boolean horizontal, boolean showLegend) {
        SGELog.fine("entry");
        this.checkParameters(data, chartType, inputVariables, outputValues);
        JFreeChart chart = null;
        if (inputVariables.length > 1 && chartType == ChartTypes.BAR_CHART || inputVariables.length == 1 && chartType == ChartTypes.BAR_CHART) {
            CategoryDataset set = this.m_builder.buildBarChartDataset(data, inputVariables, outputValues);
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < inputVariables.length; ++i) {
                b.append(inputVariables[i]).append(", ");
            }
            b.setLength(b.length() - 2);
            int outputIndex = data.findColumn(outputValues);
            Class outputClass = data.getColumnClass(outputIndex);
            chart = this.createBarChart(set, outputValues, b.toString(), outputClass, horizontal ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL, showLegend);
            Paint p = bg == null ? JFreeChartConstants.DEFAULT_BACKGROUND_PAINT : bg;
            chart.setBackgroundPaint(p);
        } else if (inputVariables.length == 1 && chartType == ChartTypes.PIE_CHART) {
            chart = this.createChart(data, chartType, inputVariables[0], outputValues, bg, true, showLegend);
        } else {
            throw new IllegalArgumentException("Wrong chart type");
        }
        SGELog.fine("exit");
        return chart;
    }

    private JFreeChart createBarChart(CategoryDataset set, String outputValues, String inputVariables, Class outputType, PlotOrientation ori, boolean showLegend) {
        return ChartFactory.createBarChart(null, (String)inputVariables, (String)outputValues, (CategoryDataset)set, (PlotOrientation)ori, (boolean)showLegend, (boolean)false, (boolean)false);
    }

    public JFreeChart createChart(SQLTableModel data, ChartTypes chartType, String inputVariables, String outputValues, Color bg, boolean horizontal, boolean showLegend) {
        CategoryDataset set;
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry chartType = {0}, input = {1}, output = {2}, horizontal = " + horizontal, (Object)chartType.getName(), (Object)inputVariables, (Object)outputValues);
        }
        this.checkParameters(data, chartType, outputValues, inputVariables);
        JFreeChart chart = null;
        int outputIndex = data.findColumn(outputValues);
        Class outputClass = data.getColumnClass(outputIndex);
        if (chartType == ChartTypes.BAR_CHART) {
            SGELog.fine("build Bar ChartDataset");
            set = this.m_builder.buildBarChartDataset(data, outputValues, inputVariables);
            SGELog.fine("get format");
            SGELog.fine("create bar chart");
            chart = this.createBarChart(set, outputValues, inputVariables, outputClass, horizontal ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL, showLegend);
        } else if (chartType == ChartTypes.PIE_CHART) {
            SGELog.fine("build Pie ChartDataset");
            set = this.m_builder.buildPieChartDataset(data, outputValues, inputVariables);
            SGELog.fine("create pie chart");
            chart = ChartFactory.createPieChart(null, (PieDataset)set, (boolean)false, (boolean)false, (boolean)false);
            SGELog.fine("get plot");
        }
        if (chart != null) {
            Paint p = bg == null ? JFreeChartConstants.DEFAULT_BACKGROUND_PAINT : bg;
            chart.setBackgroundPaint(p);
        }
        SGELog.fine("exit");
        return chart;
    }

    public JFreeChart createChart(SQLTableModel data, ChartTypes chartType, String inputVariables, String outputValues, String type, Color bg, boolean horizontal, boolean showLegend) {
        TableXYDataset set;
        PlotOrientation ori;
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry chartType = ''{0}'', input = ''{1}'', output = ''{2}'', type = ''{3}'' horizontal = " + horizontal, (Object)chartType.getName(), (Object)inputVariables, (Object)outputValues, (Object)type);
        }
        this.checkParameters(data, chartType, inputVariables, outputValues, type);
        JFreeChart chart = null;
        int inputIndex = data.getColumnIndexByName(inputVariables);
        int outputIndex = data.getColumnIndexByName(outputValues);
        Class inputClass = data.getColumnClass(inputVariables);
        Class outputClass = data.getColumnClass(outputValues);
        PlotOrientation plotOrientation = ori = horizontal ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        if (chartType == ChartTypes.LINE_CHART) {
            SGELog.fine("build line chart dataset");
            set = this.m_builder.buildXYChartDataset(data, inputVariables, outputValues, type);
            SGELog.fine("createXYLineChart");
            chart = ChartFactory.createXYLineChart(null, (String)inputVariables, (String)outputValues, (XYDataset)set, (PlotOrientation)ori, (boolean)showLegend, (boolean)false, (boolean)false);
            if ((class$java$util$Date == null ? (class$java$util$Date = ChartManager.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(inputClass)) {
                chart.getXYPlot().setDomainAxis((ValueAxis)new DateAxis(inputVariables));
            }
        } else if (chartType == ChartTypes.STACKED_LINE_CHART) {
            SGELog.fine("build stacked line chart dataset");
            set = this.m_builder.buildXYChartDataset(data, inputVariables, outputValues, type);
            SGELog.fine("create stacked line chart");
            chart = ChartFactory.createStackedXYAreaChart(null, (String)inputVariables, (String)outputValues, (TableXYDataset)set, (PlotOrientation)ori, (boolean)showLegend, (boolean)false, (boolean)false);
            if ((class$java$util$Date == null ? (class$java$util$Date = ChartManager.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(inputClass)) {
                chart.getXYPlot().setDomainAxis((ValueAxis)new DateAxis(inputVariables));
            }
        } else if (chartType == ChartTypes.BAR_CHART) {
            SGELog.fine("build bar chart dataset");
            set = this.m_builder.buildBarChartDataset(data, inputVariables, outputValues, type);
            SGELog.fine("getFormat");
            SGELog.fine("create bar chart");
            chart = this.createBarChart((CategoryDataset)set, outputValues, inputVariables, outputClass, ori, showLegend);
        }
        if (chart != null) {
            Paint p = bg == null ? JFreeChartConstants.DEFAULT_BACKGROUND_PAINT : bg;
            chart.setBackgroundPaint(p);
        }
        SGELog.fine("exit");
        return chart;
    }

    private JFreeChart createLineChart(String title, String categoryAxisLabel, String valueAxisLabel, Class valueType, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        ValueAxis valueAxis = this.getValueAxis(valueType, null);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setDrawLines(true);
        renderer.setDrawShapes(false);
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, valueAxis, (CategoryItemRenderer)renderer);
        plot.setDomainGridlinesVisible(true);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private void updateLineChartRenderer(JFreeChart chart) {
    }

    public String getDescriptionHTMLTable(JFreeChart chart, ChartTypes chartType) {
        List desc = this.getDescription(chart, chartType);
        if (desc.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer("<table border=\"0\"><tr><th colspan=\"2\">Legend</th></tr>");
        Iterator it = desc.iterator();
        while (it.hasNext()) {
            String tn = (String)it.next();
            String color = null;
            if (it.hasNext()) {
                color = (String)it.next();
            }
            buf.append("<tr><td width=\"30\" bgcolor=\"#").append(color).append("\"> </td><td>").append(tn).append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    private ValueAxis getValueAxis(Class c, String valueAxisLabel) {
        if ((class$java$util$Date == null ? (class$java$util$Date = ChartManager.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(c)) {
            return new XDateAxis(valueAxisLabel);
        }
        return new NumberAxis(valueAxisLabel);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

