/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.util;

import com.sun.grid.reporting.dob.DobInterface;
import com.sun.grid.reporting.util.SortType;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Sorter {
    private DobComparator m_comp = new DobComparator();

    public void sort(List source, int index, SortType type) {
        this.m_comp.init(index, type);
        Collections.sort(source, this.m_comp);
    }

    public void sort(List source, int index1, int index2, SortType type) {
        this.m_comp.init(index1, index2, type);
        Collections.sort(source, this.m_comp);
    }

    private static class DobComparator
    implements Comparator {
        private int idx1;
        private int idx2;
        private int levels = 1;
        private SortType dir;

        private DobComparator() {
        }

        public void init(int idx, SortType dir) {
            this.idx1 = idx;
            this.levels = 1;
            this.dir = dir;
        }

        public void init(int idx1, int idx2, SortType dir) {
            this.idx1 = idx1;
            this.idx2 = idx2;
            this.levels = 2;
            this.dir = dir;
        }

        private int myCompare(Comparable c1, Comparable c2) {
            int c = 1;
            c = c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
            return c;
        }

        public int compare(Object o1, Object o2) {
            DobInterface d1 = (DobInterface)o1;
            DobInterface d2 = (DobInterface)o2;
            Comparable c1 = (Comparable)d1.getValue(this.idx1);
            Comparable c2 = (Comparable)d2.getValue(this.idx1);
            int c = this.myCompare(c1, c2);
            if (this.levels == 1) {
                return this.dir == SortType.ASC ? c : -c;
            }
            if (c != 0) {
                return this.dir == SortType.ASC ? c : -c;
            }
            c1 = (Comparable)d1.getValue(this.idx2);
            c2 = (Comparable)d2.getValue(this.idx2);
            c = this.myCompare(c1, c2);
            return this.dir == SortType.ASC ? c : -c;
        }
    }
}

