/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.util;

import com.iplanet.jato.view.html.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LogicalConnection
extends Option {
    public static final LogicalConnection AND = new LogicalConnection("and", "AND");
    public static final LogicalConnection OR = new LogicalConnection("or", "OR");
    private static List connections = new ArrayList();
    private static List selectableConnections;
    private String symbol;

    private LogicalConnection(String name, String symbol) {
        super(name, name);
        this.symbol = symbol;
    }

    public String getName() {
        return this.getLabel();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean equals(Object obj) {
        try {
            LogicalConnection lc = (LogicalConnection)((Object)obj);
            if (!lc.getName().equals(this.getName())) {
                return false;
            }
            if (!lc.symbol.equals(this.symbol)) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append("[Name: " + this.getName() + "], ");
        retVal.append("[Symbol: " + this.symbol + "], ");
        return retVal.toString();
    }

    public static LogicalConnection getLogicalConnectionByName(String name) {
        Iterator findIt = connections.iterator();
        while (findIt.hasNext()) {
            LogicalConnection dummy = (LogicalConnection)((Object)findIt.next());
            if (!dummy.getName().equals(name)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No LogicalConnection found for name " + name);
    }

    public static LogicalConnection getLogicalConnectionBySymbol(String sybmol) {
        Iterator findIt = connections.iterator();
        while (findIt.hasNext()) {
            LogicalConnection dummy = (LogicalConnection)((Object)findIt.next());
            if (!dummy.getSymbol().equals(sybmol)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No LogicalConnection found for sybmol " + sybmol);
    }

    public static List getSelectableConection() {
        return selectableConnections;
    }

    static {
        connections.add(AND);
        connections.add(OR);
        selectableConnections = Collections.unmodifiableList(connections);
    }
}

