/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.util;

import com.sun.grid.reporting.util.NamedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FilterType
extends NamedObject {
    public static final FilterType EQUAL = new FilterType("equal", "=", "=", 1);
    public static final FilterType NOT_EQUAL = new FilterType("not_equal", "!=", "!=", 1);
    public static final FilterType LESS = new FilterType("less", "&lt;", "<", 1);
    public static final FilterType LESS_EQUAL = new FilterType("less_equal", "&le;", "<=", 1);
    public static final FilterType GREATER = new FilterType("greater", "&gt;", ">", 1);
    public static final FilterType GREATER_EQUAL = new FilterType("greater_equal", "&ge;", ">=", 1);
    public static final FilterType NULL = new FilterType("null", "IS NULL", "IS NULL", 0);
    public static final FilterType NOT_NULL = new FilterType("not_null", "IS NOT NULL", "IS NOT NULL", 0);
    public static final FilterType BETWEEN = new FilterType("between", "BETWEEN", "BETWEEN", 1);
    public static final FilterType IN = new FilterType("in", "IN", "IN", 1);
    public static final FilterType LIKE = new FilterType("like", "LIKE", "LIKE", 1);
    private String symbol;
    private int parameterCount;
    private static List filterTypes = new ArrayList();
    private static List selectableFilterTypes;

    private FilterType(String name, String label, String symbol, int paramCount) {
        super(name, label);
        this.symbol = symbol;
        this.parameterCount = paramCount;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean equals(Object obj) {
        try {
            FilterType ft = (FilterType)obj;
            if (!ft.getName().equals(this.getName())) {
                return false;
            }
            if (!ft.symbol.equals(this.symbol)) {
                return false;
            }
            if (ft.parameterCount != this.parameterCount) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static FilterType getFilterTypeByName(String name) throws IllegalArgumentException {
        Iterator findIt = filterTypes.iterator();
        while (findIt.hasNext()) {
            FilterType dummy = (FilterType)findIt.next();
            if (!dummy.getName().equals(name)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No FilterType found for name " + name);
    }

    public static FilterType getFilterTypeByLabel(String label) throws IllegalArgumentException {
        Iterator findIt = filterTypes.iterator();
        while (findIt.hasNext()) {
            FilterType dummy = (FilterType)findIt.next();
            if (!dummy.getLabel().equals(label)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No FilterType found for label " + label);
    }

    public static FilterType getFilterTypeBySymbol(String sybmol) throws IllegalArgumentException {
        Iterator findIt = filterTypes.iterator();
        while (findIt.hasNext()) {
            FilterType dummy = (FilterType)findIt.next();
            if (!dummy.getSymbol().equals(sybmol)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No FilterType found for sybmol " + sybmol);
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append("[Name: " + this.getName() + "], ");
        retVal.append("[Symbol: " + this.symbol + "], ");
        retVal.append("[Number of needed Parameters: " + Integer.toString(this.parameterCount) + "]");
        return retVal.toString();
    }

    public static List getSelectableFilterTypes() {
        return selectableFilterTypes;
    }

    static {
        filterTypes.add(EQUAL);
        filterTypes.add(NOT_EQUAL);
        filterTypes.add(LESS);
        filterTypes.add(LESS_EQUAL);
        filterTypes.add(GREATER);
        filterTypes.add(GREATER_EQUAL);
        filterTypes.add(NULL);
        filterTypes.add(NOT_NULL);
        filterTypes.add(BETWEEN);
        filterTypes.add(IN);
        filterTypes.add(LIKE);
        selectableFilterTypes = Collections.unmodifiableList(filterTypes);
    }
}

