/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.util;

import com.sun.grid.reporting.util.NamedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FieldFunction
extends NamedObject {
    public static final FieldFunction VALUE = new FieldFunction("VALUE", 1);
    public static final FieldFunction COUNT = new FieldFunction("COUNT", 1, true);
    public static final FieldFunction MIN = new FieldFunction("MIN", 1, true);
    public static final FieldFunction MAX = new FieldFunction("MAX", 1, true);
    public static final FieldFunction SUM = new FieldFunction("SUM", 1, true);
    public static final FieldFunction AVG = new FieldFunction("AVG", 1, true);
    public static final FieldFunction ADDITION = new FieldFunction("+", 2, false, true);
    public static final FieldFunction SUBSTRACTION = new FieldFunction("-", 2, false, true);
    public static final FieldFunction MULIPLY = new FieldFunction("*", 2, false, true);
    public static final FieldFunction DIVISION = new FieldFunction("/", 2, false, true);
    private int parameterCount;
    private boolean isAggregate;
    private boolean typeTestNeeded;
    private static List fieldFunctions = new ArrayList();
    private static List selectableFieldFunctions;

    private FieldFunction(String name, int paramCount, boolean isAggregate, boolean typeTest) {
        super(name);
        this.parameterCount = paramCount;
        this.isAggregate = isAggregate;
        this.typeTestNeeded = typeTest;
    }

    private FieldFunction(String name, int paramCount, boolean isAggregate) {
        this(name, paramCount, isAggregate, false);
    }

    private FieldFunction(String name, int paramCount) {
        this(name, paramCount, false);
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean isAggreagate() {
        return this.isAggregate;
    }

    public String toString() {
        StringBuffer msg = new StringBuffer("[Class: " + this.getClass());
        msg.append("], [Name: " + this.getName());
        msg.append("], [No of parameters: " + this.parameterCount);
        msg.append("]");
        return msg.toString();
    }

    public boolean equals(Object obj) {
        try {
            FieldFunction ff = (FieldFunction)obj;
            if (!ff.getName().equals(this.getName())) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static FieldFunction getFieldFunctionByName(String name) {
        Iterator findIt = fieldFunctions.iterator();
        while (findIt.hasNext()) {
            FieldFunction dummy = (FieldFunction)findIt.next();
            if (!dummy.getName().equals(name)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No FieldFunction found for name " + name);
    }

    public static List getSelectableFieldFunctions() {
        return selectableFieldFunctions;
    }

    public boolean isTypeTestNeeded() {
        return this.typeTestNeeded;
    }

    static {
        fieldFunctions.add(VALUE);
        fieldFunctions.add(COUNT);
        fieldFunctions.add(MIN);
        fieldFunctions.add(MAX);
        fieldFunctions.add(SUM);
        fieldFunctions.add(AVG);
        fieldFunctions.add(ADDITION);
        fieldFunctions.add(SUBSTRACTION);
        fieldFunctions.add(MULIPLY);
        fieldFunctions.add(DIVISION);
        selectableFieldFunctions = Collections.unmodifiableList(fieldFunctions);
    }
}

