/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.util;

import java.util.Iterator;
import java.util.Vector;

public class DbType {
    private static Vector supportedDatabases = new Vector(0);
    public static final DbType POSTGRESQL = new DbType("Postgres", "jdbc:postgresql:", "org.postgresql.Driver");
    public static final DbType ORACLE = new DbType("Oracle9i", "jdbc:oracle:", "oracle.jdbc.driver.OracleDriver");
    public static final DbType MYSQL = new DbType("MySQL", "jdbc:mysql:", "org.mysql.Driver");
    private String driver;
    private String urlPrefix;
    private String name;

    private DbType(String name, String urlPrefix, String driver) {
        this.urlPrefix = urlPrefix;
        this.driver = driver;
        this.name = name;
        if (supportedDatabases == null) {
            supportedDatabases = new Vector(0);
        }
        supportedDatabases.add(this);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getName() {
        return this.name;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public boolean equals(Object obj) {
        try {
            DbType dbtype = (DbType)obj;
            if (!dbtype.driver.equals(this.driver)) {
                return false;
            }
            if (!dbtype.name.equals(this.name)) {
                return false;
            }
            if (!dbtype.urlPrefix.equals(this.urlPrefix)) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static DbType getDbTypeByDriverClass(String driverClass) {
        Iterator findIt = DbType.getSupportedDatabases();
        while (findIt.hasNext()) {
            DbType dummy = (DbType)findIt.next();
            if (!dummy.getDriver().equals(driverClass)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No DbType found for DriverClass " + driverClass);
    }

    public static DbType getDbTypeByName(String name) {
        Iterator findIt = DbType.getSupportedDatabases();
        while (findIt.hasNext()) {
            DbType dummy = (DbType)findIt.next();
            if (!dummy.getName().equals(name)) continue;
            return dummy;
        }
        throw new IllegalArgumentException("No DbType found for name " + name);
    }

    public static Iterator getSupportedDatabases() {
        return supportedDatabases.iterator();
    }
}

