/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class CryptoHandler {
    private static final String algorithm = "DES";
    private static final byte[] key = new byte[]{7, -88, 48, -25, 17, -34, 59, -13};
    private static SecretKeySpec skeySpec;
    private static Cipher cipher;

    private static void generateKey() {
        try {
            skeySpec = new SecretKeySpec(key, algorithm);
            cipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsaEx) {
            throw new IllegalStateException("Algorithm for encryption not found");
        }
        catch (Exception nsaEx) {
            throw new IllegalStateException("Unable to instanciate values for en-/decryption");
        }
    }

    public static String encrypt(String text) {
        String retVal = null;
        try {
            CryptoHandler.generateKey();
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(text.getBytes());
            retVal = new String(CryptoHandler.asHex(encrypted));
            return retVal;
        }
        catch (InvalidKeyException ikEx) {
            throw new IllegalStateException("The key for encryption might be invalid");
        }
        catch (Exception ibsEx) {
            throw new IllegalStateException("Blocksize for encryption is illegal");
        }
    }

    public static String decrypt(String encryptedText) {
        String retVal = null;
        try {
            CryptoHandler.generateKey();
            cipher.init(2, skeySpec);
            byte[] decrypted = cipher.doFinal(CryptoHandler.fromHex(encryptedText));
            retVal = new String(decrypted);
            return retVal;
        }
        catch (InvalidKeyException ikEx) {
            throw new IllegalStateException("The key for encryption might be invalid");
        }
        catch (Exception ibsEx) {
            ibsEx.printStackTrace();
            return "";
        }
    }

    private static String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }

    private static byte[] fromHex(String value) {
        if (value.length() % 2 != 0) {
            throw new IllegalArgumentException("The incoming Hex-value is corrupt");
        }
        byte[] retVal = new byte[value.length() / 2];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = Integer.decode("0x" + value.substring(i * 2, i * 2 + 2)).byteValue();
        }
        return retVal;
    }

    public static void usage() {
        System.out.println("usage:\n\tdbpwd <list of text>");
        System.out.println("The list of blank-separated text to encrypted");
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                System.err.println("Please enter the password: ");
                String pw = in.readLine();
                args = new String[]{pw};
            }
            for (int i = 0; i < args.length; ++i) {
                System.out.println(CryptoHandler.encrypt(args[i]));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }

    public static void OLDmain(String[] args) throws Exception {
        if (args.length < 1) {
            CryptoHandler.usage();
        }
        Vector<String> decrypt = new Vector<String>(0);
        Vector<String> encrypt = new Vector<String>(0);
        boolean encryption = true;
        for (int i = 0; i < args.length; ++i) {
            String value;
            if (args[i].equals("-e")) {
                encryption = true;
                continue;
            }
            if (args[i].equals("-d")) {
                encryption = false;
                continue;
            }
            if (encryption) {
                value = CryptoHandler.encrypt(args[i]);
                System.out.println(args[i] + "\t=>\t" + value);
                decrypt.add(value);
                continue;
            }
            value = CryptoHandler.decrypt(args[i]);
            System.out.println(args[i] + "\t=>\t" + value);
            encrypt.add(value);
        }
    }
}

