/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.util;

import com.sun.grid.reporting.util.SortType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ComparatorProxy {
    private static Map m_comparators = new HashMap();
    private static final Object LOCK = new Object();
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$lang$Boolean;

    private ComparatorProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Comparator getComparator(Class c) {
        Object o = m_comparators.get(c);
        if (o == null) {
            Object object = LOCK;
            synchronized (object) {
                if ((class$java$lang$Comparable == null ? (class$java$lang$Comparable = ComparatorProxy.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(c)) {
                    o = new DefaultComparator();
                } else if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ComparatorProxy.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    o = new BooleanComparator();
                }
                m_comparators.put(c, o);
            }
        }
        return (Comparator)o;
    }

    public static Comparator getComparator(Class c, SortType type) {
        Comparator comp = ComparatorProxy.getComparator(c);
        if (comp == null) {
            return null;
        }
        if (type == SortType.DESC) {
            Comparator inv;
            final Comparator cc = comp;
            comp = inv = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return cc.compare(o2, o1);
                }
            };
        }
        return comp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BooleanComparator
    implements Comparator {
        private BooleanComparator() {
        }

        public int compare(Object o1, Object o2) {
            Boolean b1 = (Boolean)o1;
            Boolean b2 = (Boolean)o2;
            if (b1.equals(b2)) {
                return 0;
            }
            if (Boolean.TRUE.equals(b1)) {
                return 1;
            }
            return -1;
        }
    }

    private static class DefaultComparator
    implements Comparator {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
    }
}

