/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.tests;

import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.sql.SQLTableModel;
import com.sun.grid.reporting.util.ArcoPivotTreeNode;

public class TestPivotTable {
    SQLTableModel sqlTM;
    int indentionDepth = 0;

    public void loadResult() {
    }

    public void printDbTable() {
        int fieldCount = this.sqlTM.getColumnCount();
        int rows = this.sqlTM.getRowCount();
        for (int col = 0; col < fieldCount; ++col) {
            System.out.print(this.sqlTM.getColumnName(col));
            if (col >= fieldCount - 1) continue;
            System.out.print(",");
        }
        System.out.println();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < fieldCount; ++col) {
                System.out.print(this.sqlTM.getValueAt(row, col));
                if (col >= fieldCount - 1) continue;
                System.out.print(",");
            }
            System.out.println();
        }
    }

    public SQLTableModel getSQLTableModel() {
        return this.sqlTM;
    }

    public void listTree(ArcoPivotTreeNode node) {
        ++this.indentionDepth;
        System.out.print(node.getLevel());
        this.indent();
        System.out.println(node.getUserObject());
        if (!node.isLeaf()) {
            int childCount = node.getChildCount();
            for (int child = 0; child < childCount; ++child) {
                this.listTree((ArcoPivotTreeNode)node.getChildAt(child));
            }
        }
        --this.indentionDepth;
    }

    private void indent() {
        String indentStr = "  ";
        for (int i = 1; i < this.indentionDepth; ++i) {
            System.out.print(indentStr);
        }
    }

    public static void main(String[] args) {
        TestPivotTable app = new TestPivotTable();
        app.loadResult();
        app.printDbTable();
        PivotViewConfiguration pvc = new PivotViewConfiguration();
        pvc.setSQLTableModel(app.getSQLTableModel());
        pvc.addRowAttribute("time");
        pvc.addColumnAttribute("host");
        pvc.addColumnAttribute("job");
        pvc.setDataAttribute("prio");
        pvc.buildTree();
        System.out.println("rows");
        ArcoPivotTreeNode aptn = pvc.getRowHeader();
        System.out.println(aptn.getDepth());
        app.listTree(aptn);
        System.out.println("columns");
        aptn = pvc.getColumnHeader();
        System.out.println(aptn.getDepth());
        app.listTree(aptn);
        int rowCount = pvc.getRowCount();
        int colCount = pvc.getColumnCount();
        System.out.println("The Pivottable has " + rowCount + " rows and " + colCount + " columns.");
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                System.out.print(pvc.getValueAt(row, col));
                pvc.getValueAt(row, col);
                if (col >= colCount - 1) continue;
                System.out.print(",");
            }
            System.out.println();
        }
    }
}

