/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

import com.sun.grid.reporting.sql.SQLTableModel;
import com.sun.grid.reporting.util.ComparatorProxy;
import com.sun.grid.reporting.util.SortType;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class SortableSQLTableModel
extends SQLTableModel {
    private SQLTableModel m_delegate;
    private int[] m_rows;
    private boolean init = true;

    public SortableSQLTableModel(SQLTableModel source) {
        this.m_delegate = source;
        this.m_rows = new int[this.m_delegate.getRowCount()];
        for (int i = 0; i < this.m_rows.length; ++i) {
            this.m_rows[i] = i;
        }
    }

    public void sort(String colName, SortType dir) {
        int col = this.getColumnIndexByName(colName);
        this.sort(col, dir);
    }

    public void sort(int colIdx, SortType dir) {
        Class clazz = this.getColumnClass(colIdx);
        Comparator c = ComparatorProxy.getComparator(clazz, dir);
        if (c == null) {
            return;
        }
        this.sort(c, 0, this.m_rows.length, colIdx);
        this.m_delegate.fireTableDataChanged();
    }

    private void sort(Comparator c, int low, int high, int colIdx) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low && c.compare(this.getValueAt(j - 1, colIdx), this.getValueAt(j, colIdx)) > 0; --j) {
                this.swap(j, j - 1);
            }
        }
    }

    private void swap(int a, int b) {
        int temp = this.m_rows[a];
        this.m_rows[a] = this.m_rows[b];
        this.m_rows[b] = temp;
    }

    public final Object getValueAt(int row, int column) {
        return this.m_delegate.getValueAt(this.m_rows[row], column);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public boolean hasData() {
        return this.m_delegate.hasData();
    }

    public void addColumn(Object columnName) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void addColumn(Object columnName, Object[] columnData) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void addColumn(Object columnName, Vector columnData) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void addRow(Object[] rowData) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void addRow(Vector rowData) {
        throw new UnsupportedOperationException("Model is read only");
    }

    protected static Vector convertToVector(Object[] anArray) {
        return DefaultTableModel.convertToVector(anArray);
    }

    protected static Vector convertToVector(Object[][] anArray) {
        return DefaultTableModel.convertToVector(anArray);
    }

    public int getColumnCount() {
        return this.m_delegate.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.m_delegate.getColumnName(column);
    }

    public Vector getDataVector() {
        return this.m_delegate.getDataVector();
    }

    public int getRowCount() {
        return this.m_delegate.getRowCount();
    }

    public void insertRow(int row, Object[] rowData) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void insertRow(int row, Vector rowData) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void moveRow(int start, int end, int to) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void newDataAvailable(TableModelEvent event) {
        this.m_delegate.newDataAvailable(event);
    }

    public void newRowsAdded(TableModelEvent e) {
        this.m_delegate.newRowsAdded(e);
    }

    public void removeRow(int row) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void rowsRemoved(TableModelEvent event) {
        this.m_delegate.rowsRemoved(event);
    }

    public void setColumnCount(int columnCount) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setColumnIdentifiers(Object[] newIdentifiers) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setDataVector(Object[][] dataVector, Object[] columnIdentifiers) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setDataVector(Vector dataVector, Vector columnIdentifiers) {
        if (this.init) {
            throw new UnsupportedOperationException("Model is read only");
        }
    }

    public void setNumRows(int rowCount) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setRowCount(int rowCount) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setValueAt(Object aValue, int row, int column) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void addTableModelListener(TableModelListener l) {
        this.m_delegate.addTableModelListener(l);
    }

    public int findColumn(String columnName) {
        return this.m_delegate.findColumn(columnName);
    }

    public void fireTableCellUpdated(int row, int column) {
        this.m_delegate.fireTableCellUpdated(row, column);
    }

    public void fireTableChanged(TableModelEvent e) {
        this.m_delegate.fireTableChanged(e);
    }

    public void fireTableDataChanged() {
        this.m_delegate.fireTableDataChanged();
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.m_delegate.fireTableRowsDeleted(firstRow, lastRow);
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.m_delegate.fireTableRowsInserted(firstRow, lastRow);
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.m_delegate.fireTableRowsUpdated(firstRow, lastRow);
    }

    public void fireTableStructureChanged() {
        this.m_delegate.fireTableStructureChanged();
    }

    public Class getColumnClass(int columnIndex) {
        return this.m_delegate.getColumnClass(columnIndex);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.m_delegate.getListeners(listenerType);
    }

    public TableModelListener[] getTableModelListeners() {
        return this.m_delegate.getTableModelListeners();
    }

    public void removeTableModelListener(TableModelListener l) {
        this.m_delegate.removeTableModelListener(l);
    }
}

