/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

import com.sun.grid.reporting.sql.SQLLexer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;

public class SQLParser {
    SQLLexer scanner;
    ArrayList fieldList = new ArrayList();

    public SQLParser(String sql) {
        this.scanner = new SQLLexer(sql);
    }

    private int scan() {
        return this.scanner.scan();
    }

    private void test(int token) throws ParseException {
        if (this.token() != token) {
            throw this.error(token);
        }
    }

    private void testAndScan(int token) throws ParseException {
        this.test(token);
        this.scan();
    }

    private ParseException error(int expectedToken) {
        return this.error("Token '" + SQLLexer.tokenToStr(expectedToken) + "' expected, but got " + this.scanner.getTokenString());
    }

    private ParseException error(int[] tokens) {
        StringBuffer msg = new StringBuffer();
        msg.append("Token ");
        for (int i = 0; i < tokens.length - 1; ++i) {
            msg.append(SQLLexer.tokenToStr(tokens[i]));
            msg.append(' ');
        }
        msg.append("or ");
        msg.append(SQLLexer.tokenToStr(tokens[tokens.length - 1]));
        msg.append(" expected, but got ");
        msg.append(this.scanner.getTokenString());
        return this.error(msg.toString());
    }

    private ParseException error(String text) {
        return new ParseException(text, this.scanner.getOffset());
    }

    public ArrayList getFieldList() {
        return this.fieldList;
    }

    private int token() {
        return this.scanner.getToken();
    }

    public void parse() throws ParseException {
        this.scan();
        this.testAndScan(2);
        this.parseFields();
    }

    private void parseFields() throws ParseException {
        Field field = this.parseField();
        this.fieldList.add(field);
        while (this.token() == 5) {
            this.scan();
            field = this.parseField();
            this.fieldList.add(field);
        }
    }

    private Field parseField() throws ParseException {
        Field ret = new Field();
        StringBuffer expr = new StringBuffer();
        this.parseExpr(expr);
        ret.setExpr(expr.toString());
        if (this.token() == 4) {
            this.scan();
            this.test(1);
            ret.setName(this.scanner.getTokenText());
            this.scan();
        }
        return ret;
    }

    private void parseExpr(StringBuffer buf) throws ParseException {
        StringBuffer ret = new StringBuffer();
        switch (this.token()) {
            case 6: {
                this.parseBracket(buf);
                break;
            }
            case 1: {
                this.parseStringList(buf);
                break;
            }
            default: {
                throw this.error(new int[]{6, 1});
            }
        }
        block8: while (true) {
            switch (this.token()) {
                case 6: {
                    this.parseBracket(buf);
                    continue block8;
                }
                case 1: {
                    this.parseStringList(buf);
                    continue block8;
                }
            }
            break;
        }
    }

    private void parseBracket(StringBuffer buf) throws ParseException {
        this.test(6);
        if (buf.length() > 0) {
            buf.append(' ');
        }
        int offset = this.scanner.getOffset();
        buf.append(this.scanner.getTokenText());
        this.scan();
        boolean first = true;
        block5: while (true) {
            switch (this.token()) {
                case 7: {
                    buf.append(this.scanner.getTokenText());
                    this.scan();
                    break block5;
                }
                case -1: {
                    throw this.error("Unmatched " + SQLLexer.tokenToStr(6) + "" + " at offset " + offset);
                }
                case 6: {
                    this.parseBracket(buf);
                    continue block5;
                }
                default: {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(' ');
                    }
                    buf.append(this.scanner.getTokenText());
                    this.scan();
                    continue block5;
                }
            }
            break;
        }
    }

    private void parseStringList(StringBuffer buf) throws ParseException {
        this.test(1);
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.scanner.getTokenText());
        this.scan();
        while (this.token() == 1) {
            buf.append(' ');
            buf.append(this.scanner.getTokenText());
            this.scan();
        }
    }

    public static void main(String[] args) {
        String sql = "SELECT (SELECT x , trunc( (xxx, yy ) from x) as 'a b', b as b , ( xxx + xc ) as s , c from xxx wher sfasdfasdf sdfasf";
        SQLParser p = new SQLParser(sql);
        try {
            p.parse();
            Iterator iter = p.getFieldList().iterator();
            Field field = null;
            while (iter.hasNext()) {
                field = (Field)iter.next();
                System.out.print(field.getName());
                System.out.print(" -> ");
                System.out.println(field.getExpr());
            }
        }
        catch (ParseException pe) {
            System.err.println("parse error: " + pe.getMessage());
            pe.printStackTrace();
        }
    }

    public static class Field {
        private String expr;
        private String name;

        public void setExpr(String s) {
            this.expr = s;
        }

        public String getExpr() {
            return this.expr;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

