/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

public class SQLLexer {
    public static final int TOKEN_STRING = 1;
    public static final int TOKEN_SELECT = 2;
    public static final int TOKEN_FROM = 3;
    public static final int TOKEN_AS = 4;
    public static final int TOKEN_COMMA = 5;
    public static final int TOKEN_BRACKET_1 = 6;
    public static final int TOKEN_BRACKET_2 = 7;
    public static final int TOKEN_EOF = -1;
    public static final int TOKEN_ERROR = -2;
    private String sql;
    private int pos;
    private int token = -1;
    private char currentChar;
    private StringBuffer tokenText = new StringBuffer();
    private boolean eof = false;

    public int getToken() {
        return this.token;
    }

    public String getTokenText() {
        return this.tokenText.toString();
    }

    public int getOffset() {
        return this.pos;
    }

    public static String tokenToStr(int token) {
        switch (token) {
            case 1: {
                return "STR";
            }
            case 2: {
                return "SELECT";
            }
            case 3: {
                return "FROM";
            }
            case 4: {
                return "AS";
            }
            case 5: {
                return "','";
            }
            case 6: {
                return "'('";
            }
            case 7: {
                return "')'";
            }
            case -1: {
                return "EOF";
            }
            case -2: {
                return "ERROR";
            }
        }
        return "UNKNOWN(" + token + ")";
    }

    public String getTokenString() {
        switch (this.token) {
            case 1: {
                return "STR('" + this.tokenText + "')";
            }
            case 2: {
                return "SELECT";
            }
            case 3: {
                return "FROM";
            }
            case 4: {
                return "AS";
            }
            case 5: {
                return "','";
            }
            case 6: {
                return "'('";
            }
            case 7: {
                return "')'";
            }
            case -1: {
                return "EOF";
            }
            case -2: {
                return "ERROR('" + this.tokenText + "')";
            }
        }
        return "UNKNOWN('" + this.token + "')";
    }

    public SQLLexer(String sql) {
        this.sql = sql;
        this.pos = -1;
    }

    private char nextChar() throws EOFException {
        ++this.pos;
        if (this.eof()) {
            this.eof = true;
            throw new EOFException();
        }
        this.currentChar = this.sql.charAt(this.pos);
        return this.currentChar;
    }

    public boolean eof() {
        return this.pos >= this.sql.length();
    }

    public int scan() {
        try {
            this.tokenText.setLength(0);
            if (this.pos < 0) {
                this.nextChar();
            }
            if (this.eof()) {
                this.token = -1;
                return this.token;
            }
            switch (this.currentChar) {
                case ',': {
                    this.token = 5;
                    this.tokenText.append(this.currentChar);
                    if (!this.eof()) {
                        this.nextChar();
                    }
                    break;
                }
                case '(': {
                    this.token = 6;
                    this.tokenText.append(this.currentChar);
                    if (!this.eof()) {
                        this.nextChar();
                    }
                    break;
                }
                case ')': {
                    this.token = 7;
                    this.tokenText.append(this.currentChar);
                    if (!this.eof()) {
                        this.nextChar();
                    }
                    break;
                }
                case '\"': 
                case '\'': {
                    this.scanLiteral();
                    break;
                }
                default: {
                    if (Character.isWhitespace(this.currentChar)) {
                        while (Character.isWhitespace(this.currentChar)) {
                            this.nextChar();
                        }
                        return this.scan();
                    }
                    try {
                        block16: while (true) {
                            this.tokenText.append(this.currentChar);
                            this.nextChar();
                            switch (this.currentChar) {
                                case '(': {
                                    break block16;
                                }
                                case ')': {
                                    break block16;
                                }
                                case ',': {
                                    break block16;
                                }
                                default: {
                                    if (!Character.isWhitespace(this.currentChar)) continue block16;
                                    break block16;
                                }
                            }
                            break;
                        }
                    }
                    catch (EOFException eofe) {
                        // empty catch block
                    }
                    String str = this.tokenText.toString();
                    if (str.equalsIgnoreCase("AS")) {
                        this.token = 4;
                        break;
                    }
                    if (str.equalsIgnoreCase("SELECT")) {
                        this.token = 2;
                        break;
                    }
                    if (str.equalsIgnoreCase("FROM")) {
                        this.token = 3;
                        break;
                    }
                    this.token = 1;
                    break;
                }
            }
        }
        catch (EOFException eofe) {
            this.token = -1;
        }
        return this.token;
    }

    private int scanLiteral() throws EOFException {
        char lit = this.currentChar;
        this.tokenText.append(lit);
        while (!this.eof()) {
            this.nextChar();
            if (this.currentChar == lit) {
                if (this.eof()) {
                    this.tokenText.append(lit);
                    break;
                }
                this.tokenText.append(lit);
                this.nextChar();
                if (this.currentChar == lit) continue;
                break;
            }
            this.tokenText.append(this.currentChar);
        }
        this.token = 1;
        return this.token;
    }

    private static void scanRun(String sql) {
        SQLLexer lexer = new SQLLexer(sql);
        System.out.println(sql);
        int token = 0;
        do {
            token = lexer.scan();
            System.out.print(lexer.getTokenString());
            System.out.print(' ');
        } while (token > 0);
        System.out.println();
    }

    public static void main(String[] args) {
        SQLLexer.scanRun("SELECT  aa as a, bb as b from xxx ");
        SQLLexer.scanRun("SELECT  trunc( xx + yy, \n 'day''()' ) as \"aa\", bb as b from xxx ");
    }

    private static class EOFException
    extends Exception {
        public EOFException() {
            super("EOF");
        }
    }
}

