/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

import com.sun.grid.arco.QueryConverter;
import com.sun.grid.arco.QueryManager;
import com.sun.grid.arco.ResultConverter;
import com.sun.grid.arco.ResultManager;
import com.sun.grid.arco.model.NamedObject;
import com.sun.grid.arco.model.Query;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.control.ResultExportControl;
import com.sun.grid.reporting.dob.ListObject;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.Result;
import com.sun.grid.reporting.sql.ArcoDbConnection;
import com.sun.grid.reporting.sql.ArcoDbConnectionPool;
import com.sun.grid.reporting.sql.SQLGenerator;
import com.sun.grid.reporting.sql.SQLTableModel;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SQLExecutor {
    private ArcoDbConnectionPool dbConnectionPool;
    private SQLTableModel sqlTM;
    private String applicationUser;
    private int tryCounter = 0;

    public SQLExecutor(ArcoDbConnectionPool dbPool) {
        this.setDbConnectionPool(dbPool);
    }

    public ArcoDbConnectionPool getDbConnectionPool() {
        return this.dbConnectionPool;
    }

    public void setDbConnectionPool(ArcoDbConnectionPool dbPool) {
        this.dbConnectionPool = dbPool;
    }

    public void setApplicationUser(String appUser) {
        this.applicationUser = appUser;
    }

    public List getViewList() throws SQLException {
        return this.dbConnectionPool.getViewList();
    }

    public Vector getResultList(String table) {
        NamedObject[] results = ResultManager.getInstance().getAvailableObjects();
        Vector<ListObject> ret = new Vector<ListObject>();
        if (results != null && results.length > 0) {
            ListObject lo = null;
            for (int i = 0; i < results.length; ++i) {
                lo = new ListObject();
                lo.setName(results[i].getName());
                lo.setCategory(results[i].getCategory());
                if (results[i].getLastModified() > 0L) {
                    lo.setDateObj(new Date(results[i].getLastModified()));
                }
                lo.setImageURL(results[i].getImgURL());
                ret.add(lo);
            }
        }
        return ret;
    }

    public Vector getQueryList(String table) {
        NamedObject[] queries = QueryManager.getInstance().getAvailableObjects();
        Vector<ListObject> ret = new Vector<ListObject>(queries.length);
        ListObject lo = null;
        for (int i = 0; i < queries.length; ++i) {
            lo = new ListObject();
            lo.setName(queries[i].getName());
            lo.setType(queries[i].getType());
            SGELog.fine("query {0}, type is {1}", (Object)queries[i].getName(), (Object)queries[i].getType());
            lo.setImageURL(queries[i].getImgURL());
            if (queries[i].getLastModified() > 0L) {
                lo.setDateObj(new Date(queries[i].getLastModified()));
            }
            lo.setCategory(queries[i].getCategory());
            lo.setType(queries[i].getType());
            ret.add(lo);
        }
        return ret;
    }

    public List getFieldList(String table) throws SQLException {
        return this.dbConnectionPool.getFieldList(table);
    }

    public SQLTableModel getResult() {
        return this.sqlTM;
    }

    public void executeQuery(com.sun.grid.reporting.model.Query query) throws SQLException {
        SQLGenerator sqlGenerator = this.dbConnectionPool.getSQLGenerator();
        this.calculateFieldTypes(query, sqlGenerator);
        SGELog.fine("query is {0}", query);
        this.executeQuery(query.getSQL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(String sql) throws SQLException {
        ArcoDbConnection con = this.dbConnectionPool.getConnection(this.applicationUser);
        try {
            this.sqlTM = new SQLTableModel(con.executeSQL(sql));
        }
        finally {
            this.dbConnectionPool.releaseConnection(this.applicationUser, con);
        }
    }

    public void saveQuery(com.sun.grid.reporting.model.Query query) {
        try {
            Query xmlQuery = QueryConverter.queryToXml(query);
            if (!QueryManager.getInstance().validateQuery(xmlQuery)) {
                throw new IllegalStateException("invalid query");
            }
            QueryManager.getInstance().saveQuery(xmlQuery);
        }
        catch (IllegalStateException ilse) {
            SGELog.severe((Throwable)ilse, "Save query failed: {0}", (Object)ilse.getMessage());
            throw ilse;
        }
    }

    public com.sun.grid.reporting.model.Query loadQuery(String queryName) {
        SGELog.fine("load query {0}", (Object)queryName);
        Query xmlQuery = QueryManager.getInstance().getQueryByName(queryName);
        if (xmlQuery != null) {
            return QueryConverter.xmlToQuery(xmlQuery, this.getDbConnectionPool().getSQLGenerator());
        }
        return null;
    }

    public Result loadResult(String resultName) {
        com.sun.grid.arco.model.Result xmlResult = ResultManager.getInstance().getResultByName(resultName);
        if (xmlResult != null) {
            return ResultConverter.fromXML(xmlResult);
        }
        return null;
    }

    public void saveResult(Result result) {
        com.sun.grid.arco.model.Result xmlResult = ResultConverter.toXML(result);
        if (ResultManager.getInstance().validateResult(xmlResult)) {
            ResultManager.getInstance().saveResult(xmlResult);
        }
    }

    public void removeQuery(String name) {
        QueryManager.getInstance().remove(name);
    }

    public void removeResult(String name) {
        ResultManager.getInstance().remove(name);
    }

    private void calculateFieldTypes(com.sun.grid.reporting.model.Query q, SQLGenerator gen) throws SQLException {
        if (q.isAdvancedQuery()) {
            return;
        }
        Vector<QueryField> fields = new Vector<QueryField>();
        String table = q.getBaseTable();
        Iterator findIt = q.getFieldManager().fields();
        while (findIt.hasNext()) {
            QueryField qf = (QueryField)findIt.next();
            if (!qf.getAggregateFunction().isTypeTestNeeded()) continue;
            fields.add(qf);
        }
        if (fields.size() == 0) {
            return;
        }
        String sql = gen.generateQuery2getFieldTypes(table, fields);
        this.executeQuery(sql);
        Iterator setIt = this.sqlTM.getFieldTypes().iterator();
        findIt = fields.iterator();
        while (findIt.hasNext() && setIt.hasNext()) {
            QueryField qf = (QueryField)findIt.next();
            int fieldType = (Integer)setIt.next();
            qf.setFieldType(fieldType);
            System.out.println(qf);
        }
    }

    public String exportCSV(Result result, String sesionId) {
        String name = result.getProperties().getName();
        name = name + "-";
        name = name + sesionId;
        try {
            ResultExportControl action = new ResultExportControl(501, name, result);
            action.run();
            return action.getOutFileName();
        }
        catch (IOException ioEx) {
            return ioEx.getMessage();
        }
    }
}

