/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

import com.sun.grid.arco.model.DatabaseType;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.model.AdvancedQuery;
import com.sun.grid.reporting.model.Query;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFieldManager;
import com.sun.grid.reporting.model.QueryFilter;
import com.sun.grid.reporting.model.QuerySortPair;
import com.sun.grid.reporting.model.SimpleQuery;
import com.sun.grid.reporting.sql.SQLCommand;
import com.sun.grid.reporting.sql.SQLGenerator;
import com.sun.grid.reporting.util.CryptoHandler;
import com.sun.grid.reporting.util.FieldFunction;
import com.sun.grid.reporting.util.FilterType;
import com.sun.grid.reporting.util.LogicalConnection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;

public class OracleSQLGenerator
implements SQLGenerator {
    public String findData(String id, String table, String column, String value) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getOracleName() + " ");
        sql.append(id);
        sql.append(" " + SQLCommand.FROM.getOracleName() + " ");
        sql.append(table);
        sql.append(" " + SQLCommand.WHERE.getOracleName() + " ");
        sql.append(column);
        if (value == null) {
            sql.append(" " + FilterType.NULL.getSymbol());
        } else {
            sql.append("='" + value + "'");
        }
        sql.append(";");
        return sql.toString();
    }

    public String generateLoad(String table, String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getOracleName() + " * ");
        sql.append(" " + SQLCommand.FROM.getOracleName() + " ");
        sql.append(table);
        if (filter != null) {
            sql.append(" " + filter);
        }
        sql.append(";");
        return sql.toString();
    }

    public String generateQuery2getFieldTypes(String table, Vector qfs) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getOracleName());
        sql.append(" ");
        Iterator listIt = qfs.iterator();
        while (listIt.hasNext()) {
            sql.append(((QueryField)listIt.next()).getDbFieldName());
            if (!listIt.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(" ");
        sql.append(" ").append(SQLCommand.FROM.getOracleName()).append(" ");
        sql.append(table);
        sql.append(" ").append(SQLCommand.LIMIT.getOracleName()).append(" 1;");
        return sql.toString();
    }

    private String getFieldName(QueryField qf) {
        String name = qf.getName();
        if (name == null) {
            name = qf.generateName();
        }
        return "\"" + name + "\"";
    }

    public String generateQuerySQL(Query model) {
        StringBuffer sql = new StringBuffer();
        if (model instanceof AdvancedQuery) {
            sql.append(model.getSQL());
        } else if (model instanceof SimpleQuery) {
            SimpleQuery sq = (SimpleQuery)model;
            StringBuffer select = new StringBuffer();
            StringBuffer from = new StringBuffer();
            StringBuffer where = new StringBuffer();
            StringBuffer group = new StringBuffer();
            StringBuffer order = new StringBuffer();
            StringBuffer limit = new StringBuffer();
            select.append(SQLCommand.SELECT.getOracleName() + " ");
            boolean hasAggregateFunction = false;
            String groupByValues = null;
            Iterator fields = sq.getFieldManager().fields();
            QueryField qf = null;
            FieldFunction fieldFunction = null;
            while (fields.hasNext()) {
                qf = (QueryField)fields.next();
                if (qf.getAggregateFunction().equals(FieldFunction.VALUE)) {
                    select.append(qf.getDbFieldName());
                } else {
                    fieldFunction = qf.getAggregateFunction();
                    boolean bl = hasAggregateFunction = hasAggregateFunction || fieldFunction.isAggreagate();
                    if (fieldFunction.equals(FieldFunction.ADDITION) || fieldFunction.equals(FieldFunction.SUBSTRACTION) || fieldFunction.equals(FieldFunction.DIVISION) || fieldFunction.equals(FieldFunction.MULIPLY)) {
                        select.append(qf.generateName());
                    } else {
                        select.append(qf.getAggregateFunction().getName());
                        select.append("(");
                        select.append(qf.getDbFieldName());
                        if (qf.getAggregateFunction().getParameterCount() > 1) {
                            select.append(qf.getAdditionalParameter());
                        }
                        select.append(")");
                    }
                }
                if (qf.getAggregateFunction() == FieldFunction.VALUE) {
                    if (groupByValues != null) {
                        groupByValues = groupByValues + ",";
                        groupByValues = groupByValues + qf.getDbFieldName();
                    } else {
                        groupByValues = qf.getDbFieldName();
                    }
                }
                select.append(' ');
                select.append(SQLCommand.AS.getOracleName());
                select.append(' ');
                select.append(this.getFieldName(qf));
                if (!fields.hasNext()) continue;
                select.append(",");
            }
            from.append(SQLCommand.FROM.getOracleName());
            from.append(' ');
            from.append(sq.getBaseTable());
            if (hasAggregateFunction && groupByValues != null) {
                group.append(SQLCommand.GROUP_BY.getOracleName());
                group.append(" ");
                group.append(groupByValues);
            }
            if (sq.getFilterManager().hasActiveFilter()) {
                where.append(SQLCommand.WHERE.getOracleName() + " ");
                Iterator it = sq.getFilterManager().getActiveFilters();
                boolean firstIsSet = false;
                QueryFilter queryFilter = null;
                while (it.hasNext()) {
                    queryFilter = (QueryFilter)it.next();
                    if (queryFilter.getLogicalConnection() != null && firstIsSet) {
                        where.append(' ');
                        where.append(queryFilter.getLogicalConnection().getSymbol());
                        where.append(' ');
                    }
                    where.append(this.getFieldName(queryFilter.getField()));
                    FilterType ft = queryFilter.getFilterType();
                    where.append(ft.getSymbol() + " ");
                    if (ft.getParameterCount() != 0 && queryFilter.getParameter() != null) {
                        if (ft == FilterType.IN) {
                            where.append('(');
                            where.append(queryFilter.getParameter());
                            where.append(')');
                        } else if (ft == FilterType.BETWEEN) {
                            where.append(queryFilter.getParameter());
                        } else {
                            where.append('\'');
                            where.append(queryFilter.getParameter());
                            where.append('\'');
                        }
                    }
                    if (firstIsSet) continue;
                    firstIsSet = true;
                }
            }
            if (sq.getSort() != null) {
                order.append(SQLCommand.ORDER_BY.getOracleName());
                QuerySortPair sqp = sq.getSort();
                if (sqp.getField().getName() != null) {
                    order.append(" \"" + sqp.getField().getName() + "\" " + sqp.getDirection().getName());
                } else {
                    order.append(" \"" + sqp.getField().generateName() + "\" " + sqp.getDirection().getName());
                }
            }
            if (sq.getRowLimit() > 0) {
                if (where.length() == 0) {
                    where.append(SQLCommand.WHERE.getOracleName());
                    where.append(" ");
                } else {
                    where.append(" and ");
                }
                where.append("ROWNUM <= ");
                where.append(sq.getRowLimit());
            }
            sql.append(select);
            sql.append(' ');
            sql.append(from);
            sql.append(' ');
            sql.append(group);
            if (sq.getFilterManager().hasActiveFilter()) {
                String subSelect = sql.toString();
                sql.setLength(0);
                sql.append(this.generateVisibleFields(sq.getFieldManager()));
                sql.append(SQLCommand.FROM.getOracleName());
                sql.append("(");
                sql.append(subSelect);
                sql.append(") ");
                sql.append(where);
            }
            if (sq.getSort() != null) {
                sql.append(" ");
                sql.append(order);
            }
        }
        String ret = sql.toString();
        SGELog.fine("ret = ", (Object)ret);
        return ret;
    }

    protected String generateVisibleFields(QueryFieldManager qfm) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getOracleName() + " ");
        Iterator listIt = qfm.fields();
        while (listIt.hasNext()) {
            QueryField qf = (QueryField)listIt.next();
            String value = qf.getName();
            if (value == null) {
                value = qf.generateName();
            }
            sql.append("\"" + value + "\"");
            if (listIt.hasNext()) {
                sql.append(", ");
                continue;
            }
            sql.append(" ");
        }
        return sql.toString();
    }

    public String generateRemove(String name, String table) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.DROP.getOracleName() + " " + name);
        sql.append(" " + SQLCommand.FROM.getOracleName() + " " + table + ";");
        return sql.toString();
    }

    public String generateSave(String table, Vector columns, Vector values) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.INSERT.getOracleName() + " ");
        sql.append(table);
        if (columns != null && columns.size() > 0) {
            sql.append(" (");
            Iterator colIt = columns.iterator();
            while (colIt.hasNext()) {
                String name = colIt.next().toString();
                sql.append(name);
                if (!colIt.hasNext()) continue;
                sql.append(",");
            }
            sql.append(")");
        }
        sql.append(SQLCommand.VALUES.getOracleName() + " (");
        Iterator valueIt = values.iterator();
        while (valueIt.hasNext()) {
            Object o = valueIt.next();
            sql.append(o == null ? null : "'" + o.toString() + "'");
            if (!valueIt.hasNext()) continue;
            sql.append(",");
        }
        sql.append(");");
        return sql.toString();
    }

    public String generateUpdate(String table, Vector columns, Vector values, String id_column, String id_value) {
        if (columns.size() != values.size()) {
            throw new IllegalArgumentException("The columns and values to be updates do not match.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.UPDATE.getOracleName() + "  ");
        sql.append(table);
        sql.append(" " + SQLCommand.SET.getOracleName() + " ");
        Iterator colIt = columns.iterator();
        Iterator valIt = values.iterator();
        while (colIt.hasNext() && valIt.hasNext()) {
            String column = colIt.next().toString();
            Object o = valIt.next();
            String value = o == null ? "null" : o.toString();
            sql.append(column + "='" + value + "'");
            if (!colIt.hasNext() || !valIt.hasNext()) continue;
            sql.append(",");
        }
        sql.append(" " + SQLCommand.WHERE.getOracleName() + " ");
        sql.append(id_column + "='" + id_value + "';");
        return sql.toString();
    }

    public String generateQuery2getAttributes(String table) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getOracleName()).append(" * ");
        sql.append(SQLCommand.FROM.getOracleName()).append(" ").append(table).append(" ");
        sql.append(SQLCommand.LIMIT.getOracleName()).append(" 1;");
        return sql.toString();
    }

    public String generateQuery2getQueryList() {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getOracleName());
        sql.append(" query_name,qt_type,images_url,query_date,query_category ");
        sql.append(SQLCommand.FROM.getOracleName());
        sql.append(" queries, images, querytypes ");
        sql.append(SQLCommand.WHERE.getOracleName());
        sql.append(" queries.images_id = images.images_id ");
        sql.append(LogicalConnection.AND.getSymbol());
        sql.append(" queries.qt_id = querytypes.qt_id;");
        return sql.toString();
    }

    public String generateQuery2getResultList() {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getOracleName());
        sql.append(" result_name,images_url,result_date,result_category ");
        sql.append(SQLCommand.FROM.getOracleName());
        sql.append(" result, images ");
        sql.append(SQLCommand.WHERE.getOracleName());
        sql.append(" queries.images_id = images.images_id ");
        return sql.toString();
    }

    public String generateTestConnectionQuery() {
        return "SELECT SYSDATE FROM DUAL";
    }

    public ConnectionPoolDataSource createDatasource(DatabaseType database) throws SQLException {
        OracleConnectionPoolDataSource oracleDS = new OracleConnectionPoolDataSource();
        String pw = CryptoHandler.decrypt(database.getUser().getPasswd());
        oracleDS.setDatabaseName(database.getName());
        oracleDS.setDriverType("thin");
        oracleDS.setPassword(pw);
        oracleDS.setPortNumber(database.getPort());
        oracleDS.setServerName(database.getHost());
        oracleDS.setUser(database.getUser().getName());
        oracleDS.setNetworkProtocol("tcp");
        return oracleDS;
    }
}

