/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

import com.sun.grid.arco.model.DatabaseType;
import com.sun.grid.reporting.model.AdvancedQuery;
import com.sun.grid.reporting.model.Query;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFieldManager;
import com.sun.grid.reporting.model.QueryFilter;
import com.sun.grid.reporting.model.QuerySortPair;
import com.sun.grid.reporting.model.SimpleQuery;
import com.sun.grid.reporting.sql.SQLCommand;
import com.sun.grid.reporting.sql.SQLGenerator;
import com.sun.grid.reporting.util.FieldFunction;
import com.sun.grid.reporting.util.FilterType;
import com.sun.grid.reporting.util.LogicalConnection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;

public class MySQLGenerator
implements SQLGenerator {
    public String findData(String id, String table, String column, String value) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getMySQLName() + " ");
        sql.append(id);
        sql.append(" " + SQLCommand.FROM.getMySQLName() + " ");
        sql.append(table);
        sql.append(" " + SQLCommand.WHERE.getMySQLName() + " ");
        sql.append(column);
        if (value == null) {
            sql.append(" " + FilterType.NULL.getSymbol());
        } else {
            sql.append("='" + value + "'");
        }
        sql.append(";");
        return sql.toString();
    }

    public String generateLoad(String table, String filter) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getMySQLName() + " * ");
        sql.append(" " + SQLCommand.FROM.getMySQLName() + " ");
        sql.append(table);
        if (filter != null) {
            sql.append(" " + filter);
        }
        sql.append(";");
        return sql.toString();
    }

    public String generateQuery2getFieldTypes(String table, Vector qfs) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getMySQLName());
        sql.append(" ");
        Iterator listIt = qfs.iterator();
        while (listIt.hasNext()) {
            sql.append(((QueryField)listIt.next()).getDbFieldName());
            if (!listIt.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(" ");
        sql.append(" ").append(SQLCommand.FROM.getMySQLName()).append(" ");
        sql.append(table);
        sql.append(" ").append(SQLCommand.LIMIT.getMySQLName()).append(" 1;");
        return sql.toString();
    }

    public String generateQuerySQL(Query model) {
        StringBuffer sql = new StringBuffer();
        if (model instanceof AdvancedQuery) {
            sql = new StringBuffer(model.getSQL());
        } else if (model instanceof SimpleQuery) {
            SimpleQuery sq = (SimpleQuery)model;
            StringBuffer select = new StringBuffer();
            StringBuffer from = new StringBuffer();
            StringBuffer where = new StringBuffer();
            StringBuffer group = new StringBuffer();
            StringBuffer order = new StringBuffer();
            StringBuffer limit = new StringBuffer();
            select.append(SQLCommand.SELECT.getMySQLName() + " ");
            boolean hasAggregateFunction = false;
            String groupByValues = null;
            Iterator fields = sq.getFieldManager().fields();
            while (fields.hasNext()) {
                QueryField qf = (QueryField)fields.next();
                if (qf.getAggregateFunction().equals(FieldFunction.VALUE)) {
                    select.append(qf.getDbFieldName());
                } else {
                    FieldFunction fieldFunction = qf.getAggregateFunction();
                    boolean bl = hasAggregateFunction = hasAggregateFunction || fieldFunction.isAggreagate();
                    if (fieldFunction.equals(FieldFunction.ADDITION) || fieldFunction.equals(FieldFunction.SUBSTRACTION) || fieldFunction.equals(FieldFunction.DIVISION) || fieldFunction.equals(FieldFunction.MULIPLY)) {
                        select.append(qf.generateName());
                    } else {
                        select.append(qf.getAggregateFunction().getName() + "(" + qf.getDbFieldName());
                        if (qf.getAggregateFunction().getParameterCount() > 1) {
                            select.append(qf.getAdditionalParameter());
                        }
                        select.append(")");
                    }
                }
                if (qf.getAggregateFunction() == FieldFunction.VALUE) {
                    if (groupByValues != null) {
                        groupByValues = groupByValues + ",";
                        groupByValues = groupByValues + qf.getDbFieldName();
                    } else {
                        groupByValues = qf.getDbFieldName();
                    }
                }
                if (qf.getAggregateFunction().isTypeTestNeeded() && qf.getFieldType() == 93) {
                    select.append("::time");
                }
                select.append(" " + SQLCommand.AS.getMySQLName() + " \"" + qf.getName(true) + "\"");
                select.append(",");
            }
            select = select.deleteCharAt(select.lastIndexOf(","));
            from.append(SQLCommand.FROM.getMySQLName());
            from.append(" " + sq.getBaseTable());
            if (hasAggregateFunction && groupByValues != null) {
                group.append(SQLCommand.GROUP_BY.getMySQLName());
                group.append(" ");
                group.append(groupByValues);
            }
            if (sq.getFilterManager().hasActiveFilter()) {
                where.append(SQLCommand.WHERE.getMySQLName() + " ");
                Iterator it = sq.getFilterManager().getActiveFilters();
                boolean firstIsSet = false;
                while (it.hasNext()) {
                    QueryFilter qf = (QueryFilter)it.next();
                    if (qf.getLogicalConnection() != null && firstIsSet) {
                        where.append(" " + qf.getLogicalConnection().getSymbol() + " ");
                    }
                    where.append("\"" + qf.getField().getName(true) + "\" ");
                    FilterType ft = qf.getFilterType();
                    where.append(ft.getSymbol() + " ");
                    if (ft.getParameterCount() != 0 && qf.getParameter() != null) {
                        if (ft == FilterType.IN) {
                            where.append("(" + qf.getParameter() + ")");
                        } else if (ft == FilterType.BETWEEN) {
                            where.append(qf.getParameter());
                        } else {
                            where.append("'" + qf.getParameter() + "'");
                        }
                    }
                    if (firstIsSet) continue;
                    firstIsSet = true;
                }
            }
            if (sq.getSort() != null) {
                order.append(SQLCommand.ORDER_BY.getMySQLName());
                QuerySortPair sqp = sq.getSort();
                if (sqp.getField().getName() != null) {
                    order.append(" \"" + sqp.getField().getName() + "\" " + sqp.getDirection().getName());
                } else {
                    order.append(" \"" + sqp.getField().generateName() + "\" " + sqp.getDirection().getName());
                }
            }
            if (sq.getRowLimit() > 0) {
                limit.append(SQLCommand.LIMIT.getMySQLName());
                limit.append(" " + Integer.toString(sq.getRowLimit()));
            }
            sql.append(select + " " + from + " " + group);
            if (sq.getFilterManager().hasActiveFilter()) {
                StringBuffer subSelect = new StringBuffer(sql.toString());
                sql = new StringBuffer();
                sql.append(this.generateVisibleFields(sq.getFieldManager()));
                sql.append(SQLCommand.FROM.getMySQLName() + "(");
                sql.append(subSelect + ") " + SQLCommand.AS.getMySQLName() + " tmp ");
                sql.append(where);
            }
            if (sq.getSort() != null) {
                sql.append(" " + order);
            }
            if (sq.getRowLimit() > 0) {
                sql.append(" " + limit);
            }
            sql.append(";");
        }
        return sql.toString();
    }

    protected String generateVisibleFields(QueryFieldManager qfm) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getMySQLName() + " ");
        Iterator listIt = qfm.fields();
        while (listIt.hasNext()) {
            QueryField qf = (QueryField)listIt.next();
            String value = qf.getName(true);
            sql.append("\"" + value + "\"");
            if (listIt.hasNext()) {
                sql.append(", ");
                continue;
            }
            sql.append(" ");
        }
        return sql.toString();
    }

    public String generateRemove(String name, String table) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.DROP.getMySQLName() + " " + name);
        sql.append(" " + SQLCommand.FROM.getMySQLName() + " " + table + ";");
        return sql.toString();
    }

    public String generateSave(String table, Vector columns, Vector values) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.INSERT.getMySQLName() + " ");
        sql.append(table);
        if (columns != null && columns.size() > 0) {
            sql.append(" (");
            Iterator colIt = columns.iterator();
            while (colIt.hasNext()) {
                String name = colIt.next().toString();
                sql.append(name);
                if (!colIt.hasNext()) continue;
                sql.append(",");
            }
            sql.append(")");
        }
        sql.append(SQLCommand.VALUES.getMySQLName() + " (");
        Iterator valueIt = values.iterator();
        while (valueIt.hasNext()) {
            Object o = valueIt.next();
            sql.append(o == null ? null : "'" + o.toString() + "'");
            if (!valueIt.hasNext()) continue;
            sql.append(",");
        }
        sql.append(");");
        return sql.toString();
    }

    public String generateUpdate(String table, Vector columns, Vector values, String id_column, String id_value) {
        if (columns.size() != values.size()) {
            throw new IllegalArgumentException("The columns and values to be updates do not match.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.UPDATE.getMySQLName() + "  ");
        sql.append(table);
        sql.append(" " + SQLCommand.SET.getMySQLName() + " ");
        Iterator colIt = columns.iterator();
        Iterator valIt = values.iterator();
        while (colIt.hasNext() && valIt.hasNext()) {
            String column = colIt.next().toString();
            Object o = valIt.next();
            String value = o == null ? "null" : o.toString();
            sql.append(column + "='" + value + "'");
            if (!colIt.hasNext() || !valIt.hasNext()) continue;
            sql.append(",");
        }
        sql.append(" " + SQLCommand.WHERE.getMySQLName() + " ");
        sql.append(id_column + "='" + id_value + "';");
        return sql.toString();
    }

    public String generateQuery2getAttributes(String table) {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getMySQLName()).append(" * ");
        sql.append(SQLCommand.FROM.getMySQLName()).append(" ").append(table).append(" ");
        sql.append(SQLCommand.LIMIT.getMySQLName()).append(" 1;");
        return sql.toString();
    }

    public String generateQuery2getQueryList() {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getMySQLName());
        sql.append(" query_name,qt_type,images_url,query_date,query_category ");
        sql.append(SQLCommand.FROM.getMySQLName());
        sql.append(" queries, images, querytypes ");
        sql.append(SQLCommand.WHERE.getMySQLName());
        sql.append(" queries.images_id = images.images_id ");
        sql.append(LogicalConnection.AND.getSymbol());
        sql.append(" queries.qt_id = querytypes.qt_id;");
        return sql.toString();
    }

    public String generateQuery2getResultList() {
        StringBuffer sql = new StringBuffer();
        sql.append(SQLCommand.SELECT.getMySQLName());
        sql.append(" result_name,images_url,result_date,result_category ");
        sql.append(SQLCommand.FROM.getMySQLName());
        sql.append(" result, images ");
        sql.append(SQLCommand.WHERE.getMySQLName());
        sql.append(" queries.images_id = images.images_id ");
        return sql.toString();
    }

    public String generateTestConnectionQuery() {
        throw new IllegalStateException("Not yet implemented");
    }

    public ConnectionPoolDataSource createDatasource(DatabaseType database) throws SQLException {
        throw new IllegalStateException("Not yet implemented");
    }
}

