/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

import com.sun.grid.arco.model.Configuration;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.sql.ArcoDBConstants;
import com.sun.grid.reporting.sql.ArcoDbConnection;
import com.sun.grid.reporting.sql.MySQLGenerator;
import com.sun.grid.reporting.sql.OracleSQLGenerator;
import com.sun.grid.reporting.sql.PostgreSQLGenerator;
import com.sun.grid.reporting.sql.SQLGenerator;
import com.sun.grid.reporting.sql.UnsupportedDbAccess;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.sql.ConnectionPoolDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ArcoDbConnectionPool
implements ArcoDBConstants {
    private ArrayList connections = new ArrayList();
    private Stack freeConnections = new Stack();
    private ConnectionPoolDataSource datasource;
    private static ArcoDbConnectionPool instance = null;
    private Configuration config = null;
    private File configFile;
    private SQLGenerator generator;
    private ArrayList viewList;
    private Map tableFieldListMap = new HashMap();
    static /* synthetic */ Class class$com$sun$grid$reporting$sql$ArcoDbConnectionPool;

    private ArcoDbConnectionPool() {
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfigurationFile(String configFile) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.sun.grid.arco.model");
            Unmarshaller um = jc.createUnmarshaller();
            File f = new File(configFile);
            this.config = (Configuration)um.unmarshal(f);
            this.configFile = f;
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("Can't read configuration file " + configFile);
            ilse.initCause(jaxbe);
            throw ilse;
        }
    }

    public File getConfigrationFile() {
        return this.configFile;
    }

    public SQLGenerator getSQLGenerator() {
        if (this.generator == null) {
            String type = this.config.getDatabase().getDriver().getType();
            this.generator = ArcoDbConnectionPool.getSQLGenerator(type);
        }
        return this.generator;
    }

    public static SQLGenerator getSQLGenerator(String type) {
        if (type.equals("mysql")) {
            return new MySQLGenerator();
        }
        if (type.equals("postgresql")) {
            return new PostgreSQLGenerator();
        }
        if (type.equals("oracle")) {
            return new OracleSQLGenerator();
        }
        throw new IllegalStateException("No Generator found for database type " + type + "found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SQLException {
        if (this.datasource == null) {
            ArrayList arrayList = this.connections;
            synchronized (arrayList) {
                if (this.datasource == null) {
                    this.datasource = this.getSQLGenerator().createDatasource(this.config.getDatabase());
                    ArcoDbConnection conn = null;
                    int max = this.config.getDatabase().getUser().getMaxConnections();
                    for (int i = 0; i < max; ++i) {
                        conn = new ArcoDbConnection(i, this.config.getDatabase().getDriver().getType(), this.config.getDatabase().getSchema(), this.datasource);
                        this.freeConnections.push(conn);
                    }
                    this.connections.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArcoDbConnectionPool getInstance() {
        if (instance == null) {
            Class clazz = class$com$sun$grid$reporting$sql$ArcoDbConnectionPool == null ? (class$com$sun$grid$reporting$sql$ArcoDbConnectionPool = ArcoDbConnectionPool.class$("com.sun.grid.reporting.sql.ArcoDbConnectionPool")) : class$com$sun$grid$reporting$sql$ArcoDbConnectionPool;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new ArcoDbConnectionPool();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArcoDbConnection getConnection(String appUser) throws UnsupportedDbAccess {
        try {
            this.init();
            ArcoDbConnection ret = null;
            ArrayList arrayList = this.connections;
            synchronized (arrayList) {
                while (this.freeConnections.isEmpty()) {
                    SGELog.warning("No db connection free, wait");
                    this.connections.wait();
                }
                ret = (ArcoDbConnection)this.freeConnections.pop();
                this.connections.add(ret);
            }
            SGELog.fine("Got connection {0}", ret.getId());
            return ret;
        }
        catch (SQLException sqle) {
            UnsupportedDbAccess e = new UnsupportedDbAccess("Can't create datasource ");
            e.initCause(sqle);
            throw e;
        }
        catch (InterruptedException ire) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(String appUser, ArcoDbConnection connection) {
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            connection.closeConnection();
            this.connections.remove(connection);
            SGELog.fine("Connection {0} released", connection.getId());
            this.freeConnections.push(connection);
            this.connections.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnections() {
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            ArcoDbConnection conn = null;
            while (!this.connections.isEmpty()) {
                conn = (ArcoDbConnection)this.connections.get(0);
                this.releaseConnection(null, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getViewList() throws SQLException {
        if (this.viewList == null) {
            ArcoDbConnection conn = this.getConnection(null);
            try {
                ResultSet rs = conn.getViewList();
                ArrayList<String> tmpViewList = new ArrayList<String>();
                while (rs.next()) {
                    tmpViewList.add(rs.getString(3));
                }
                this.viewList = tmpViewList;
            }
            finally {
                this.releaseConnection(null, conn);
            }
        }
        return this.viewList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFieldList(String table) throws SQLException {
        ArrayList<String> ret = (ArrayList<String>)this.tableFieldListMap.get(table);
        if (ret == null) {
            ArcoDbConnection conn = this.getConnection(null);
            try {
                ResultSet rs = conn.getAttributes(table);
                ret = new ArrayList<String>();
                while (rs.next()) {
                    ret.add(rs.getString(4));
                }
                Collections.sort(ret);
                Map map = this.tableFieldListMap;
                synchronized (map) {
                    this.tableFieldListMap.put(table, ret);
                }
            }
            finally {
                this.releaseConnection(null, conn);
            }
        }
        return Collections.unmodifiableList(ret);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

