/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.sql;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.sql.ArcoDBConstants;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;

public class ArcoDbConnection
implements ArcoDBConstants {
    private static final int TRY_OPEN_RESET = 0;
    private String dbType;
    private String schema;
    private ConnectionPoolDataSource datasource;
    private Connection connection;
    private Statement activeQuery;
    private ResultSet resultSet;
    private String testSQL;
    private static Vector instanceCache = new Vector();
    private int tryOpen_count = 0;
    private Integer id;

    public ArcoDbConnection(int id, String dbType, String schema, ConnectionPoolDataSource ds) {
        this.id = new Integer(id);
        this.dbType = dbType;
        this.schema = schema;
        this.datasource = ds;
    }

    public Integer getId() {
        return this.id;
    }

    public void openConnection() throws IllegalStateException, SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            throw new IllegalStateException("Database already connected");
        }
        this.connection = this.datasource.getPooledConnection().getConnection();
        this.activeQuery = this.connection.createStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeConnection() {
        try {
            try {
                block9: {
                    block8: {
                        if (this.connection == null) break block8;
                        if (!this.connection.isClosed()) break block9;
                    }
                    Object var3_1 = null;
                    this.activeQuery = null;
                    this.connection = null;
                    this.resultSet = null;
                    return;
                }
                this.activeQuery.close();
                this.connection.close();
            }
            catch (SQLException sqlEx) {
                SGELog.warning((Throwable)sqlEx, "Close error {0}", (Object)sqlEx);
                Object var3_3 = null;
                this.activeQuery = null;
                this.connection = null;
                this.resultSet = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.activeQuery = null;
            this.connection = null;
            this.resultSet = null;
            throw throwable;
        }
        Object var3_2 = null;
        this.activeQuery = null;
        this.connection = null;
        this.resultSet = null;
    }

    public ResultSet executeSQL(String sql) throws SQLException {
        try {
            if (sql == null) {
                throw new IllegalArgumentException("sql must not be null");
            }
            SGELog.fine("SQL-Statement to be executed = {0}", (Object)sql);
            this.checkConnection();
            if (this.activeQuery.execute(sql)) {
                this.resultSet = this.activeQuery.getResultSet();
            }
        }
        catch (NullPointerException npEx) {
            SGELog.severe(npEx, "NullPointerException");
        }
        catch (OutOfMemoryError oomErr) {
            this.closeConnection();
            this.openConnection();
            throw oomErr;
        }
        return this.resultSet;
    }

    public boolean isConnectionClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public String getActiveQuery() {
        return this.activeQuery.toString();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDbType() {
        return this.dbType;
    }

    public ResultSet getAttributes(String table) throws SQLException {
        ResultSet retVal = null;
        this.checkConnection();
        DatabaseMetaData metaData = this.connection.getMetaData();
        String mySchema = null;
        if (this.schema != null && this.schema.length() > 0) {
            mySchema = this.schema;
        }
        if (this.dbType.equals("oracle")) {
            table = table.toUpperCase();
            if (mySchema != null) {
                mySchema = mySchema.toUpperCase();
            }
        }
        retVal = metaData.getColumns(null, mySchema, table, null);
        return retVal;
    }

    public ResultSet getViewList() throws SQLException {
        ResultSet retVal = null;
        this.checkConnection();
        DatabaseMetaData meta = this.connection.getMetaData();
        String mySchema = null;
        if (this.schema != null && this.schema.length() > 0) {
            mySchema = this.schema;
        }
        if (this.dbType.equals("oracle") && mySchema != null) {
            mySchema = mySchema.toUpperCase();
        }
        retVal = meta.getTables(null, mySchema, null, new String[]{"VIEW", "TABLE", "SYNONYM"});
        return retVal;
    }

    private void checkConnection() throws SQLException {
        if (this.connection == null) {
            this.openConnection();
        }
    }
}

