/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.reportingmodule;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.command.CommandException;
import com.iplanet.jato.util.WrapperRuntimeException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.grid.arco.QueryManager;
import com.sun.grid.arco.ResultManager;
import com.sun.grid.arco.model.StorageType;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.AcroServletBase;
import com.sun.grid.reporting.ArcoModelBean;
import com.sun.grid.reporting.reportingmodule.ErrorViewBean;
import com.sun.grid.reporting.sql.ArcoDbConnectionPool;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import org.omg.CORBA.portable.ApplicationException;

public class AcroServlet
extends AcroServletBase {
    private static final String DEFAULT_MODULE_URL = "../reportingmodule";
    private static final String PACKAGE_NAME = "com.sun.grid.reporting.reportingmodule";
    private HttpSession m_HttpSession = null;
    private HttpServletRequest m_HttpServletRequest = null;
    private ArcoModelBean m_ArcoModelBean = null;
    private static int counter = -1;
    private ArcoDbConnectionPool dbConnections;
    private boolean managersInitialized = false;
    private Object sync = new Object();
    static /* synthetic */ Class class$com$sun$grid$reporting$reportingmodule$ErrorViewBean;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.dbConnections = ArcoDbConnectionPool.getInstance();
        this.dbConnections.setConfigurationFile(this.getConfigFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initManagers() {
        if (!this.managersInitialized) {
            Object object = this.sync;
            synchronized (object) {
                if (!this.managersInitialized) {
                    try {
                        SGELog.fine("initialize the query and result manager");
                        ClassLoader cl = this.getClass().getClassLoader();
                        StorageType storage = this.dbConnections.getConfig().getStorage();
                        File storageDir = new File(storage.getRoot());
                        File queryDir = new File(storageDir, storage.getQueries());
                        File resultDir = new File(storageDir, storage.getResults());
                        QueryManager.createInstance(queryDir, cl);
                        ResultManager.createInstance(resultDir, cl);
                        this.managersInitialized = true;
                        SGELog.fine("the query and result manager successfully initialized");
                    }
                    catch (Exception e) {
                        SGELog.severe((Throwable)e, "Exception occured {0}", (Object)e);
                    }
                }
            }
        }
    }

    public void destroy() {
        this.dbConnections.releaseConnections();
        this.cleanUp();
    }

    private void cleanUp() {
        File directory = new File("/usr/share/webconsole/reporting/export/");
        ExtensionFilter filter = new ExtensionFilter(".pdf");
        String[] list = directory.list(filter);
        if (list.length == 0) {
            SGELog.fine("nothing to delete");
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            File file = new File(directory + list[i]);
            SGELog.fine("dummy_delete {0}", file);
        }
    }

    protected void initializeRequestContext(RequestContext requestContext) {
        super.initializeRequestContext(requestContext);
        SGELog.fine("initializeRequestContext");
        this.initManagers();
        ViewBeanManager vbm = new ViewBeanManager(requestContext, PACKAGE_NAME);
        ((RequestContextImpl)requestContext).setViewBeanManager(vbm);
        Date d = new Date();
        if (this.isNewSession(requestContext)) {
            SGELog.fine("newSession");
        }
        SGELog.fine("The instance of dbConnectionpool is {0}", this.dbConnections);
        this.m_HttpServletRequest = requestContext.getRequest();
        this.m_HttpSession = this.m_HttpServletRequest.getSession(false);
        this.m_ArcoModelBean = (ArcoModelBean)this.m_HttpSession.getAttribute("MODEL");
        if (null == this.m_ArcoModelBean) {
            ArcoModelBean tmp_ArcoModelBean = null;
            try {
                String tmp_UserName = this.getUserCredentials(this.m_HttpServletRequest);
                SGELog.fine("getApplicationUser={0}", (Object)tmp_UserName);
                if (SGELog.isLoggable(Level.FINE)) {
                    this.checkSettings(this.m_HttpServletRequest);
                }
                tmp_ArcoModelBean = new ArcoModelBean(tmp_UserName, this.dbConnections);
                tmp_ArcoModelBean.setCounterTest(++counter);
                tmp_ArcoModelBean.setServer(this.getServer(this.m_HttpServletRequest));
                tmp_ArcoModelBean.setPort(this.getPort(this.m_HttpServletRequest));
                tmp_ArcoModelBean.setScheme(this.getScheme(this.m_HttpServletRequest));
                tmp_ArcoModelBean.setSessionID(this.m_HttpSession.getId());
                tmp_ArcoModelBean.setRequestLocale(this.getRequestLocale(this.m_HttpServletRequest));
                SGELog.fine("The instance of dbConnectionpool is: {0}", this.dbConnections);
            }
            catch (ApplicationException aex) {
                SGELog.severe((Throwable)aex, "ApplicationException {0}", (Object)aex);
            }
            if (null != tmp_ArcoModelBean) {
                this.m_HttpSession.setAttribute("MODEL", tmp_ArcoModelBean);
                SGELog.fine("MODEL CREATED !");
            }
        } else {
            SGELog.fine("MODEL EXISTS !");
        }
    }

    private String getUserCredentials(HttpServletRequest m_HttpServletRequest) throws ApplicationException {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(m_HttpServletRequest);
            Subject subject = sSOToken.getSubject();
            Object userRolePrincipal = null;
            Iterator<Principal> it = subject.getPrincipals().iterator();
            if (it.hasNext()) {
                Principal principal = it.next();
                String s = principal.getName();
                SGELog.fine("username={0}", (Object)s);
                return s;
            }
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception occured: {0}", (Object)ex);
            return "MODEL:getUserCredentials():UNKNOWN user";
        }
        return "UNKNOWN";
    }

    public Locale getRequestLocale(HttpServletRequest m_HttpServletRequest) {
        return m_HttpServletRequest.getLocale();
    }

    public String getServer(HttpServletRequest m_HttpServletRequest) {
        return m_HttpServletRequest.getServerName();
    }

    public String getPort(HttpServletRequest m_HttpServletRequest) {
        String m_port = "-1";
        m_port = Integer.toString(m_HttpServletRequest.getServerPort());
        return m_port;
    }

    public String getScheme(HttpServletRequest m_HttpServletRequest) {
        return m_HttpServletRequest.getScheme();
    }

    public void checkSettings(HttpServletRequest m_HttpServletRequest) {
        if (SGELog.isLoggable(Level.FINE)) {
            String m_port = "-1";
            m_port = Integer.toString(m_HttpServletRequest.getServerPort());
            SGELog.fine("AuthType:{0}, PathInfo:{1}, RemoteUser:{2}, SessionId:{3}, local: {4}, server:{5} , scheme:{6}", (Object)m_HttpServletRequest.getAuthType(), (Object)m_HttpServletRequest.getPathInfo(), (Object)m_HttpServletRequest.getRemoteUser(), (Object)m_HttpServletRequest.getRequestedSessionId(), (Object)m_HttpServletRequest.getServerName(), (Object)m_HttpServletRequest.getScheme());
        }
    }

    public void onUncaughtException(RequestContext rc, Exception e) throws ServletException, IOException {
        Throwable t = e;
        while (true) {
            if (t instanceof WrapperRuntimeException) {
                t = ((WrapperRuntimeException)t).getException();
                continue;
            }
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t instanceof CommandException)) break;
            t = ((CommandException)t).getException();
        }
        SGELog.severe(t, "Encountered an internal exception: {0}", (Object)t);
        ErrorViewBean errorViewBean = (ErrorViewBean)rc.getViewBeanManager().getViewBean(class$com$sun$grid$reporting$reportingmodule$ErrorViewBean == null ? (class$com$sun$grid$reporting$reportingmodule$ErrorViewBean = AcroServlet.class$("com.sun.grid.reporting.reportingmodule.ErrorViewBean")) : class$com$sun$grid$reporting$reportingmodule$ErrorViewBean);
        SGELog.info("forward to {0}" + errorViewBean.getName());
        errorViewBean.setError(t);
        errorViewBean.forwardTo(rc);
    }

    protected void processRequest(String pageName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.processRequest(pageName, request, response);
        SGELog.fine("pageName={0}", (Object)pageName);
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        super.attributeAdded(event);
    }

    public String getServletInfo() {
        return "Accounting and Reporting Tool.";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ExtensionFilter
    implements FilenameFilter {
        private String extension;

        public ExtensionFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

