/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.model.DBTableViewConfiguration;
import com.sun.grid.reporting.model.GraphicalViewConfiguration;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.ViewConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.logging.Level;

public class ViewConfigurationManager
implements PropertyChangeListener,
Iterator {
    public static final String DEFAULTNAME4DEFAULTVC = "none";
    public static final int NO_CONFIGURATION = 0;
    public static final int DB_CONFIGURATION = 1;
    public static final int PIVOT_CONFIGURATION = 2;
    public static final int GRAPHICAL_CONFIGURATION = 3;
    private DBTableViewConfiguration dbTableVC;
    private GraphicalViewConfiguration graphicalVC;
    private PivotViewConfiguration pivotVC;
    ViewConfiguration[] visibleVCs = new ViewConfiguration[3];
    private boolean hideDescription = false;
    private boolean hideParameter = false;
    private boolean hideSQLStatement = false;
    private int visibleVCsIteratorPos = -1;
    private boolean dataChanged = false;
    private String address;

    public static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "DB_CONFIGURATION";
            }
            case 2: {
                return "PIVOT_CONFIGURATION";
            }
            case 3: {
                return "GRAPHICAL_CONFIGURATION";
            }
            case 0: {
                return "NO_CONFIGURATION";
            }
        }
        throw new IllegalArgumentException("type " + type + " is unknown");
    }

    /*
     * WARNING - void declaration
     */
    public void setViewConfiguration(ViewConfiguration vc, int type) {
        void var3_3;
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("this = {0}, vc = {1}, type = {2}", (Object)this.getAddress(), (Object)vc, (Object)ViewConfigurationManager.typeToString(type));
        }
        switch (type) {
            case 1: {
                ViewConfiguration oldValue;
                if (vc instanceof DBTableViewConfiguration || vc == null) {
                    oldValue = this.dbTableVC;
                    this.dbTableVC = (DBTableViewConfiguration)vc;
                    break;
                }
                throw new IllegalArgumentException("The specified ViewConfiguration must be an instance of  a DBTableViewConfiguration");
            }
            case 3: {
                ViewConfiguration oldValue;
                if (vc instanceof GraphicalViewConfiguration || vc == null) {
                    oldValue = this.graphicalVC;
                    this.graphicalVC = (GraphicalViewConfiguration)vc;
                    break;
                }
                throw new IllegalArgumentException("The specified ViewConfiguration must be an instance of  a GraphicalViewConfiguration");
            }
            case 2: {
                ViewConfiguration oldValue;
                if (vc instanceof PivotViewConfiguration || vc == null) {
                    oldValue = this.pivotVC;
                    this.pivotVC = (PivotViewConfiguration)vc;
                    break;
                }
                throw new IllegalArgumentException("The specified ViewConfiguration must be an instance of  a PivotViewConfiguration");
            }
            default: {
                throw new IllegalArgumentException("The type is not allowed.");
            }
        }
        if (var3_3 != vc) {
            this.dataChanged = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ViewConfiguration getViewConfiguration(int type) {
        void var2_2;
        switch (type) {
            case 1: {
                ViewConfiguration vc = this.dbTableVC;
                break;
            }
            case 3: {
                ViewConfiguration vc = this.graphicalVC;
                break;
            }
            case 2: {
                ViewConfiguration vc = this.pivotVC;
                break;
            }
            case 0: {
                ViewConfiguration vc = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("The type is not allowed.");
            }
        }
        return var2_2;
    }

    public void setVisibleViewconfiguration(int vc_type, int index) {
        if (index > 2) {
            throw new IndexOutOfBoundsException("There are only 3 viewconfigurations allowed!");
        }
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("this = {0}, vc_type = {1}, index = {2}", (Object)this.getAddress(), (Object)ViewConfigurationManager.typeToString(vc_type), (Object)new Integer(index));
        }
        switch (vc_type) {
            case 3: {
                this.visibleVCs[index] = this.graphicalVC;
                break;
            }
            case 0: {
                this.visibleVCs[index] = null;
                break;
            }
            case 1: {
                this.visibleVCs[index] = this.dbTableVC;
                break;
            }
            case 2: {
                this.visibleVCs[index] = this.pivotVC;
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified viewconfiguration is not allowed!");
            }
        }
    }

    public ViewConfiguration getViewConfigurationAt(int index) {
        return this.getViewConfiguration(this.getViewConfigurationTypeAt(index));
    }

    public int getViewConfigurationTypeAt(int index) {
        if (this.visibleVCs[index] instanceof GraphicalViewConfiguration) {
            return 3;
        }
        if (this.visibleVCs[index] instanceof PivotViewConfiguration) {
            return 2;
        }
        if (this.visibleVCs[index] instanceof DBTableViewConfiguration) {
            return 1;
        }
        return 0;
    }

    public String getAddress() {
        if (this.address == null) {
            this.address = super.toString().substring(this.getClass().getName().length());
        }
        return this.address;
    }

    public void resetVisibleViewconfigurations() {
        SGELog.fine("reset, this = {0}", (Object)this.getAddress());
        for (int i = 0; i < this.visibleVCs.length; ++i) {
            this.visibleVCs[i] = null;
        }
    }

    public int indexOf(int vc_type) {
        block5: for (int index = 0; index < this.visibleVCs.length; ++index) {
            switch (vc_type) {
                case 1: {
                    if (!(this.visibleVCs[index] instanceof DBTableViewConfiguration)) continue block5;
                    return index;
                }
                case 2: {
                    if (!(this.visibleVCs[index] instanceof PivotViewConfiguration)) continue block5;
                    return index;
                }
                case 3: {
                    if (!(this.visibleVCs[index] instanceof GraphicalViewConfiguration)) continue block5;
                    return index;
                }
            }
        }
        return -1;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        block18: {
            String propertyName = evt.getPropertyName();
            String removedFieldName = null;
            if (propertyName.equals("Property_Field_Updated")) {
                String newName;
                String oldName = ((QueryField)evt.getOldValue()).getName(true);
                if (!oldName.equals(newName = ((QueryField)evt.getNewValue()).getName(true))) {
                    SGELog.fine("updated field name changed (''{0}'' => ''{1}'", (Object)oldName, (Object)newName);
                    removedFieldName = oldName;
                }
            } else if (propertyName.equals("Property_Field_Removed")) {
                QueryField oldValue = (QueryField)evt.getOldValue();
                removedFieldName = oldValue.getName(true);
                SGELog.fine("field ''{0}' removed", (Object)removedFieldName);
            }
            if (removedFieldName != null) {
                block17: {
                    block16: {
                        if (this.dbTableVC != null) {
                            SGELog.fine("Table removing column: {0}", (Object)removedFieldName);
                            this.dbTableVC.removeColumn(removedFieldName);
                            try {
                                this.dbTableVC.isValid();
                            }
                            catch (IllegalStateException isEx) {
                                SGELog.warning((Throwable)isEx, "DB Table view configuration {0} is invalid: {1}", (Object)this.getAddress(), (Object)isEx);
                                this.dbTableVC = null;
                                int index = this.indexOf(1);
                                if (index <= -1) break block16;
                                this.setVisibleViewconfiguration(0, index);
                            }
                        }
                    }
                    if (this.pivotVC != null) {
                        this.pivotVC.removeColumnAttribute(removedFieldName);
                        this.pivotVC.removeRowAttribute(removedFieldName);
                        this.pivotVC.removeDataAttribute(removedFieldName);
                        try {
                            this.pivotVC.isValid();
                        }
                        catch (IllegalStateException isEx) {
                            SGELog.warning((Throwable)isEx, "Pivot of view configuration {0} is invalid: {1}", (Object)this.getAddress(), (Object)isEx);
                            this.pivotVC = null;
                            int index = this.indexOf(2);
                            if (index <= -1) break block17;
                            this.setVisibleViewconfiguration(0, index);
                        }
                    }
                }
                if (this.graphicalVC != null) {
                    this.graphicalVC.removeXValue(removedFieldName);
                    if (this.graphicalVC.getYValue().equals(removedFieldName)) {
                        this.graphicalVC.setYValue(null);
                    }
                    if (this.graphicalVC.getType() != null && this.graphicalVC.getType().equals(removedFieldName)) {
                        this.graphicalVC.setType(null);
                    }
                    try {
                        this.graphicalVC.isValid();
                    }
                    catch (IllegalStateException isEx) {
                        SGELog.warning((Throwable)isEx, "Graphical of view configuration {0} is invalid: {1}", (Object)this.getAddress(), (Object)isEx);
                        this.graphicalVC = null;
                        int index = this.indexOf(3);
                        if (index <= -1) break block18;
                        this.setVisibleViewconfiguration(0, index);
                    }
                }
            }
        }
    }

    public String getDefaultViewConfigurationName() {
        if (this.getDefaultViewConfigurationType() == 0) {
            return DEFAULTNAME4DEFAULTVC;
        }
        return this.getDefaultViewConfiguration().getName();
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("[" + this.getClass() + ":");
        retVal.append(" [DB-ViewConfiguration: " + this.dbTableVC);
        retVal.append("], [GraphicalViewConfiguration: " + this.graphicalVC);
        retVal.append("], [PivotViewConfiguration: " + this.pivotVC);
        retVal.append("], [List of selected Configurations: ");
        for (int i = 0; i < this.visibleVCs.length; ++i) {
            if (i > 0) {
                retVal.append(", ");
            }
            if (this.visibleVCs[i] == null) {
                retVal.append("NO_CONFIGURATION");
                continue;
            }
            if (this.visibleVCs[i] instanceof DBTableViewConfiguration) {
                retVal.append("DB_CONFIGURATION");
                continue;
            }
            if (this.visibleVCs[i] instanceof GraphicalViewConfiguration) {
                retVal.append("GRAPHICAL_CONFIGURATION");
                continue;
            }
            if (this.visibleVCs[i] instanceof PivotViewConfiguration) {
                retVal.append("PIVOT_CONFIGURATION");
                continue;
            }
            retVal.append("illegal value");
        }
        retVal.append("] ]");
        return retVal.toString();
    }

    public boolean isHideDescription() {
        return this.hideDescription;
    }

    public void setHideDescription(boolean hideDescription) {
        boolean oldValue = this.hideDescription;
        this.hideDescription = hideDescription;
        if (oldValue != hideDescription) {
            this.dataChanged = true;
        }
    }

    public boolean isHideSQLStatement() {
        return this.hideSQLStatement;
    }

    public void setHideSQLStatement(boolean hideSQLStatement) {
        boolean oldValue = this.hideSQLStatement;
        this.hideSQLStatement = hideSQLStatement;
        if (oldValue != hideSQLStatement) {
            this.dataChanged = true;
        }
    }

    public boolean isHideParameter() {
        return this.hideParameter;
    }

    public void setHideParameter(boolean hideParameter) {
        boolean oldValue = this.hideParameter;
        this.hideParameter = hideParameter;
        if (oldValue != hideParameter) {
            this.dataChanged = true;
        }
    }

    public boolean isValid() {
        int dbTableCount = 0;
        int pivotCount = 0;
        int graphicCount = 0;
        for (int i = 0; i < this.visibleVCs.length; ++i) {
            if (this.visibleVCs[i] instanceof DBTableViewConfiguration) {
                ++dbTableCount;
                continue;
            }
            if (this.visibleVCs[i] instanceof PivotViewConfiguration) {
                ++pivotCount;
                continue;
            }
            if (!(this.visibleVCs[i] instanceof GraphicalViewConfiguration)) continue;
            ++graphicCount;
        }
        return dbTableCount <= 1 && pivotCount <= 1 && graphicCount <= true;
    }

    public boolean hasDataChanged() {
        boolean retVal = this.dataChanged;
        return retVal;
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    public boolean hasNext() {
        for (int index = this.visibleVCsIteratorPos + 1; index < this.visibleVCs.length; ++index) {
            if (this.visibleVCs[index] == null) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        for (int index = this.visibleVCsIteratorPos + 1; index < this.visibleVCs.length; ++index) {
            if (this.visibleVCs[index] == null) continue;
            return this.visibleVCs[index];
        }
        return null;
    }

    public void remove() {
        this.visibleVCs[this.visibleVCsIteratorPos] = null;
    }

    public void setDefaultViewConfiguration(int type) {
        switch (type) {
            case 1: {
                if (this.dbTableVC != null && this.dbTableVC.isValid()) break;
                throw new IllegalArgumentException("The choosen Configuration is not valid.");
            }
            case 3: {
                if (this.graphicalVC != null && this.graphicalVC.isValid()) break;
                throw new IllegalArgumentException("The choosen Configuration is not valid.");
            }
            case 2: {
                if (this.pivotVC != null && this.pivotVC.isValid()) break;
                throw new IllegalArgumentException("The choosen Configuration is not valid.");
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The type is not allowed.");
            }
        }
        this.setVisibleViewconfiguration(type, 0);
    }

    public ViewConfiguration getDefaultViewConfiguration() {
        ViewConfiguration vc = null;
        int defaultVC = this.getDefaultViewConfigurationType();
        switch (defaultVC) {
            case 1: {
                vc = this.dbTableVC;
                break;
            }
            case 3: {
                vc = this.graphicalVC;
                break;
            }
            case 2: {
                vc = this.pivotVC;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("The type is not allowed.");
            }
        }
        return vc;
    }

    public int getDefaultViewConfigurationType() {
        return this.getViewConfigurationTypeAt(0);
    }
}

