/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.exception.ArcoException;
import com.sun.grid.reporting.model.AdvancedQuery;
import com.sun.grid.reporting.model.Query;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFieldManager;
import com.sun.grid.reporting.model.QueryFilter;
import com.sun.grid.reporting.model.QueryFilterManager;
import com.sun.grid.reporting.model.QueryProperties;
import com.sun.grid.reporting.model.QuerySortPair;
import com.sun.grid.reporting.sql.PostgreSQLGenerator;
import com.sun.grid.reporting.sql.SQLGenerator;
import com.sun.grid.reporting.util.FilterType;
import com.sun.grid.reporting.util.LogicalConnection;
import com.sun.grid.reporting.util.SortType;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class SimpleQuery
extends Query {
    public static final int LIMIT_RESET = -1;
    private QueryFilterManager filterManager = new QueryFilterManager();
    private QuerySortPair sort;
    private int rowLimit;
    private SQLGenerator sqlGenerator;
    private String sql;

    public SimpleQuery(SQLGenerator sqlGenerator) {
        super(false);
        this.sqlGenerator = sqlGenerator;
    }

    public QueryFilterManager getFilterManager() {
        return this.filterManager;
    }

    public void setFilterManager(QueryFilterManager filterManager) {
        this.filterManager = filterManager;
        this.setDataHasChanged(true);
    }

    public String getSQL() {
        return this.sqlGenerator.generateQuerySQL(this);
    }

    public QuerySortPair getSort() {
        return this.sort;
    }

    public void setSort(QuerySortPair p_sort) {
        this.sort = p_sort;
        this.setDataHasChanged(true);
    }

    public void setSort(QueryField field) {
        this.setSort(field, SortType.ASC);
    }

    public void setSort(QueryField field, SortType direction) {
        this.setSort(new QuerySortPair(field, direction));
    }

    public void setRowLimit(int limit) {
        this.rowLimit = limit;
        this.setDataHasChanged(true);
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public AdvancedQuery transformToAdvanced() throws ArcoException {
        AdvancedQuery retVal = new AdvancedQuery();
        retVal.setViewConfigurationManager(this.getViewConfigurationManager());
        retVal.setQueryProperties(this.getQueryProperties());
        retVal.setSQL(this.getSQL());
        return retVal;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("[Class: " + this.getClass() + "], ");
        retVal.append(this.getQueryProperties() + ", ");
        retVal.append("[Fields: ");
        Iterator it = this.getFieldManager().fields();
        while (it.hasNext()) {
            retVal.append(it.next());
            retVal.append("], ");
        }
        retVal.append("], ");
        retVal.append("[" + this.getFilterManager() + "], ");
        retVal.append("[" + this.getSQL() + "], ");
        return retVal.toString();
    }

    public static void main(String[] args) {
        SimpleQuery sq = new SimpleQuery(new PostgreSQLGenerator());
        QueryFilterManager filterManager = new QueryFilterManager();
        QueryFieldManager fieldManager = new QueryFieldManager();
        sq.setBaseTable("host_load");
        QueryField field = new QueryField();
        field.setName("Host");
        field.setDbFieldName("h_hostname");
        fieldManager.addField(field);
        field = new QueryField();
        field.setName("Startzeit");
        field.setDbFieldName("hv_time_start");
        fieldManager.addField(field);
        sq.setSort(field, SortType.ASC);
        field = new QueryField();
        field.setName("Wert");
        field.setDbFieldName("hv_value");
        fieldManager.addField(field);
        field = new QueryField();
        field.setDbFieldName("hv_variable");
        QueryFilter filter = new QueryFilter();
        filter.setField(field);
        filter.setFilterType(FilterType.EQUAL);
        filter.setParameter("load");
        filterManager.addFilter(filter);
        sq.setFilterManager(filterManager);
        sq.setRowLimit(5);
        QueryProperties property = new QueryProperties();
        property.setCreationDate(new Date());
        property.setName("Test-Query" + property.getCreationDate().toString());
        property.setDescription("This is a Test-Query just to test the queryProperties");
        try {
            property.setImageURL("http://pc137.pixel.de/~msu/sun");
        }
        catch (MalformedURLException mfurlEx) {
            mfurlEx.printStackTrace();
        }
        sq.setQueryProperties(property);
        System.out.println(sq);
    }

    public boolean hasDataChanged() {
        return super.hasDataChanged() || this.filterManager.hasDataChanged();
    }

    public String[] generateParameterArray() {
        int filterCount = this.filterManager.getActivatedFilterCount();
        String[] retVal = new String[filterCount];
        Iterator generateIt = this.filterManager.getActiveFilters();
        int counter = 0;
        while (generateIt.hasNext()) {
            QueryFilter filter = (QueryFilter)generateIt.next();
            StringBuffer value = new StringBuffer();
            LogicalConnection connection = filter.getLogicalConnection();
            if (connection != null) {
                value.append(" " + connection.getSymbol());
            }
            if (filter.getField().getName() != null) {
                value.append(" " + filter.getField().getName());
            } else {
                value.append(" " + filter.getField().generateName());
            }
            value.append(" " + filter.getFilterType().getSymbol());
            value.append(" " + filter.getParameter());
            retVal[counter++] = value.toString();
        }
        return retVal;
    }

    public String getUnparsedSQL() {
        return this.sqlGenerator.generateQuerySQL(this);
    }

    public boolean hasLateBindings() {
        return this.filterManager.hasLatebindedFilter();
    }

    public void setLatebindings(Properties latebindings) throws ArcoException {
        QueryFilter[] filters = new QueryFilter[this.filterManager.getFilterCount()];
        QueryFilterManager clone = (QueryFilterManager)this.getFilterManager().clone();
        Enumeration<?> names = latebindings.propertyNames();
        String name = null;
        String value = null;
        int index = -1;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = latebindings.getProperty(name);
            index = clone.getQueryFilterIndex(name);
            if (index < 0) {
                throw new ArcoException("SimpleQuery.queryFilterNotFound", new Object[]{name});
            }
            filters[index] = clone.getFilter(index);
            if (!filters[index].isLateBinding()) {
                throw new ArcoException("SimpleQuery.queryFilterHasNoLateBinding", new Object[]{name});
            }
            filters[index].setParameter(value);
        }
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] != null) continue;
            filters[i] = clone.getFilter(i);
            if (!filters[i].isLateBinding()) continue;
            throw new ArcoException("SimpleQuery.latebindingNotSet", new Object[]{filters[i].getField().getName(true)});
        }
        this.setFilterManager(clone);
    }
}

