/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.dob.DataObject;
import com.sun.grid.reporting.model.QueryProperties;
import com.sun.grid.reporting.model.ViewConfigurationManager;
import com.sun.grid.reporting.sql.SQLTableModel;
import java.util.Iterator;
import java.util.Vector;

public class Result {
    public static final int VISIBLELINES_DEFAULT = 50;
    private SQLTableModel value;
    private QueryProperties properties;
    private String baseTable;
    private ViewConfigurationManager viewConfigurationManager = new ViewConfigurationManager();
    private String sqlStatement;
    private Vector parameterList;
    private boolean bAdvanced = false;
    private int visibleLineCount = 50;
    private int pageCount;
    private int actualPage;
    private Vector SortWrapper = null;

    public Result() {
        this.properties = new QueryProperties();
    }

    public final int getLineCount() {
        if (this.value == null) {
            return 0;
        }
        return this.value.getRowCount();
    }

    public void setSortWrapper(Vector p_SortWrapper) {
        this.SortWrapper = p_SortWrapper;
    }

    public SQLTableModel getValue() {
        return this.value;
    }

    public void setValue(SQLTableModel value) {
        this.value = value;
    }

    public QueryProperties getProperties() {
        return this.properties;
    }

    public void setProperties(QueryProperties properties) {
        this.properties = properties;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(String baseTable) {
        this.baseTable = baseTable;
    }

    public void printValues() {
        Iterator<Vector> rowIt = this.value.getDataVector().iterator();
        while (rowIt.hasNext()) {
            Iterator valIt = rowIt.next().iterator();
            while (valIt.hasNext()) {
                System.out.print(valIt.next() + "\t|\t");
            }
            System.out.println();
        }
    }

    public ViewConfigurationManager getViewConfigurationManager() {
        return this.viewConfigurationManager;
    }

    public void setViewConfigurationManager(ViewConfigurationManager viewConfigurationManager) {
        this.viewConfigurationManager = viewConfigurationManager;
    }

    public String getSQLStatement() {
        return this.sqlStatement;
    }

    public void setSQLStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public Vector getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(String[] parameterArray) {
        this.parameterList = new Vector();
        for (int i = 0; i < parameterArray.length; ++i) {
            this.parameterList.add(parameterArray[i]);
        }
    }

    public int getActualPage() {
        return this.actualPage;
    }

    public void setActualPage(int actualPage) {
        this.actualPage = actualPage;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getVisibleLineCount() {
        return this.visibleLineCount;
    }

    public void setVisibleLineCount(int visibleLineCount) {
        this.visibleLineCount = visibleLineCount;
    }

    public Object getValueAt(int row, int column) {
        int wrappedRow = row + this.actualPage * this.visibleLineCount;
        if (null == this.SortWrapper) {
            return this.value.getValueAt(wrappedRow, column);
        }
        return this.value.getValueAt(this.getSortedWrappedRow(wrappedRow), column);
    }

    private int getSortedWrappedRow(int wrappedRow) {
        if (null == this.SortWrapper) {
            return wrappedRow;
        }
        DataObject dob = (DataObject)this.SortWrapper.get(wrappedRow);
        return dob.getIndex();
    }

    public boolean isAdvanced() {
        return true;
    }

    public void setAdvanced(boolean p_bAdvanced) {
        this.bAdvanced = p_bAdvanced;
    }
}

