/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFilter;
import java.util.Iterator;
import java.util.Vector;

public class QueryFilterManager
implements Cloneable {
    private Vector filterList = new Vector(0);
    private boolean dataChanged;

    public void addFilter(QueryFilter filter) {
        if (!this.filterList.contains(filter)) {
            this.filterList.add(filter);
        }
        this.setDataChanged(true);
    }

    public void removeFilter(QueryFilter filter) {
        if (this.filterList.contains(filter)) {
            this.filterList.remove(filter);
        }
        this.setDataChanged(true);
    }

    public void removeFilterAt(int index) {
        Object oldValue = this.filterList.remove(index);
        this.setDataChanged(true);
    }

    public void clear() {
        this.filterList.clear();
        this.filterList.setSize(0);
        this.setDataChanged(true);
    }

    public boolean hasFilter() {
        return this.filterList.size() > 0;
    }

    public boolean hasActiveFilter() {
        return this.getActiveFilters().hasNext();
    }

    public boolean hasLatebindedFilter() {
        return this.getLatebindedFilters().iterator().hasNext();
    }

    public int getFilterCount() {
        return this.filterList.size();
    }

    public int getActivatedFilterCount() {
        Iterator it = this.iterator();
        int count = 0;
        while (it.hasNext()) {
            QueryFilter filter = (QueryFilter)it.next();
            if (!filter.isActivated()) continue;
            ++count;
        }
        return count;
    }

    public int getLatebindedCount() {
        Iterator it = this.iterator();
        int count = 0;
        while (it.hasNext()) {
            QueryFilter filter = (QueryFilter)it.next();
            if (!filter.isLateBinding()) continue;
            ++count;
        }
        return count;
    }

    public QueryFilter getFilter(int index) {
        return (QueryFilter)this.filterList.get(index);
    }

    public Iterator getActiveFilters() {
        Vector<QueryFilter> filters = new Vector<QueryFilter>();
        Iterator filterIt = this.iterator();
        while (filterIt.hasNext()) {
            QueryFilter filter = (QueryFilter)filterIt.next();
            if (!filter.isActivated()) continue;
            filters.add(filter);
        }
        return filters.iterator();
    }

    public int getQueryFilterIndex(String name) {
        QueryFilter filter = null;
        for (int i = 0; i < this.filterList.size(); ++i) {
            filter = (QueryFilter)this.filterList.get(i);
            if (!filter.getField().getName(true).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Vector getLatebindedFilters() {
        Vector<QueryFilter> filters = new Vector<QueryFilter>();
        Iterator filterIt = this.iterator();
        while (filterIt.hasNext()) {
            QueryFilter filter = (QueryFilter)filterIt.next();
            if (!filter.isLateBinding()) continue;
            filters.add(filter);
        }
        return filters;
    }

    public Iterator iterator() {
        return this.filterList.iterator();
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("[Filters: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            retVal.append(it.next());
        }
        retVal.append("]");
        return retVal.toString();
    }

    public void removeFromFilterList(QueryField field) {
        Iterator filterIt = new Vector(this.filterList).iterator();
        while (filterIt.hasNext()) {
            QueryFilter filter = (QueryFilter)filterIt.next();
            if (!filter.getField().equals(field)) continue;
            this.filterList.remove(filter);
        }
    }

    public boolean hasDataChanged() {
        boolean result = this.dataChanged;
        Iterator findIt = this.filterList.iterator();
        while (!result && findIt.hasNext()) {
            QueryFilter f = (QueryFilter)findIt.next();
            result = result || f.hasDataChanged();
        }
        return result;
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    public void update(QueryFilter oldValue, QueryFilter newValue) {
        int index = this.filterList.indexOf(oldValue);
        this.update(oldValue, newValue, index);
    }

    public void update(QueryFilter newValue, int idx) {
        QueryFilter oldValue = (QueryFilter)this.filterList.get(idx);
        this.update(oldValue, newValue, idx);
    }

    private void update(QueryFilter oldValue, QueryFilter newValue, int idx) {
        if (oldValue.equals(newValue)) {
            return;
        }
        this.filterList.setElementAt(newValue, idx);
        this.setDataChanged(true);
    }

    public Object clone() {
        QueryFilterManager retVal = new QueryFilterManager();
        retVal.filterList = (Vector)this.filterList.clone();
        return retVal;
    }
}

