/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.util.FilterType;
import com.sun.grid.reporting.util.LogicalConnection;
import java.util.StringTokenizer;

public class QueryFilter {
    private QueryField field;
    private FilterType filterType;
    private String parameter = null;
    private LogicalConnection logicalConnection;
    private boolean activated = true;
    private boolean lateBinding = false;
    private boolean dataChanged;

    public QueryField getField() {
        return this.field;
    }

    public void setField(QueryField field) {
        this.field = field;
        this.setDataChanged(true);
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
        if (this.parameter != null && !this.testParameter(this.parameter)) {
            throw new IllegalStateException("The filterparameter does not concearn to the filtertype");
        }
        this.setDataChanged(true);
    }

    public LogicalConnection getLogicalConnection() {
        return this.logicalConnection;
    }

    public void setLogicalConnection(LogicalConnection logicalConnection) {
        this.logicalConnection = logicalConnection;
        this.setDataChanged(true);
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        if (!this.testParameter(parameter)) {
            throw new IllegalArgumentException("The parameter has an incorret stucture of the parameter: " + parameter);
        }
        this.parameter = parameter;
        this.setDataChanged(true);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
        this.setDataChanged(true);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryFilter)) {
            return false;
        }
        QueryFilter dummy = (QueryFilter)obj;
        if (!dummy.field.equals(this.field)) {
            return false;
        }
        if (!dummy.filterType.equals(this.filterType)) {
            return false;
        }
        return dummy.parameter.equals(this.parameter);
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("[Class: " + this.getClass() + "], ");
        retVal.append("[logical Connection: " + (Object)((Object)this.logicalConnection) + "], ");
        retVal.append("[Field: " + this.field + "], ");
        retVal.append("[operator: " + this.filterType.getSymbol() + "], ");
        retVal.append("[Parameters: " + this.parameter + "], ");
        retVal.append("[activated: " + Boolean.toString(this.activated) + "]");
        return retVal.toString();
    }

    private boolean testParameter(String testVal) {
        if (this.filterType == null) {
            return true;
        }
        if (this.filterType.equals(FilterType.BETWEEN)) {
            String delim = " AND ";
            StringTokenizer tok = new StringTokenizer(testVal.toUpperCase(), delim);
            if (tok.countTokens() == 2 && !testVal.toUpperCase().startsWith(delim) && !testVal.toUpperCase().endsWith(delim)) {
                return true;
            }
        } else {
            if (this.filterType.equals(FilterType.IN)) {
                String delim = ";";
                return true;
            }
            if (this.filterType.equals(FilterType.NOT_NULL) || this.filterType.equals(FilterType.NULL) ? testVal == null || testVal.equals("") : testVal != null) {
                return true;
            }
        }
        return false;
    }

    public boolean isLateBinding() {
        return this.lateBinding;
    }

    public void setLateBinding(boolean lateBinding) {
        this.lateBinding = lateBinding;
        this.setDataChanged(true);
    }

    public boolean hasDataChanged() {
        return this.dataChanged;
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }
}

