/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.model.QueryField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryFieldManager {
    public static final String PROPERTY_FIELD_REMOVED = "Property_Field_Removed";
    public static final String PROPERTY_FIELD_ADDED = "Property_Field_Added";
    public static final String PROPERTY_FIELD_UPDATED = "Property_Field_Updated";
    private ArrayList field;
    private boolean dataChanged;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public QueryFieldManager() {
        this.field = new ArrayList();
    }

    public void addField(QueryField field) throws IllegalArgumentException, IllegalStateException {
        SGELog.entering(this.getClass(), "addField");
        if (this.field.contains(field)) {
            throw new IllegalArgumentException("The field " + field.getName() + " is already selected");
        }
        String name = field.getName();
        if (name == null) {
            name = field.generateName();
        }
        if (this.getFieldByUserName(name) != null) {
            throw new IllegalStateException("The fieldname " + field.getName() + " seems not to be unique");
        }
        ArrayList oldValue = this.field;
        this.field.add(field);
        this.setDataChanged(true);
        this.firePropertyChanged(PROPERTY_FIELD_ADDED, oldValue, this.field);
        SGELog.fine("field ''{0}'' added}", (Object)name);
        SGELog.exiting(this.getClass(), "addField");
    }

    public void removeField(QueryField field) throws IllegalArgumentException {
        if (!this.field.contains(field)) {
            throw new IllegalArgumentException("The field is has not been selected");
        }
        QueryField oldValue = field;
        this.field.remove(field);
        SGELog.fine("field {0} removed", (Object)field.getName(true));
        this.setDataChanged(true);
        this.firePropertyChanged(PROPERTY_FIELD_REMOVED, oldValue, null);
    }

    public void removeAllFields() {
        while (this.field.size() > 0) {
            this.removeField(0);
        }
    }

    public QueryField removeField(int index) {
        QueryField oldValue = (QueryField)this.field.remove(index);
        SGELog.fine("field {0} removed", (Object)oldValue.getName(true));
        this.setDataChanged(true);
        this.firePropertyChanged(PROPERTY_FIELD_REMOVED, oldValue, null);
        return oldValue;
    }

    public void removeField(String name) {
        QueryField field = this.getFieldByUserName(name);
        if (field != null) {
            this.removeField(field);
        } else {
            SGELog.fine("field ''{0}'' not found", (Object)name);
        }
    }

    public List getFieldNames() {
        ArrayList<String> ret = new ArrayList<String>(this.field.size());
        for (int i = 0; i < this.field.size(); ++i) {
            ret.add(((QueryField)this.field.get(i)).getName(true));
        }
        return ret;
    }

    public int getFieldCount() {
        return this.field.size();
    }

    public Iterator fields() {
        return this.field.iterator();
    }

    public QueryField getFieldByUserName(String name) {
        Iterator findIt = this.fields();
        while (findIt.hasNext()) {
            QueryField f = (QueryField)findIt.next();
            String userDefName = f.getName(true);
            if (!userDefName.equals(name)) continue;
            return f;
        }
        SGELog.fine("No field with username ''{0}'' found", (Object)name);
        return null;
    }

    public boolean isUserDefined(String p_name) {
        Iterator findIt = this.fields();
        while (findIt.hasNext()) {
            QueryField f = (QueryField)findIt.next();
            String DBfieldName = f.getDbFieldName();
            if (!DBfieldName.equals(p_name)) continue;
            return false;
        }
        return true;
    }

    public boolean hasDataChanged() {
        boolean result = this.dataChanged;
        Iterator findIt = this.field.iterator();
        while (!result && findIt.hasNext()) {
            QueryField f = (QueryField)findIt.next();
            result = result || f.hasDataChanged();
        }
        return result;
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    public void addPropteryChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    private void firePropertyChanged(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, name, oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange(e);
    }

    public void update(QueryField oldValue, QueryField newValue) {
        int index = this.field.indexOf(oldValue);
        this.update(oldValue, newValue, index);
    }

    public void update(QueryField newValue, int idx) {
        QueryField oldValue = (QueryField)this.field.get(idx);
        this.update(oldValue, newValue, idx);
    }

    private void update(QueryField oldValue, QueryField newValue, int idx) {
        if (oldValue.equals(newValue)) {
            return;
        }
        String userdef_name = newValue.getName(true);
        QueryField testField = this.getFieldByUserName(userdef_name);
        if (testField != null && testField != oldValue) {
            throw new IllegalStateException("The fieldname " + userdef_name + " seems not to be unique");
        }
        this.field.set(idx, newValue);
        this.setDataChanged(true);
        this.firePropertyChanged(PROPERTY_FIELD_UPDATED, oldValue, newValue);
    }

    public void update(List fields) {
        ArrayList<QueryField> newList = new ArrayList<QueryField>();
        Iterator searchIt = fields.iterator();
        while (searchIt.hasNext()) {
            QueryField qf = (QueryField)searchIt.next();
            if (this.field.contains(qf)) continue;
            newList.add(qf);
        }
        ArrayList<QueryField> removeList = new ArrayList<QueryField>();
        searchIt = this.field.iterator();
        while (searchIt.hasNext()) {
            QueryField qf = (QueryField)searchIt.next();
            if (fields.contains(qf)) continue;
            removeList.add(qf);
        }
        Iterator removeIt = removeList.iterator();
        while (removeIt.hasNext()) {
            Object o = removeIt.next();
            this.removeField((QueryField)o);
        }
        Iterator addIt = newList.iterator();
        while (addIt.hasNext()) {
            Object o = addIt.next();
            this.addField((QueryField)o);
        }
    }
}

