/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.util.FieldFunction;

public class QueryField {
    private String name;
    private String dbFieldName;
    private FieldFunction aggregateFunction = FieldFunction.VALUE;
    private int fieldType = 1111;
    private String additionalParameter = null;
    private boolean dataChanged = false;

    public String getAdditionalParameter() {
        return this.additionalParameter;
    }

    public void setAdditionalParameter(String additionalParameter) {
        this.additionalParameter = additionalParameter;
        this.setDataChanged(true);
    }

    public FieldFunction getAggregateFunction() {
        return this.aggregateFunction;
    }

    public void setAggregateFunction(FieldFunction function) throws IllegalArgumentException {
        this.aggregateFunction = function;
        if (this.aggregateFunction == null) {
            this.aggregateFunction = FieldFunction.VALUE;
        }
        this.setDataChanged(true);
    }

    public void setAggregateFunction(String aggreagateFunction) {
        if (aggreagateFunction.toUpperCase().equals(FieldFunction.SUM.getName())) {
            this.setAggregateFunction(FieldFunction.SUM);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.COUNT.getName())) {
            this.setAggregateFunction(FieldFunction.COUNT);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.MAX.getName())) {
            this.setAggregateFunction(FieldFunction.MAX);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.MIN.getName())) {
            this.setAggregateFunction(FieldFunction.MIN);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.AVG.getName())) {
            this.setAggregateFunction(FieldFunction.AVG);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.VALUE.getName())) {
            this.setAggregateFunction(FieldFunction.VALUE);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.ADDITION.getName())) {
            this.setAggregateFunction(FieldFunction.ADDITION);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.SUBSTRACTION.getName())) {
            this.setAggregateFunction(FieldFunction.SUBSTRACTION);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.MULIPLY.getName())) {
            this.setAggregateFunction(FieldFunction.MULIPLY);
        } else if (aggreagateFunction.toUpperCase().equals(FieldFunction.DIVISION.getName())) {
            this.setAggregateFunction(FieldFunction.DIVISION);
        } else {
            throw new IllegalArgumentException("value of Parameter is not allowed");
        }
    }

    public String getDbFieldName() {
        return this.dbFieldName;
    }

    public void setDbFieldName(String dbFieldName) {
        this.dbFieldName = dbFieldName;
        this.setDataChanged(true);
    }

    public String getName() {
        return this.name;
    }

    public String getName(boolean bDontHide) {
        if (bDontHide) {
            if (null == this.name || this.name.equals("")) {
                return this.generateName();
            }
            return this.getName();
        }
        return this.getName();
    }

    public void setName(String name) {
        String tmpName = name;
        if (tmpName.startsWith("\"")) {
            tmpName = tmpName.substring(1);
        }
        if (tmpName.endsWith("\"")) {
            tmpName = tmpName.substring(0, tmpName.length() - 1);
        }
        this.name = name;
        this.setDataChanged(true);
    }

    public String generateName() {
        StringBuffer uDefName = new StringBuffer();
        if (FieldFunction.VALUE == this.aggregateFunction) {
            uDefName.append(this.dbFieldName);
        } else if (FieldFunction.ADDITION == this.aggregateFunction || FieldFunction.SUBSTRACTION == this.aggregateFunction || FieldFunction.DIVISION == this.aggregateFunction || FieldFunction.MULIPLY == this.aggregateFunction) {
            uDefName.append("(");
            uDefName.append(this.dbFieldName);
            uDefName.append(this.aggregateFunction.getName());
            uDefName.append(this.additionalParameter);
            uDefName.append(")");
        } else {
            uDefName.append(this.aggregateFunction.getName());
            uDefName.append("(");
            uDefName.append(this.dbFieldName);
            uDefName.append(")");
        }
        return uDefName.toString();
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("[Class: " + this.getClass() + "], ");
        retVal.append("[Database Fieldname: " + this.dbFieldName + "], ");
        retVal.append("[show field as : " + this.name + "], ");
        retVal.append("[Function of Field: " + this.aggregateFunction.getName() + "], ");
        retVal.append("[additional Parameters: " + this.additionalParameter + "], ");
        retVal.append("[generated Name: " + this.generateName() + "], ");
        retVal.append("[FieldType: " + this.fieldType + "]");
        return retVal.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryField)) {
            return false;
        }
        QueryField dummy = (QueryField)obj;
        boolean retVal = false;
        return (dummy.dbFieldName == this.dbFieldName || dummy.dbFieldName != null && dummy.dbFieldName.equals(this.dbFieldName)) && dummy.aggregateFunction == this.aggregateFunction && (dummy.additionalParameter == this.additionalParameter || dummy.additionalParameter != null && dummy.additionalParameter.equals(this.additionalParameter)) && (dummy.name == this.name || dummy.name != null && dummy.name.equals(this.name));
    }

    public boolean hasDataChanged() {
        return this.dataChanged;
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int fieldType) {
        this.fieldType = fieldType;
    }
}

