/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.exception.ArcoException;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFieldManager;
import com.sun.grid.reporting.model.QueryProperties;
import com.sun.grid.reporting.model.ViewConfigurationManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.Properties;

public abstract class Query
implements PropertyChangeListener {
    public static final String PROPERTY_FIELD_MANAGER = "fieldManager";
    public static final String PROPERTY_VIEW_CONFIGURATION_MANAGER = "ViewConfigurationManager";
    private String baseTable;
    private QueryProperties queryProperties;
    private QueryFieldManager fieldManager;
    private ViewConfigurationManager vcManager;
    protected String sqlStatement;
    private boolean dataChanged = false;
    private final boolean advancedQuery;
    private PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    protected Query(boolean isAdvanced) {
        this.queryProperties = new QueryProperties();
        this.fieldManager = new QueryFieldManager();
        this.vcManager = new ViewConfigurationManager();
        this.advancedQuery = isAdvanced;
        this.addPropertyChangeListener(this);
    }

    public QueryFieldManager getFieldManager() {
        return this.fieldManager;
    }

    public void addField(QueryField field) throws IllegalArgumentException {
        this.fieldManager.addField(field);
    }

    public void removeField(QueryField field) {
        this.fieldManager.removeField(field);
    }

    public int getFieldCount() {
        return this.fieldManager.getFieldCount();
    }

    public Iterator fields() {
        return this.fieldManager.fields();
    }

    public boolean hasDataChanged() {
        return this.dataChanged || this.fieldManager.hasDataChanged();
    }

    public void setDataHasChanged(boolean changed) {
        this.dataChanged = changed;
    }

    public ViewConfigurationManager getViewConfigurationManager() {
        return this.vcManager;
    }

    public void setViewConfigurationManager(ViewConfigurationManager vcm) {
        SGELog.entering(this.getClass(), "setViewConfigurationManager", (Object)vcm);
        ViewConfigurationManager oldValue = this.vcManager;
        this.vcManager = vcm;
        this.firePropertyChanged(PROPERTY_VIEW_CONFIGURATION_MANAGER, oldValue, this.vcManager);
        SGELog.entering(this.getClass(), "setViewConfigurationManager");
    }

    public abstract String getSQL();

    public abstract String getUnparsedSQL();

    public QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    public void setQueryProperties(QueryProperties queryProperties) {
        this.queryProperties = queryProperties;
    }

    public boolean isAdvancedQuery() {
        return this.advancedQuery;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(String baseTable) {
        this.baseTable = baseTable;
    }

    public abstract String[] generateParameterArray();

    public abstract boolean hasLateBindings();

    public abstract void setLatebindings(Properties var1) throws ArcoException;

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PROPERTY_FIELD_MANAGER)) {
            if (this.vcManager != null) {
                QueryFieldManager oldManager = (QueryFieldManager)evt.getOldValue();
                if (oldManager != null) {
                    oldManager.removePropertyChangeListener(this.vcManager);
                }
                if (this.fieldManager != null) {
                    this.fieldManager.addPropteryChangeListener(this.vcManager);
                }
            }
        } else if (evt.getPropertyName().equals(PROPERTY_VIEW_CONFIGURATION_MANAGER) && this.fieldManager != null) {
            ViewConfigurationManager oldManager = (ViewConfigurationManager)evt.getOldValue();
            if (oldManager != null) {
                this.fieldManager.removePropertyChangeListener(oldManager);
            }
            if (this.vcManager != null) {
                this.fieldManager.addPropteryChangeListener(this.vcManager);
            }
        }
        this.setDataHasChanged(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChange.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChange.removePropertyChangeListener(l);
    }

    private void firePropertyChanged(String name, Object oldValue, Object newValue) {
        this.propertyChange.firePropertyChange(name, oldValue, newValue);
    }
}

