/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.model.HtmlPivotTableGenerator;
import com.sun.grid.reporting.model.ViewConfiguration;
import com.sun.grid.reporting.sql.SQLTableModel;
import com.sun.grid.reporting.util.ArcoPivotTreeNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class PivotViewConfiguration
implements ViewConfiguration {
    public static final String DEFAULT_BORDER_ATTRIBUTES = "BORDER=\"1\"";
    public static final String VC_NAME = "pivot";
    private Vector rowValues;
    private Vector colValues;
    private String dataValue;
    private Vector dataValues;
    private final String dataDelimiter = "|";
    private SQLTableModel sqlTM;
    private ArcoPivotTreeNode rowHierachy;
    private ArcoPivotTreeNode columnHierachy;
    private Map rowHeaderObjects = new HashMap();
    private int childIndex;

    public PivotViewConfiguration() {
        this.rowValues = new Vector();
        this.colValues = new Vector();
        this.dataValues = new Vector();
    }

    public void setSQLTableModel(SQLTableModel sqlTM) {
        this.sqlTM = sqlTM;
    }

    public void addRowAttribute(String value) {
        SGELog.fine("entry: value = ''{0}''", (Object)value);
        if (this.rowValues.contains(value)) {
            throw new IllegalArgumentException("The value " + value + "cannot be added twice.");
        }
        this.rowValues.add(value);
    }

    public void removeRowAttribute(String value) {
        SGELog.fine("entry: value = {0}", (Object)value);
        if (this.rowValues.contains(value)) {
            this.rowValues.remove(value);
        }
    }

    public Iterator rowAttributes() {
        return this.rowValues.iterator();
    }

    public int getRowHierachyDepth() {
        return this.rowValues.size();
    }

    public void insertRowAttribute(String value, int index) {
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry: value = ''{0}'', index = {1}", (Object)value, (Object)new Integer(index));
        }
        if (this.rowValues.contains(value)) {
            throw new IllegalArgumentException("The value " + value + "cannot be added twice.");
        }
        if (index < 0 || index >= this.rowValues.size()) {
            throw new ArrayIndexOutOfBoundsException("The index must be in the range of 0 to " + this.rowValues.size());
        }
        this.rowValues.insertElementAt(value, index);
    }

    public void addColumnAttribute(String value) {
        SGELog.fine("entry: value = ''{0}''", (Object)value);
        if (this.colValues.contains(value)) {
            throw new IllegalArgumentException("The value " + value + "cannot be added twice.");
        }
        this.colValues.add(value);
    }

    public void removeColumnAttribute(String value) {
        SGELog.fine("entry: value = ''{0}''", (Object)value);
        if (this.colValues.contains(value)) {
            this.colValues.remove(value);
        }
    }

    public Iterator columnAttributes() {
        return this.colValues.iterator();
    }

    public int getColumnHierarchyDepth() {
        return this.colValues.size();
    }

    public void insertColumnAttribute(String value, int index) {
        if (this.colValues.contains(value)) {
            throw new IllegalArgumentException("The value " + value + "cannot be added twice.");
        }
        if (index < 0 || index >= this.rowValues.size()) {
            throw new ArrayIndexOutOfBoundsException("The index must be in the range of 0 to " + this.colValues.size());
        }
        this.colValues.insertElementAt(value, index);
    }

    public void addDataAttribute(String value) {
        SGELog.fine("entry: value = ''{0}''", (Object)value);
        if (this.dataValues.contains(value)) {
            throw new IllegalArgumentException("The value " + value + "cannot be added twice.");
        }
        this.dataValues.add(value);
    }

    public void removeDataAttribute(String value) {
        SGELog.fine("entry: value = ''{0}''", (Object)value);
        if (this.dataValues.contains(value)) {
            this.dataValues.remove(value);
        }
    }

    public Iterator dataAttributes() {
        return this.dataValues.iterator();
    }

    public void setDataAttribute(String value) {
        SGELog.fine("entry: value = ''{0}''", (Object)value);
        this.dataValue = value;
    }

    public String getDataAttributes() {
        return this.dataValue;
    }

    public void setResult(SQLTableModel sqlTM) {
        this.sqlTM = sqlTM;
    }

    public void buildTree() {
        SGELog.fine("entry");
        this.rowHierachy = new ArcoPivotTreeNode("Rowheader");
        this.columnHierachy = new ArcoPivotTreeNode("Columnheader");
        for (int row = 0; row < this.sqlTM.getRowCount(); ++row) {
            if (SGELog.isLoggable(Level.FINE)) {
                SGELog.fine("build row hiearchy for row {0}", new Integer(row));
            }
            this.rowHierachy = (ArcoPivotTreeNode)this.buildTreeNode(this.rowHierachy, this.rowValues, 0, row);
            if (SGELog.isLoggable(Level.FINE)) {
                SGELog.fine("build column hiearchy for row {0}", new Integer(row));
            }
            this.columnHierachy = (ArcoPivotTreeNode)this.buildTreeNode(this.columnHierachy, this.colValues, 0, row);
        }
        SGELog.fine("exit");
    }

    private MutableTreeNode buildTreeNode(ArcoPivotTreeNode node, Vector attributes, int pos, int row) {
        ArcoPivotTreeNode param;
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry, pos = {0}, row = {1}", new Integer(pos), (Object)new Integer(row));
        }
        String attribute = (String)attributes.get(pos);
        SGELog.fine("attribute = ''{0}''", (Object)attribute);
        int index = this.sqlTM.getColumnIndexByName((String)attributes.get(pos));
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("index = {0}", new Integer(index));
        }
        Object value = this.sqlTM.getValueAt(row, index);
        SGELog.fine("value = ''{0}''", value);
        boolean nodeExist = false;
        if (!node.isLeaf() && node.contains(value)) {
            param = (ArcoPivotTreeNode)node.getChild(value);
            SGELog.fine("node exits: {0}", param);
            nodeExist = true;
        } else {
            param = new ArcoPivotTreeNode(value);
            SGELog.fine("node does not exist, create it: {0}", param);
            nodeExist = false;
        }
        int nextPos = pos + 1;
        if (nextPos < attributes.size()) {
            param.setUserObject(value);
            node.add(this.buildTreeNode(param, attributes, nextPos, row));
        } else {
            String rowObj = "$_" + row;
            if (!param.contains(rowObj)) {
                ArcoPivotTreeNode rowNode = new ArcoPivotTreeNode(rowObj);
                rowNode.setAllowsChildren(false);
                param.add(rowNode);
            }
        }
        if (!nodeExist) {
            node.add(param);
        }
        return node;
    }

    public ArcoPivotTreeNode getRowHeader() {
        return this.rowHierachy;
    }

    public ArcoPivotTreeNode getColumnHeader() {
        return this.columnHierachy;
    }

    public Object getValueAt(int row, int column) {
        Object sqlRow = null;
        this.childIndex = -1;
        ArcoPivotTreeNode rowNode = (ArcoPivotTreeNode)this.getChildAt(this.rowHierachy, this.rowHierachy.getDepth() - 1, new int[]{row});
        this.childIndex = -1;
        ArcoPivotTreeNode columnNode = (ArcoPivotTreeNode)this.getChildAt(this.columnHierachy, this.columnHierachy.getDepth() - 1, new int[]{column});
        int childCount = rowNode.getChildCount();
        for (int counter = 0; sqlRow == null && counter < childCount; ++counter) {
            ArcoPivotTreeNode dummy = (ArcoPivotTreeNode)rowNode.getChildAt(counter);
            Object userObject = dummy.getUserObject();
            sqlRow = columnNode.getChild(userObject);
        }
        try {
            Iterator buildIt = this.dataAttributes();
            StringBuffer dataValue = new StringBuffer();
            while (buildIt.hasNext()) {
                Object data = null;
                String header = (String)buildIt.next();
                column = this.sqlTM.getColumnIndexByName(header);
                Object userObject = ((ArcoPivotTreeNode)sqlRow).getUserObject();
                row = Integer.parseInt(((String)userObject).substring(2));
                data = this.sqlTM.getValueAt(row, column);
                if (data == null || data.toString().equals("")) {
                    dataValue.append("");
                } else {
                    dataValue.append(data.toString());
                }
                if (!buildIt.hasNext()) continue;
                dataValue.append("|");
            }
            sqlRow = dataValue.toString();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return sqlRow;
    }

    private TreeNode getChildAt(ArcoPivotTreeNode node, int depth, int[] index) {
        TreeNode retVal = null;
        if (node.getLevel() < depth) {
            int childCount = node.getChildCount();
            for (int counter = 0; retVal == null && counter < childCount; ++counter) {
                ArcoPivotTreeNode childNode = (ArcoPivotTreeNode)node.getChildAt(counter);
                this.checkChildIndex(childNode, depth);
                retVal = this.getChildAt(childNode, depth, index);
            }
        } else if (this.childIndex == index[0]) {
            retVal = node;
            return retVal;
        }
        return retVal;
    }

    private void checkChildIndex(ArcoPivotTreeNode childNode, int depth) {
        if (childNode.getChildCount() > 0) {
            if (depth > 1) {
                if (childNode.getParent() != childNode.getRoot()) {
                    ++this.childIndex;
                }
            } else {
                ++this.childIndex;
            }
        }
    }

    public int getRowCount() {
        return this.getChildCount(this.rowHierachy, this.rowHierachy.getDepth() - 2);
    }

    public int getColumnCount() {
        return this.getChildCount(this.columnHierachy, this.columnHierachy.getDepth() - 2);
    }

    public int getChildCount(TreeNode node, int level) {
        if (((ArcoPivotTreeNode)node).getLevel() == level) {
            return node.getChildCount();
        }
        int result = 0;
        int childCount = node.getChildCount();
        for (int childNo = 0; childNo < childCount; ++childNo) {
            result += this.getChildCount(node.getChildAt(childNo), level);
        }
        return result;
    }

    public ArcoPivotTreeNode getTreeNodeAt(TreeNode node, int level, int index) {
        return (ArcoPivotTreeNode)this.getChildAt((ArcoPivotTreeNode)node, level, new int[]{index});
    }

    public boolean isValid() {
        if (this.rowValues == null || this.rowValues.size() < 1) {
            throw new IllegalStateException("There must be at least one value for the row in the Pivot-Configuration.");
        }
        if (this.colValues == null || this.colValues.size() < 1) {
            throw new IllegalStateException("There must be at least one value for the column in the Pivot-Configuration.");
        }
        if (this.dataValues == null) {
            throw new IllegalStateException("There must be at least one value for the data in the Pivot-Configuration.");
        }
        return true;
    }

    public String getHtmlPivotTable(String borderAttributes) {
        return HtmlPivotTableGenerator.instance().createPivotTable(this, borderAttributes);
    }

    public String getName() {
        return VC_NAME;
    }
}

