/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.model.LateBinding;
import com.sun.grid.reporting.model.MacroFactory;
import com.sun.grid.reporting.model.MacroStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MacroParser {
    private static final char LB = '{';
    private static final char RB = '}';
    private MacroStatement[] result;
    private String macroName;
    private String query;
    private String originalQuery;

    public MacroParser(String query) {
        if (query == null) {
            throw new NullPointerException("Query must not be null");
        }
        this.result = null;
        this.originalQuery = query;
        this.query = query.toUpperCase();
        this.macroName = "LATEBINDING";
    }

    public MacroStatement[] parse() {
        if (this.result == null) {
            ArrayList macros = new ArrayList();
            this.parse(0, macros);
            this.result = macros.toArray(new MacroStatement[0]);
        }
        return this.result;
    }

    private void parse(int start, List macros) {
        if ((start = this.query.indexOf(this.macroName, start)) < 0) {
            return;
        }
        int open = start + this.macroName.length();
        if (open > this.query.length() - 2 || this.query.charAt(open) != '{') {
            return;
        }
        int close = this.query.indexOf(125, open + 1);
        if (close <= open) {
            return;
        }
        String mn = this.originalQuery.substring(start, open);
        String m = this.originalQuery.substring(open + 1, close);
        MacroStatement ms = new MacroStatement(mn, m);
        macros.add(ms);
        this.parse(close + 1, macros);
    }

    public static String transformQuery(List macros, String query) {
        StringBuffer b = null;
        try {
            Iterator it = macros.iterator();
            while (it.hasNext()) {
                LateBinding macro;
                MacroStatement m;
                int start;
                if (b == null) {
                    b = new StringBuffer(query);
                }
                if ((start = b.indexOf((m = (macro = (LateBinding)it.next()).getStatement()).getName())) < 0) {
                    return null;
                }
                String sql = " " + MacroFactory.transformMacro(macro) + " ";
                int length = new StringBuffer(m.getName()).append('{').append(m.getStatement()).append('}').length();
                b.replace(start, start + length, sql);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return b.toString();
    }

    public static void main(String[] args) {
        String query = "where a < 10 and latebinding{a;eq;b} orlateBINding{name;not null;}";
        MacroParser p = new MacroParser(query);
        MacroStatement[] m = p.parse();
        System.out.println("query=" + query);
        System.out.println("macros=" + Arrays.asList(m));
        LateBinding[] lbs = new LateBinding[m.length];
        for (int i = 0; i < m.length; ++i) {
            lbs[i] = MacroFactory.createLateBinding(m[i]);
            System.out.println("lbs[" + i + "]=" + lbs[i]);
        }
        System.out.println("Transformed query:");
        String tq = MacroParser.transformQuery(Arrays.asList(lbs), query);
        System.out.println(tq);
    }
}

