/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.model.LateBinding;
import com.sun.grid.reporting.model.MacroStatement;
import java.text.ParseException;
import java.util.StringTokenizer;

public class MacroFactory {
    public static final String LATE_BINDING = "LATEBINDING";
    private static final String DELIMS = ";";

    public static LateBinding createLateBinding(MacroStatement ms) {
        String name = ms.getName();
        if (!LATE_BINDING.equals(name.toUpperCase())) {
            throw new IllegalArgumentException("MacroStatement contains wrong macro type");
        }
        return MacroFactory.parseStatement(ms);
    }

    private static LateBinding parseStatement(MacroStatement ms) {
        LateBinding lb = null;
        String s = ms.getStatement();
        String[] tokens = new String[3];
        StringTokenizer parser = new StringTokenizer(s, DELIMS);
        int i = 0;
        while (parser.hasMoreTokens()) {
            tokens[i++] = parser.nextToken();
        }
        if (tokens.length > 1) {
            lb = new LateBinding(tokens[0], tokens[1], null, ms);
            if (tokens.length > 2) {
                lb.setValue(tokens[2]);
            }
        }
        return lb;
    }

    public static String transformMacro(LateBinding m) throws ParseException {
        String s = m.getAttribute() + " " + m.getOperator() + " " + m.getValue();
        return s;
    }
}

