/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.util.ArcoPivotTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;

class HtmlPivotTableGenerator {
    private static HtmlPivotTableGenerator generator = new HtmlPivotTableGenerator();
    private static final String SPACE = "&nbsp";
    private Map rowHeaderObjects = new HashMap();
    private PivotViewConfiguration pvc;

    private HtmlPivotTableGenerator() {
    }

    public static HtmlPivotTableGenerator instance() {
        return generator;
    }

    public String createPivotTable(PivotViewConfiguration pvc, String borderAttributes) {
        this.pvc = pvc;
        this.rowHeaderObjects = new HashMap();
        borderAttributes = borderAttributes == null ? "" : borderAttributes;
        int rowMaxDepth = pvc.getRowHierachyDepth();
        int colMaxDepth = pvc.getColumnHierarchyDepth();
        StringBuffer b = new StringBuffer("<TABLE ").append("COLS=\"").append(pvc.getColumnCount()).append("\" ").append(borderAttributes).append(">");
        ArcoPivotTreeNode colHeader = pvc.getColumnHeader();
        for (int i = 1; i <= colMaxDepth; ++i) {
            ArrayList nodes = new ArrayList();
            this.getNodesForLevel(colHeader, i, true, nodes);
            b.append("<TR>");
            for (int n = 0; n < nodes.size(); ++n) {
                if (i == 1 && n == 0) {
                    b.append("<TH COLSPAN=\"").append(rowMaxDepth).append("\" ROWSPAN=\"").append(colMaxDepth).append("\"></TH>");
                }
                ArcoPivotTreeNode node = (ArcoPivotTreeNode)nodes.get(n);
                int cs = this.getMaxCellSpan(node, colMaxDepth);
                b.append("<TH COLSPAN=\"").append(cs).append("\">").append(node.getUserObject()).append("</TH>");
            }
            b.append("</TR>");
        }
        colHeader = null;
        ArcoPivotTreeNode rowHeader = pvc.getRowHeader();
        int rows = pvc.getRowCount();
        for (int row = 0; row < rows; ++row) {
            b.append("<TR>");
            for (int l = 1; l <= rowMaxDepth; ++l) {
                RowHeaderObject rho = this.getRowHeaderNodeForRow(row, l, rowMaxDepth);
                if (rho == null) continue;
                b.append("<TH ROWSPAN=\"").append(rho.rowSpan).append("\">").append(rho.node.getUserObject()).append("</TH>");
            }
            this.appendTableCellsForRow(b, row);
            b.append("</TR>");
        }
        b.append("</TABLE>");
        return b.toString();
    }

    private RowHeaderObject getRowHeaderNodeForRow(int row, int level, int maxDepth) {
        Integer iLevel = new Integer(level);
        HashMap<Integer, RowHeaderObject> column = (HashMap<Integer, RowHeaderObject>)this.rowHeaderObjects.get(iLevel);
        if (column == null) {
            column = new HashMap<Integer, RowHeaderObject>();
            this.rowHeaderObjects.put(iLevel, column);
            ArrayList result = new ArrayList();
            this.getNodesForLevel(this.pvc.getRowHeader(), level, false, result);
            int lastAccumSpan = 0;
            for (int i = 0; i < result.size(); ++i) {
                ArcoPivotTreeNode node = (ArcoPivotTreeNode)result.get(i);
                int span = this.getMaxCellSpan(node, maxDepth);
                RowHeaderObject rho = new RowHeaderObject();
                rho.node = node;
                rho.rowSpan = span;
                rho.accumSpans = span + lastAccumSpan;
                column.put(new Integer(lastAccumSpan), rho);
                lastAccumSpan = rho.accumSpans;
            }
        }
        Integer iRow = new Integer(row);
        Object o = column.get(iRow);
        return (RowHeaderObject)o;
    }

    private void appendTableCellsForRow(StringBuffer b, int row) {
        int cols = this.pvc.getColumnCount();
        for (int c = 0; c < cols; ++c) {
            Object cell = this.pvc.getValueAt(row, c);
            if (cell == null) {
                cell = SPACE;
            }
            b.append("<TD ALIGN=RIGHT>").append(cell).append("</TD>");
        }
    }

    private void getMaxCellSpan(ArcoPivotTreeNode node, CellSpan csp, int maxDepth) {
        int level = node.getLevel();
        if (level == maxDepth - 1) {
            csp.span += node.getChildCount();
        } else {
            for (int c = 0; c < node.getChildCount(); ++c) {
                ArcoPivotTreeNode n = (ArcoPivotTreeNode)node.getChildAt(c);
                this.getMaxCellSpan(n, csp, maxDepth);
            }
        }
    }

    public int getMaxCellSpan(ArcoPivotTreeNode node, int maxDepth) {
        CellSpan csp = new CellSpan();
        this.getMaxCellSpan(node, csp, maxDepth);
        return csp.span == 0 ? 1 : csp.span;
    }

    private void getNodesForLevel(ArcoPivotTreeNode node, int level, boolean isCols, List result) {
        int l;
        if (node == null) {
            ArcoPivotTreeNode arcoPivotTreeNode = node = isCols ? this.pvc.getColumnHeader() : this.pvc.getRowHeader();
        }
        if ((l = node.getLevel()) == level) {
            ArcoPivotTreeNode parent = (ArcoPivotTreeNode)node.getParent();
            if (parent == null) {
                result.add(node);
            } else {
                ArcoPivotTreeNode pp = (ArcoPivotTreeNode)parent.getParent();
                if (pp == null) {
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        result.add(parent.getChildAt(i));
                    }
                } else {
                    for (int i = 0; i < pp.getChildCount(); ++i) {
                        TreeNode ch = pp.getChildAt(i);
                        Enumeration<? extends TreeNode> e = ch.children();
                        while (e.hasMoreElements()) {
                            result.add(e.nextElement());
                        }
                    }
                }
            }
            return;
        }
        int cc = node.getChildCount();
        if (cc == 0) {
            SGELog.fine("current level={0}, target level=1, node = {1} has no children", new Integer(level), node.getUserObject());
            return;
        }
        ArcoPivotTreeNode c0 = (ArcoPivotTreeNode)node.getChildAt(0);
        this.getNodesForLevel(c0, level, isCols, result);
    }

    private static final class CellSpan {
        int span;

        private CellSpan() {
        }
    }

    private static final class RowHeaderObject {
        ArcoPivotTreeNode node;
        int rowSpan;
        int accumSpans;

        private RowHeaderObject() {
        }
    }
}

