/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.reporting.model.ViewConfiguration;
import com.sun.grid.reporting.viewconfiguration.ChartTypes;
import java.util.Vector;

public class GraphicalViewConfiguration
implements ViewConfiguration {
    public static final String VC_NAME = "graphic";
    private ChartTypes chartType;
    private Vector xValues;
    private String yValues;
    private String lines;
    private boolean hideLegend = false;

    public void setCharType(ChartTypes type) {
        this.chartType = type;
        this.xValues = null;
        this.yValues = null;
        this.lines = null;
    }

    public ChartTypes getChartType() {
        return this.chartType;
    }

    public void addXValue(String xValue) {
        int elementCount = this.chartType.getChartInfo()[0];
        if (this.xValues == null) {
            this.xValues = new Vector(elementCount);
        }
        if (this.xValues.size() >= elementCount) {
            throw new IllegalStateException("The charttype " + this.chartType.getName() + " allowes only " + elementCount + " values for the x-Axis");
        }
        this.xValues.add(xValue);
    }

    public Vector getXValues() {
        return this.xValues;
    }

    public void removeXValue(String xValue) {
        if (this.xValues.contains(xValue)) {
            this.xValues.remove(xValue);
        }
    }

    public void setYValue(String yValue) {
        int elementCount = this.chartType.getChartInfo()[1];
        if (elementCount == 0) {
            throw new IllegalStateException("The charttype " + this.chartType.getName() + " allowes only " + elementCount + " values for the y-Axis");
        }
        this.yValues = yValue;
    }

    public String getYValue() {
        return this.yValues;
    }

    public void setType(String type) {
        int elementCount = this.chartType.getChartInfo()[2];
        if (elementCount == 0) {
            throw new IllegalStateException("The charttype " + this.chartType.getName() + " allowes only " + elementCount + " values for the type.");
        }
        this.lines = type;
    }

    public String getType() {
        return this.lines;
    }

    public boolean isValid() {
        if (this.xValues == null || this.xValues.size() < 1) {
            throw new IllegalStateException("At least there must be defined one value for the x-axis in the graphical-viewconfiguration.");
        }
        if (this.yValues == null) {
            throw new IllegalStateException("There must be defined a value for the y-axis in the graphical-viewconfiguration.");
        }
        if (this.chartType.getChartInfo()[2] != 0 && this.lines == null) {
            throw new IllegalStateException("There must be defined a value for the for the line-type in the graphical-viewconfiguration.");
        }
        return true;
    }

    public String getName() {
        return VC_NAME;
    }

    public boolean isHideLegend() {
        return this.hideLegend;
    }

    public void setHideLegend(boolean hideLegend) {
        if (!this.isHideLegendAllowed()) {
            throw new IllegalStateException("The legend for a " + this.chartType.getName() + " graphical viewconfiguration is not permitted to be changed!");
        }
        this.hideLegend = hideLegend;
    }

    public boolean isHideLegendAllowed() {
        return this.chartType.isHideLegendAllowed();
    }
}

