/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.model;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.exception.ArcoException;
import com.sun.grid.reporting.model.LateBinding;
import com.sun.grid.reporting.model.MacroFactory;
import com.sun.grid.reporting.model.MacroParser;
import com.sun.grid.reporting.model.MacroStatement;
import com.sun.grid.reporting.model.Query;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFieldManager;
import com.sun.grid.reporting.sql.SQLParser;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class AdvancedQuery
extends Query {
    private String unparsedSQL;
    private MacroParser macroParser;
    private Vector lateBindings = new Vector();
    private Vector originalLateBinding = new Vector();

    public AdvancedQuery() {
        super(true);
    }

    public String getSQL() {
        if (this.hasLateBindings()) {
            if (this.lateBindings == null || this.lateBindings.size() == 0) {
                LateBinding[] lb = new LateBinding[this.originalLateBinding.size()];
                for (int i = 0; i < lb.length; ++i) {
                    lb[i] = (LateBinding)((LateBinding)this.originalLateBinding.get(i)).clone();
                }
                this.replaceLateBindings(lb);
            }
            this.sqlStatement = MacroParser.transformQuery(this.lateBindings, this.unparsedSQL);
        } else {
            this.sqlStatement = this.unparsedSQL;
        }
        return this.sqlStatement;
    }

    public void setSQL(String sqlStatement) throws ArcoException {
        this.setUnparsedSQL(sqlStatement);
    }

    private void setUnparsedSQL(String sqlStatement) throws ArcoException {
        if (!sqlStatement.toLowerCase().startsWith("select")) {
            throw new IllegalArgumentException("SQL-Statement is not allowed");
        }
        if (this.unparsedSQL == null || !this.unparsedSQL.equals(sqlStatement)) {
            this.unparsedSQL = sqlStatement;
            this.createLateBindingList();
            this.updateFieldList();
        }
    }

    public String getUnparsedSQL() {
        return this.unparsedSQL;
    }

    private void updateFieldList() throws ArcoException {
        SGELog.entering(this.getClass(), "updateFieldList");
        QueryFieldManager fm = this.getFieldManager();
        if (this.unparsedSQL == null || this.unparsedSQL.equals("")) {
            SGELog.warning("No Fieldlist generated because no SQL-Statement has been set.");
            if (fm != null) {
                fm.removeAllFields();
            }
        } else {
            SQLParser parser = new SQLParser(this.unparsedSQL);
            SQLParser.Field field = null;
            try {
                parser.parse();
            }
            catch (ParseException pe) {
                ArcoException ae = new ArcoException("AdvancedQuery.parseError", pe);
            }
            Iterator iter = parser.getFieldList().iterator();
            List fieldNames = fm.getFieldNames();
            QueryField f = null;
            String userName = null;
            boolean newFieldFlag = false;
            while (iter.hasNext()) {
                field = (SQLParser.Field)iter.next();
                userName = field.getName() == null ? field.getExpr() : field.getName();
                f = fm.getFieldByUserName(userName);
                if (f == null) {
                    newFieldFlag = true;
                    f = new QueryField();
                    f.setName(userName);
                } else {
                    newFieldFlag = false;
                }
                f.setDbFieldName(field.getExpr());
                if (newFieldFlag) {
                    fm.addField(f);
                    continue;
                }
                fieldNames.remove(userName);
            }
            iter = fieldNames.iterator();
            while (iter.hasNext()) {
                fm.removeField((String)iter.next());
            }
        }
    }

    public void OLDcreateFieldList() {
        if (this.unparsedSQL == null || this.unparsedSQL.equals("")) {
            SGELog.warning("No Fieldlist generated because no SQL-Statement has been set.");
        }
        int start = this.unparsedSQL.toLowerCase().indexOf("select") + "select".length();
        int end = this.unparsedSQL.toLowerCase().indexOf("from");
        StringTokenizer fieldlist = new StringTokenizer(this.unparsedSQL.substring(start, end).trim(), ",");
        QueryFieldManager fm = new QueryFieldManager();
        while (fieldlist.hasMoreTokens()) {
            QueryField f = new QueryField();
            String fieldname = fieldlist.nextToken();
            int pos = (fieldname = this.trimQuotation(fieldname)).toLowerCase().indexOf("as");
            if (pos == -1) {
                f.setDbFieldName(fieldname);
                f.setName(fieldname);
            } else {
                f.setDbFieldName(fieldname.substring(0, pos).trim());
                f.setName(fieldname.substring(pos + "as ".length(), fieldname.length()));
            }
            fm.addField(f);
        }
    }

    public boolean hasLateBindings() {
        return this.originalLateBinding.size() > 0;
    }

    private void createLateBindingList() {
        MacroParser mp = new MacroParser(this.unparsedSQL);
        this.originalLateBinding = new Vector();
        MacroStatement[] ms = mp.parse();
        if (ms != null) {
            for (int counter = 0; counter < ms.length; ++counter) {
                this.originalLateBinding.add(MacroFactory.createLateBinding(ms[counter]));
            }
        }
    }

    public String toString() {
        return this.getSQL();
    }

    public Vector getLatebindings() {
        return this.originalLateBinding;
    }

    public void replaceLateBindings(LateBinding[] latebindings) {
        if (latebindings.length != this.originalLateBinding.size()) {
            throw new IllegalStateException("The number of latebindings to reset does not match the calculated number of latebindings.");
        }
        this.lateBindings = new Vector(this.originalLateBinding.size());
        for (int counter = 0; counter < latebindings.length; ++counter) {
            this.lateBindings.add(counter, latebindings[counter]);
        }
    }

    public String[] generateParameterArray() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public static void main(String[] args) {
        AdvancedQuery advQuery = new AdvancedQuery();
        if (args.length == 0) {
            throw new IllegalStateException("Missing a Parameter");
        }
        for (int parameter = 0; parameter < args.length; ++parameter) {
            try {
                advQuery.setUnparsedSQL(args[0]);
            }
            catch (ArcoException e) {
                e.printStackTrace();
            }
            if (advQuery.hasLateBindings()) {
                Vector lb = advQuery.getLatebindings();
                System.out.println(lb);
                LateBinding[] lbArr = new LateBinding[lb.size()];
                for (int i = 0; i < lb.size(); ++i) {
                    lbArr[i] = (LateBinding)((LateBinding)lb.get(i)).clone();
                    lbArr[i].setValue(Integer.toString(i));
                }
                advQuery.replaceLateBindings(lbArr);
                lb = advQuery.getLatebindings();
                System.out.println(lb);
            }
            System.out.println("SQL: " + advQuery.getSQL());
            System.out.println("SQL: " + advQuery.getUnparsedSQL());
        }
    }

    private String trimQuotation(String text) {
        SGELog.entering(this.getClass(), "trimQuotation", (Object)text);
        text = text.trim();
        if (text.startsWith("\"")) {
            text = text.substring(1);
        }
        if (text.endsWith("\"")) {
            text = text.substring(0, text.length() - 1);
        }
        SGELog.exiting(this.getClass(), "trimQuotation", (Object)text);
        return text;
    }

    private int getLateBindingIndex(String name) {
        for (int i = 0; i < this.originalLateBinding.size(); ++i) {
            if (!((LateBinding)this.originalLateBinding.get(i)).getAttribute().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private LateBinding getLateBinding(int index) {
        return (LateBinding)this.originalLateBinding.get(index);
    }

    public void setLatebindings(Properties latebindings) throws ArcoException {
        LateBinding[] lb = new LateBinding[this.originalLateBinding.size()];
        Enumeration<?> bindingNames = latebindings.propertyNames();
        int index = -1;
        while (bindingNames.hasMoreElements()) {
            String name = (String)bindingNames.nextElement();
            String value = latebindings.getProperty(name);
            index = this.getLateBindingIndex(name);
            if (index < 0) {
                throw new ArcoException("AdvancedQuery.lateBindingNotFound", new Object[]{name});
            }
            lb[index] = (LateBinding)this.getLateBinding(index).clone();
            lb[index].setValue(value);
        }
        for (int i = 0; i < lb.length; ++i) {
            if (lb[index] != null) continue;
            throw new ArcoException("AdvancedQuery.lateBindingNotSet", new Object[]{this.getLateBinding(index).getAttribute()});
        }
        this.replaceLateBindings(lb);
    }
}

