/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.io;

import com.sun.grid.reporting.util.PropertyKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class SaveXML {
    private int indentionDepth = 0;
    protected OutputStream os;
    private Properties storageProperties;
    protected String subPath;
    protected String storagePath;

    public SaveXML(Properties storageProperties) {
        this.storageProperties = storageProperties;
    }

    protected OutputStream openFile(String name) {
        try {
            System.out.println("the File to be saved is: " + name);
            File f = new File(name);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream retVal = new FileOutputStream(name.toString());
            return retVal;
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            return null;
        }
    }

    protected String createPath(String name) {
        if (this.storageProperties == null) {
            throw new NullPointerException("No StorageProperties have been set to save the result.");
        }
        if (name == null) {
            throw new IllegalStateException("Unnamed Result cannot be saved");
        }
        StringBuffer path = new StringBuffer(this.storageProperties.getProperty(PropertyKey.DATA_STORAGE_PATH_COMMON.getName()));
        path.append(File.separator);
        path.append(this.storageProperties.getProperty(this.subPath));
        File f_path = new File(path.toString());
        if (!f_path.exists()) {
            f_path.mkdirs();
        }
        path.append(File.separator);
        this.storagePath = path.toString();
        path.append(name);
        return path.toString();
    }

    protected void writeHeader(Document doc) throws IOException {
        DocumentType dt = doc.getDoctype();
        StringBuffer msg = new StringBuffer("<?xml ");
        msg.append("version=\"1.0\" ?>\n");
        this.os.write(msg.toString().getBytes());
        msg = new StringBuffer("<!DOCTYPE ");
        msg.append(dt.getName());
        msg.append(" SYSTEM \"" + dt.getSystemId());
        msg.append("\" >\n");
        this.os.write(msg.toString().getBytes());
    }

    protected void writeStartTag(String tag) throws IOException {
        StringBuffer msg = new StringBuffer(this.indention());
        msg.append("<" + tag + ">\n");
        ++this.indentionDepth;
        this.os.write(msg.toString().getBytes());
    }

    protected void writeEndTag(String tag) throws IOException {
        --this.indentionDepth;
        StringBuffer msg = new StringBuffer(this.indention());
        msg.append("</" + tag + ">\n");
        this.os.write(msg.toString().getBytes());
    }

    protected String indention() {
        StringBuffer retVal = new StringBuffer();
        for (int i = 0; i < this.indentionDepth; ++i) {
            retVal.append("  ");
        }
        return retVal.toString();
    }

    protected void writeTextNode(String tagName, String data) throws IOException {
        StringBuffer msg = new StringBuffer(this.indention());
        msg.append("<" + tagName + ">");
        msg.append(data);
        msg.append("</" + tagName + ">\n");
        this.os.write(msg.toString().getBytes());
    }

    protected void writeEmptyTag(String tag) throws IOException {
        StringBuffer msg = new StringBuffer(this.indention());
        msg.append("<" + tag + " />\n");
        this.os.write(msg.toString().getBytes());
    }

    public String getStoragePath() {
        return this.storagePath;
    }
}

