/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.io;

import com.sun.grid.arco.ResultConverter;
import com.sun.grid.arco.ResultManager;
import com.sun.grid.reporting.io.SaveXML;
import com.sun.grid.reporting.model.Result;
import com.sun.grid.reporting.util.PropertyKey;
import com.sun.grid.reporting.xml.GenerateResultXML;
import com.sun.grid.reporting.xml.XMLTag;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SaveResultXML
extends SaveXML {
    private boolean export;
    private String exportFileName;

    public SaveResultXML(Properties storageProperties) {
        super(storageProperties);
        this.export = false;
        this.subPath = PropertyKey.DATA_STORAGE_SUBPATH_RESULTS.getName();
    }

    public SaveResultXML(String name, boolean export) {
        super(null);
        this.export = export;
        this.exportFileName = name;
    }

    protected String createPath(String name) {
        if (this.export) {
            this.storagePath = File.separatorChar + "tmp" + File.separatorChar;
            return this.storagePath + this.exportFileName;
        }
        return super.createPath(name);
    }

    public void save(Result result) throws IllegalStateException, IOException {
        String name = result.getProperties().getName();
        name = this.createPath(name);
        com.sun.grid.arco.model.Result xmlResult = ResultConverter.toXML(result);
        ResultManager.getInstance().save((Object)xmlResult, new File(name + ".xml"));
    }

    private Document generateXML(Result result) {
        GenerateResultXML r2x = new GenerateResultXML(result);
        r2x.generate();
        return r2x.getXMLDocument();
    }

    private void visitElement_root(Element element) throws IOException {
        this.writeStartTag(element.getTagName());
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.RESULT.getElement())) {
                        this.visitElement_result(nodeElement);
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.RESULT_DESCRIPTION.getElement())) continue block3;
                    this.visitElement_description(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_result(Element element) throws IOException {
        this.writeStartTag(element.getTagName());
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.HEADER.getElement())) {
                        this.visitElement_header(nodeElement);
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.DATA.getElement())) continue block3;
                    this.visitElement_data(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_description(Element element) throws IOException {
        this.writeStartTag(element.getTagName());
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals(XMLTag.RESULT_FILTERLIST.getElement())) {
                        this.visitElement_filterlist(nodeElement);
                    }
                    if (!nodeElement.getTagName().equals(XMLTag.SQL.getElement())) continue block3;
                    this.visitElement_value(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_filterlist(Element element) throws IOException {
        this.writeStartTag(element.getTagName());
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.RESULT_FILTER.getElement())) continue block3;
                    this.visitElement_value(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_header(Element element) throws IOException {
        this.writeStartTag(element.getTagName());
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.COLUMN.getElement())) continue block3;
                    this.visitElement_column(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_data(Element element) throws IOException {
        this.writeStartTag(element.getTagName());
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.ROW.getElement())) continue block3;
                    this.visitElement_row(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_row(Element element) throws IOException {
        this.writeStartTag(element.getTagName());
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.COLUMN.getElement())) continue block3;
                    this.visitElement_column(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_column(Element element) throws IOException {
        StringBuffer tag = new StringBuffer(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            tag.append(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
            if (++i >= attrs.getLength()) continue;
            tag.append(",");
        }
        this.writeStartTag(tag.toString());
        NodeList nodes = element.getChildNodes();
        block4: for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(XMLTag.VALUE.getElement())) continue block4;
                    this.visitElement_value(nodeElement);
                }
            }
        }
        this.writeEndTag(element.getTagName());
    }

    private void visitElement_value(Element element) throws IOException {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    continue block4;
                }
                case 3: {
                    this.writeTextNode(element.getTagName(), ((Text)node).getData());
                }
            }
        }
    }
}

