/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.export;

import com.sun.grid.reporting.ArcoModelBean;
import com.sun.grid.reporting.export.ExportContext;
import com.sun.grid.reporting.export.HTMLResultExport;
import com.sun.grid.reporting.export.PDFResultExport;
import com.sun.grid.reporting.export.ResultExport;
import com.sun.grid.reporting.export.XMLResultExport;
import com.sun.grid.reporting.export.XSLResultExport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;

public class ResultExportManager {
    Map exportMap = new HashMap();
    private static Properties props;
    public static final String PROPERTIES = "com/sun/grid/reporting/export/ResultExport.properties";
    static /* synthetic */ Class class$com$sun$grid$reporting$export$ResultExportManager;

    public ResultExportManager(File basedir) {
        this.exportMap.put("csv", new XSLResultExport("text/csv", new File(basedir, "xslt/result2csv.xsl")));
        this.exportMap.put("pdf", new PDFResultExport(basedir));
        this.exportMap.put("xml", new XMLResultExport());
        this.exportMap.put("html", new HTMLResultExport(basedir));
    }

    private ResultExport getExportInstance(String type) {
        return (ResultExport)this.exportMap.get(type.toLowerCase());
    }

    public String getMimeType(String exportType) {
        ResultExport export = this.getExportInstance(exportType);
        if (export != null) {
            return export.getMimeType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String type, ArcoModelBean model, File file) throws IOException, TransformerException {
        ResultExport export = this.getExportInstance(type);
        if (export == null) {
            throw new IllegalArgumentException("export type " + type + " is unknown");
        }
        ExportContext ctx = new ExportContext(model, file);
        try {
            export.export(ctx);
        }
        finally {
            ctx.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String type, ArcoModelBean model, OutputStream out) throws IOException, TransformerException {
        ResultExport export = this.getExportInstance(type);
        if (export == null) {
            throw new IllegalArgumentException("export type " + type + " is unknown");
        }
        ExportContext ctx = new ExportContext(model, out);
        try {
            export.export(ctx);
        }
        finally {
            ctx.cleanup();
        }
    }

    public static Properties getProperties() {
        if (props == null) {
            try {
                Properties tmpProps = new Properties();
                InputStream in = (class$com$sun$grid$reporting$export$ResultExportManager == null ? (class$com$sun$grid$reporting$export$ResultExportManager = ResultExportManager.class$("com.sun.grid.reporting.export.ResultExportManager")) : class$com$sun$grid$reporting$export$ResultExportManager).getClassLoader().getResourceAsStream(PROPERTIES);
                tmpProps.load(in);
                props = tmpProps;
            }
            catch (IOException ioe) {
                IllegalStateException ilse = new IllegalStateException("Can't load properties com/sun/grid/reporting/export/ResultExport.properties");
                ilse.initCause(ioe);
                throw ilse;
            }
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

